/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieRebuildImageCacheAction
extends TmmAction {
    private static final long serialVersionUID = -5089957097690621345L;

    public MovieRebuildImageCacheAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.rebuildimagecache"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.rebuildimagecache"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        if (!Settings.getInstance().isImageCache()) {
            JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("tmm.imagecache.notactivated"));
            return;
        }
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        ArrayList<MediaFile> imageFiles = new ArrayList<MediaFile>();
        for (Movie movie : selectedMovies) {
            imageFiles.addAll(movie.getImagesToCache());
            ImageCache.clearImageCacheForMediaEntity(movie);
        }
        ImageCacheTask task = new ImageCacheTask(imageFiles);
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

