/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieRenamerPreviewDialog;

public class MovieRenamePreviewAction
extends TmmAction {
    private static final long serialVersionUID = 5158514686702295145L;

    public MovieRenamePreviewAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.renamepreview"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.renamepreview.hint"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MovieRenamerPreviewDialog dialog = new MovieRenamerPreviewDialog(selectedMovies);
        dialog.setVisible(true);
    }
}

