/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieRewriteNfoAction
extends TmmAction {
    private static final long serialVersionUID = 2866581962767395824L;

    public MovieRewriteNfoAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.rewritenfo"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("movie.rewritenfo"), selectedMovies.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (Movie movie : selectedMovies) {
                    movie.writeNFO();
                    movie.saveToDb();
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

