/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieToggleWatchedFlagAction
extends TmmAction {
    private static final long serialVersionUID = 2866581962767395824L;

    public MovieToggleWatchedFlagAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.togglewatchedflag"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        Iterator iterator = selectedMovies.iterator();
        while (iterator.hasNext()) {
            Movie movie;
            movie.setWatched(!(movie = (Movie)iterator.next()).isWatched());
            movie.writeNFO();
            movie.saveToDb();
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

