/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.trakttv.MovieSyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperComboBox;
import org.tinymediamanager.ui.components.combobox.ScraperMetadataConfigCheckComboBox;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.MovieChooserModel;
import org.tinymediamanager.ui.renderer.BorderTableCellRenderer;

public class MovieChooserDialog
extends TmmDialog
implements ActionListener {
    private static final long serialVersionUID = -3104541519073924724L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieChooserDialog.class);
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();
    private final Movie movieToScrape;
    private final List<MediaScraper> artworkScrapers;
    private final List<MediaScraper> trailerScrapers;
    private MediaScraper mediaScraper;
    private SortedList<MovieChooserModel> searchResultEventList = null;
    private EventList<Person> castMemberEventList = null;
    private MovieChooserModel selectedResult = null;
    private SearchTask activeSearchTask;
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private final MediaScraperComboBox cbScraper;
    private final TmmTable tableSearchResults;
    private final JLabel lblTitle;
    private final JTextArea taMovieDescription;
    private final ImageLabel lblMoviePoster;
    private final JLabel lblProgressAction;
    private final JLabel lblError;
    private final JProgressBar progressBar;
    private final JLabel lblTagline;
    private final JButton okButton;
    private final JLabel lblPath;
    private final JComboBox cbLanguage;
    private final JLabel lblOriginalTitle;
    private final TmmTable tableCastMembers;
    private final ScraperMetadataConfigCheckComboBox<MovieScraperMetadataConfig> cbScraperConfig;
    private final JHintCheckBox chckbxDoNotOverwrite;
    private JTextField textFieldSearchString;

    public MovieChooserDialog(Movie movie, int queueIndex, int queueSize) {
        super(TmmResourceBundle.getString("moviechooser.search") + (String)(queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : ""), "movieChooser");
        this.movieToScrape = movie;
        this.mediaScraper = this.movieList.getDefaultMediaScraper();
        this.artworkScrapers = this.movieList.getDefaultArtworkScrapers();
        this.trailerScrapers = this.movieList.getDefaultTrailerScrapers();
        this.searchResultEventList = new SortedList((EventList)new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MovieChooserModel.class)), (Comparator)new SearchResultScoreComparator());
        this.castMemberEventList = GlazedListsSwing.swingThreadProxyList((EventList)GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(Person.class))));
        JPanel panelPath = new JPanel();
        panelPath.setLayout((LayoutManager)new MigLayout("", "[200lp:300lp,grow][]", "[]"));
        this.lblPath = new JLabel("");
        TmmFontHelper.changeFont(this.lblPath, 1.16667, 1);
        panelPath.add((Component)this.lblPath, "cell 0 0, growx, wmin 0");
        SquareIconButton btnPlay = new SquareIconButton(IconManager.PLAY_INV);
        btnPlay.setFocusable(false);
        btnPlay.addActionListener(e -> {
            MediaFile mf = this.movieToScrape.getMediaFiles(MediaFileType.VIDEO).get(0);
            try {
                TmmUIHelper.openFile(MediaFileHelper.getMainVideoFile(mf));
            }
            catch (Exception ex) {
                LOGGER.error("open file", (Throwable)ex);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        panelPath.add((Component)btnPlay, "cell 1 0");
        this.setTopIformationPanel(panelPath);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[600lp:900lp,grow]", "[][shrink 0][250lp:350lp,grow][shrink 0][][][]"));
        this.getContentPane().add((Component)contentPanel, "Center");
        JPanel panelSearchField = new JPanel();
        contentPanel.add((Component)panelSearchField, "cell 0 0,grow");
        panelSearchField.setLayout((LayoutManager)new MigLayout("insets 0", "[][][grow][]", "[]2lp[]"));
        TmmLabel lblScraper = new TmmLabel(TmmResourceBundle.getString("scraper"));
        panelSearchField.add((Component)lblScraper, "cell 0 0,alignx right");
        this.cbScraper = new MediaScraperComboBox(this.movieList.getAvailableMediaScrapers());
        MediaScraper defaultScraper = this.movieList.getDefaultMediaScraper();
        if (defaultScraper != null && defaultScraper.isEnabled()) {
            this.cbScraper.setSelectedItem(defaultScraper);
        }
        this.cbScraper.setAction(new ChangeScraperAction());
        panelSearchField.add((Component)this.cbScraper, "cell 1 0,growx");
        ActionListener searchAction = arg0 -> this.searchMovie(this.textFieldSearchString.getText(), false);
        this.textFieldSearchString = new EnhancedTextField(TmmResourceBundle.getString("moviechooser.search.hint"));
        this.textFieldSearchString.setToolTipText(TmmResourceBundle.getString("moviechooser.search.hint"));
        this.textFieldSearchString.addActionListener(searchAction);
        panelSearchField.add((Component)this.textFieldSearchString, "cell 2 0,growx");
        this.textFieldSearchString.setColumns(10);
        JButton btnSearch = new JButton(TmmResourceBundle.getString("Button.search"));
        panelSearchField.add((Component)btnSearch, "cell 3 0");
        btnSearch.setIcon(IconManager.SEARCH_INV);
        btnSearch.addActionListener(searchAction);
        TmmLabel lblLanguage = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        panelSearchField.add((Component)lblLanguage, "cell 0 1,alignx right");
        this.cbLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        this.cbLanguage.setSelectedItem((Object)MovieModuleManager.getInstance().getSettings().getScraperLanguage());
        this.cbLanguage.addActionListener(e -> this.searchMovie(this.textFieldSearchString.getText(), false));
        panelSearchField.add((Component)this.cbLanguage, "cell 1 1");
        contentPanel.add((Component)new JSeparator(), "cell 0 1,growx");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setName(this.getName() + ".splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        contentPanel.add((Component)splitPane, "cell 0 2,grow");
        JPanel panelSearchResults = new JPanel();
        splitPane.setLeftComponent(panelSearchResults);
        panelSearchResults.setLayout((LayoutManager)new MigLayout("insets 0", "[200lp:300lp,grow]", "[150lp:300lp,grow]"));
        JScrollPane scrollPane = new JScrollPane();
        panelSearchResults.add((Component)scrollPane, "cell 0 0,grow");
        this.tableSearchResults = new TmmTable((TableModel)((Object)new TmmTableModel<MovieChooserModel>((EventList<MovieChooserModel>)this.searchResultEventList, new SearchResultTableFormat())));
        this.tableSearchResults.configureScrollPane(scrollPane);
        JPanel panelSearchDetail = new JPanel();
        splitPane.setRightComponent(panelSearchDetail);
        panelSearchDetail.setLayout((LayoutManager)new MigLayout("", "[100lp:15%:20%,grow][300lp:500lp,grow 3]", "[]2lp[]2lp[][150lp:25%:50%][50lp:100lp,grow]"));
        this.lblTitle = new JLabel("");
        TmmFontHelper.changeFont(this.lblTitle, 1.167, 1);
        panelSearchDetail.add((Component)this.lblTitle, "cell 1 0, wmin 0");
        this.lblOriginalTitle = new JLabel("");
        panelSearchDetail.add((Component)this.lblOriginalTitle, "cell 1 1,wmin 0");
        this.lblTagline = new JLabel("");
        panelSearchDetail.add((Component)this.lblTagline, "cell 1 2, wmin 0");
        this.lblMoviePoster = new ImageLabel(false);
        this.lblMoviePoster.setDesiredAspectRatio(0.6666667f);
        panelSearchDetail.add((Component)this.lblMoviePoster, "cell 0 0 1 4,grow");
        scrollPane = new NoBorderScrollPane();
        panelSearchDetail.add((Component)scrollPane, "cell 1 3,grow");
        this.taMovieDescription = new ReadOnlyTextArea();
        scrollPane.setViewportView(this.taMovieDescription);
        scrollPane = new JScrollPane();
        panelSearchDetail.add((Component)scrollPane, "cell 0 4 2 1,grow");
        this.tableCastMembers = new TmmTable((TableModel)((Object)new TmmTableModel<Person>(this.castMemberEventList, new CastMemberTableFormat())));
        this.tableCastMembers.configureScrollPane(scrollPane);
        JSeparator separator = new JSeparator();
        contentPanel.add((Component)separator, "cell 0 3,growx");
        TmmLabel lblScrapeFollowingItems = new TmmLabel(TmmResourceBundle.getString("chooser.scrape"));
        contentPanel.add((Component)lblScrapeFollowingItems, "cell 0 4,growx");
        this.cbScraperConfig = new ScraperMetadataConfigCheckComboBox<MovieScraperMetadataConfig>(MovieScraperMetadataConfig.getValuesWithout(MovieScraperMetadataConfig.ID));
        this.cbScraperConfig.enableFilter((movieScraperMetadataConfig, s) -> movieScraperMetadataConfig.getDescription().toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT)));
        contentPanel.add(this.cbScraperConfig, "cell 0 5,grow, wmin 0");
        this.chckbxDoNotOverwrite = new JHintCheckBox(TmmResourceBundle.getString("message.scrape.donotoverwrite"));
        this.chckbxDoNotOverwrite.setToolTipText(TmmResourceBundle.getString("message.scrape.donotoverwrite.desc"));
        this.chckbxDoNotOverwrite.setHintIcon(IconManager.HINT);
        contentPanel.add((Component)this.chckbxDoNotOverwrite, "cell 0 6");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.lblError = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblError, 1);
        this.lblError.setForeground(Color.RED);
        infoPanel.add((Component)this.lblError, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        if (queueSize > 1) {
            JButton abortButton = new JButton(TmmResourceBundle.getString("Button.abortqueue"));
            abortButton.setIcon(IconManager.STOP_INV);
            abortButton.setActionCommand("Abort");
            abortButton.addActionListener(this);
            this.addButton(abortButton);
            if (queueIndex > 0) {
                JButton backButton = new JButton(TmmResourceBundle.getString("Button.back"));
                backButton.setIcon(IconManager.BACK_INV);
                backButton.setActionCommand("Back");
                backButton.addActionListener(this);
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(TmmResourceBundle.getString("Button.cancel"));
        cancelButton.setIcon(IconManager.CANCEL_INV);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.addButton(cancelButton);
        this.okButton = new JButton(TmmResourceBundle.getString("Button.ok"));
        this.okButton.setIcon(IconManager.APPLY_INV);
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.addButton(this.okButton);
        TableComparatorChooser.install((JTable)this.tableSearchResults, this.searchResultEventList, (Object)TableComparatorChooser.SINGLE_COLUMN);
        this.tableSearchResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && !e.isConsumed() && e.getButton() == 1 && MovieChooserDialog.this.okButton.isEnabled()) {
                    MovieChooserDialog.this.actionPerformed(new ActionEvent(MovieChooserDialog.this.okButton, 1001, "OK"));
                }
            }
        });
        PropertyChangeListener listener = evt -> {
            String property = evt.getPropertyName();
            if ("scraped".equals(property)) {
                this.castMemberEventList.clear();
                int row = this.tableSearchResults.convertRowIndexToModel(this.tableSearchResults.getSelectedRow());
                if (row > -1) {
                    MovieChooserModel model = (MovieChooserModel)this.searchResultEventList.get(row);
                    this.castMemberEventList.addAll(model.getCastMembers());
                    this.lblOriginalTitle.setText(model.getOriginalTitle());
                    this.lblTagline.setText(model.getTagline());
                    if (!model.getPosterUrl().equals(this.lblMoviePoster.getImageUrl())) {
                        this.lblMoviePoster.setImageUrl(model.getPosterUrl());
                    }
                    this.taMovieDescription.setText(model.getOverview());
                }
            }
        };
        this.tableSearchResults.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int index = this.tableSearchResults.convertRowIndexToModel(this.tableSearchResults.getSelectedRow());
            this.castMemberEventList.clear();
            if (this.selectedResult != null) {
                this.selectedResult.removePropertyChangeListener(listener);
            }
            if (index > -1 && index < this.searchResultEventList.size()) {
                MovieChooserModel model = (MovieChooserModel)this.searchResultEventList.get(index);
                this.castMemberEventList.addAll(model.getCastMembers());
                this.lblMoviePoster.setImageUrl(model.getPosterUrl());
                this.lblTitle.setText(model.getCombinedName());
                this.lblOriginalTitle.setText(model.getOriginalTitle());
                this.lblTagline.setText(model.getTagline());
                this.taMovieDescription.setText(model.getOverview());
                this.selectedResult = model;
                this.selectedResult.addPropertyChangeListener(listener);
            } else {
                this.selectedResult = null;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                selectedRow = this.tableSearchResults.convertRowIndexToModel(selectedRow);
                try {
                    MovieChooserModel model = (MovieChooserModel)this.searchResultEventList.get(selectedRow);
                    if (model != MovieChooserModel.emptyResult && !model.isScraped()) {
                        ScrapeTask task = new ScrapeTask(model);
                        task.execute();
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn(ex.getMessage());
                }
            }
        });
        this.progressBar.setVisible(false);
        this.cbScraperConfig.setSelectedItems(MovieModuleManager.getInstance().getSettings().getScraperMetadataConfig());
        this.chckbxDoNotOverwrite.setSelected(MovieModuleManager.getInstance().getSettings().isDoNotOverwriteExistingData());
        this.textFieldSearchString.setText(this.movieToScrape.getTitle());
        this.lblPath.setText(this.movieToScrape.getPathNIO().resolve(this.movieToScrape.getMainFile().getFilename()).toString());
        this.searchMovie(this.textFieldSearchString.getText(), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MovieChooserModel model;
        int row;
        if ("OK".equals(e.getActionCommand()) && (row = this.tableSearchResults.getSelectedRow()) >= 0 && (model = (MovieChooserModel)this.searchResultEventList.get(row)) != MovieChooserModel.emptyResult) {
            if (!model.isScraped()) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "MovieChooser", "message.scrape.threadcrashed"));
                return;
            }
            MediaMetadata md = model.getMetadata();
            if (StringUtils.isBlank((CharSequence)md.getTitle())) {
                md.setTitle(model.getTitle());
            }
            if (!MovieModuleManager.getInstance().getSettings().isScrapeBestImage()) {
                md.clearMediaArt();
            }
            List<MovieScraperMetadataConfig> scraperConfig = this.cbScraperConfig.getSelectedItems();
            boolean overwrite = !this.chckbxDoNotOverwrite.isSelected();
            this.movieToScrape.setMetadata(md, scraperConfig, overwrite);
            this.movieToScrape.setLastScrapeLanguage(model.getMetadataProvider().getId());
            this.movieToScrape.setLastScrapeLanguage(model.getLanguage().name());
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (ScraperMetadataConfig.containsAnyArtwork(scraperConfig)) {
                if (!MovieModuleManager.getInstance().getSettings().isScrapeBestImage()) {
                    if (scraperConfig.contains(MovieScraperMetadataConfig.POSTER) && (overwrite || StringUtils.isBlank((CharSequence)this.movieToScrape.getArtworkFilename(MediaFileType.POSTER)))) {
                        this.chooseArtwork(MediaFileType.POSTER);
                    }
                    if ((scraperConfig.contains(MovieScraperMetadataConfig.FANART) || scraperConfig.contains(MovieScraperMetadataConfig.EXTRAFANART)) && (overwrite || StringUtils.isBlank((CharSequence)this.movieToScrape.getArtworkFilename(MediaFileType.FANART)))) {
                        this.chooseArtwork(MediaFileType.FANART);
                    }
                    if (scraperConfig.contains(MovieScraperMetadataConfig.BANNER) && (overwrite || StringUtils.isBlank((CharSequence)this.movieToScrape.getArtworkFilename(MediaFileType.BANNER)))) {
                        this.chooseArtwork(MediaFileType.BANNER);
                    }
                    if (scraperConfig.contains(MovieScraperMetadataConfig.LOGO) && (overwrite || StringUtils.isBlank((CharSequence)this.movieToScrape.getArtworkFilename(MediaFileType.LOGO)))) {
                        this.chooseArtwork(MediaFileType.LOGO);
                    }
                    if (scraperConfig.contains(MovieScraperMetadataConfig.CLEARLOGO) && (overwrite || StringUtils.isBlank((CharSequence)this.movieToScrape.getArtworkFilename(MediaFileType.CLEARLOGO)))) {
                        this.chooseArtwork(MediaFileType.CLEARLOGO);
                    }
                    if (scraperConfig.contains(MovieScraperMetadataConfig.CLEARART) && (overwrite || StringUtils.isBlank((CharSequence)this.movieToScrape.getArtworkFilename(MediaFileType.CLEARART)))) {
                        this.chooseArtwork(MediaFileType.CLEARART);
                    }
                    if (scraperConfig.contains(MovieScraperMetadataConfig.DISCART) && (overwrite || StringUtils.isBlank((CharSequence)this.movieToScrape.getArtworkFilename(MediaFileType.DISC)))) {
                        this.chooseArtwork(MediaFileType.DISC);
                    }
                    if ((scraperConfig.contains(MovieScraperMetadataConfig.THUMB) || scraperConfig.contains(MovieScraperMetadataConfig.EXTRATHUMB)) && (overwrite || StringUtils.isBlank((CharSequence)this.movieToScrape.getArtworkFilename(MediaFileType.THUMB)))) {
                        this.chooseArtwork(MediaFileType.THUMB);
                    }
                    if (scraperConfig.contains(MovieScraperMetadataConfig.KEYART) && (overwrite || StringUtils.isBlank((CharSequence)this.movieToScrape.getArtworkFilename(MediaFileType.KEYART)))) {
                        this.chooseArtwork(MediaFileType.KEYART);
                    }
                } else {
                    model.startArtworkScrapeTask(this.movieToScrape, scraperConfig, overwrite);
                }
            }
            if (scraperConfig.contains(MovieScraperMetadataConfig.TRAILER)) {
                model.startTrailerScrapeTask(this.movieToScrape, overwrite);
            }
            if (MovieModuleManager.getInstance().getSettings().getSyncTrakt()) {
                MovieSyncTraktTvTask task = new MovieSyncTraktTvTask(Collections.singletonList(this.movieToScrape));
                task.setSyncCollection(MovieModuleManager.getInstance().getSettings().getSyncTraktCollection());
                task.setSyncWatched(MovieModuleManager.getInstance().getSettings().getSyncTraktWatched());
                task.setSyncRating(MovieModuleManager.getInstance().getSettings().getSyncTraktRating());
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setVisible(false);
        }
        if ("Cancel".equals(e.getActionCommand())) {
            this.setVisible(false);
        }
        if ("Abort".equals(e.getActionCommand())) {
            this.continueQueue = false;
            this.setVisible(false);
        }
        if ("Back".equals(e.getActionCommand())) {
            this.navigateBack = true;
            this.setVisible(false);
        }
    }

    private void chooseArtwork(MediaFileType mediaFileType) {
        MediaArtwork.MediaArtworkType imageType;
        ArrayList<String> extrathumbs = null;
        ArrayList<String> extrafanarts = null;
        switch (mediaFileType) {
            case POSTER: {
                if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.POSTER;
                break;
            }
            case FANART: {
                if (MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.BACKGROUND;
                if (MovieModuleManager.getInstance().getSettings().isImageExtraThumbs()) {
                    extrathumbs = new ArrayList<String>();
                }
                if (!MovieModuleManager.getInstance().getSettings().isImageExtraFanart()) break;
                extrafanarts = new ArrayList<String>();
                break;
            }
            case BANNER: {
                if (MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.BANNER;
                break;
            }
            case LOGO: {
                if (MovieModuleManager.getInstance().getSettings().getLogoFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.LOGO;
                break;
            }
            case CLEARLOGO: {
                if (MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.CLEARLOGO;
                break;
            }
            case CLEARART: {
                if (MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.CLEARART;
                break;
            }
            case DISC: {
                if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.DISC;
                break;
            }
            case THUMB: {
                if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.THUMB;
                break;
            }
            case KEYART: {
                if (MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.KEYART;
                break;
            }
            default: {
                return;
            }
        }
        HashMap<String, Object> newIds = new HashMap<String, Object>(this.movieToScrape.getIds());
        newIds.put("mediaFile", this.movieToScrape.getMainFile());
        String imageUrl = ImageChooserDialog.chooseImage(this, newIds, imageType, this.artworkScrapers, extrathumbs, extrafanarts, MediaType.MOVIE, this.movieToScrape.getPathNIO().toAbsolutePath().toString());
        this.movieToScrape.setArtworkUrl(imageUrl, mediaFileType);
        if (StringUtils.isNotBlank((CharSequence)imageUrl)) {
            this.movieToScrape.downloadArtwork(mediaFileType);
        }
        if (extrathumbs != null) {
            this.movieToScrape.setExtraThumbs(extrathumbs);
            if (!extrathumbs.isEmpty()) {
                this.movieToScrape.downloadArtwork(MediaFileType.EXTRATHUMB);
            }
        }
        if (extrafanarts != null) {
            this.movieToScrape.setExtraFanarts(extrafanarts);
            if (!extrafanarts.isEmpty()) {
                this.movieToScrape.downloadArtwork(MediaFileType.EXTRAFANART);
            }
        }
    }

    private void searchMovie(String searchTerm, boolean withIds) {
        if (this.activeSearchTask != null && !this.activeSearchTask.isDone()) {
            this.activeSearchTask.cancel();
        }
        this.activeSearchTask = new SearchTask(searchTerm, this.movieToScrape, withIds);
        SwingUtilities.invokeLater(this.activeSearchTask::execute);
    }

    private void startProgressBar(String description) {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText(description);
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
            this.lblError.setText("");
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText("");
            this.progressBar.setVisible(false);
            this.progressBar.setIndeterminate(false);
        });
    }

    @Override
    public void dispose() {
        if (this.activeSearchTask != null && !this.activeSearchTask.isDone()) {
            this.activeSearchTask.cancel();
        }
        super.dispose();
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    public static class SearchResultRenderer
    extends BorderTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof MovieChooserModel) {
                MovieChooserModel result = (MovieChooserModel)value;
                String text = result.getTitle();
                if (result.isDuplicate()) {
                    this.setHorizontalTextPosition(10);
                    this.setIconTextGap(10);
                    this.setIcon(IconManager.WARN);
                    this.setToolTipText(TmmResourceBundle.getString("moviechooser.duplicate.desc"));
                } else {
                    this.setIcon(null);
                }
                return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class CastMemberTableFormat
    extends TmmTableFormat<Person> {
        public CastMemberTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.name"), "name", Person::getName, String.class);
            col.setColumnTooltip(Person::getName);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.role"), "role", Person::getRole, String.class);
            col.setColumnTooltip(Person::getRole);
            this.addColumn(col);
        }
    }

    private static class SearchResultTitleComparator
    implements Comparator<MovieChooserModel> {
        private Collator stringCollator;

        private SearchResultTitleComparator() {
            RuleBasedCollator defaultCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();
            try {
                this.stringCollator = new RuleBasedCollator(defaultCollator.getRules().replace("<'_'", "<' '<'_'"));
            }
            catch (Exception e) {
                this.stringCollator = defaultCollator;
            }
        }

        @Override
        public int compare(MovieChooserModel o1, MovieChooserModel o2) {
            if (this.stringCollator != null) {
                String titleMovie1 = StrgUtils.normalizeString(o1.getTitle().toLowerCase(Locale.ROOT));
                String titleMovie2 = StrgUtils.normalizeString(o2.getTitle().toLowerCase(Locale.ROOT));
                return this.stringCollator.compare(titleMovie1, titleMovie2);
            }
            return o1.getTitle().toLowerCase(Locale.ROOT).compareTo(o2.getTitle().toLowerCase(Locale.ROOT));
        }
    }

    private static class SearchResultScoreComparator
    implements Comparator<MovieChooserModel> {
        private SearchResultScoreComparator() {
        }

        @Override
        public int compare(MovieChooserModel o1, MovieChooserModel o2) {
            return Float.compare(o2.getScore(), o1.getScore());
        }
    }

    private static class SearchResultTableFormat
    extends TmmTableFormat<MovieChooserModel> {
        private SearchResultTableFormat() {
            SearchResultTitleComparator searchResultComparator = new SearchResultTitleComparator();
            TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
            FontMetrics fontMetrics = this.getFontMetrics();
            TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("chooser.searchresult"), "title", result -> result, MovieChooserModel.class);
            col.setColumnTooltip(MovieChooserModel::getTitle);
            col.setColumnComparator(searchResultComparator);
            col.setCellRenderer(new SearchResultRenderer());
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.year"), "year", MovieChooserModel::getYear, String.class);
            col.setColumnComparator(stringComparator);
            col.setColumnResizeable(false);
            col.setMinWidth((int)((float)fontMetrics.stringWidth("2000") * 1.2f));
            col.setMaxWidth((int)((float)fontMetrics.stringWidth("2000") * 1.4f));
            this.addColumn(col);
        }
    }

    private class ScrapeTask
    extends SwingWorker<Void, Void> {
        private final MovieChooserModel model;

        private ScrapeTask(MovieChooserModel model) {
            this.model = model;
        }

        @Override
        public Void doInBackground() {
            MovieChooserDialog.this.startProgressBar(TmmResourceBundle.getString("chooser.scrapeing") + " " + this.model.getTitle());
            MovieChooserDialog.this.okButton.setEnabled(false);
            this.model.scrapeMetaData();
            MovieChooserDialog.this.okButton.setEnabled(true);
            return null;
        }

        @Override
        public void done() {
            MovieChooserDialog.this.stopProgressBar();
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private final String searchTerm;
        private final Movie movie;
        private final boolean withIds;
        private final MediaLanguages language;
        private List<MediaSearchResult> searchResult;
        private Throwable error = null;
        boolean cancel = false;

        private SearchTask(String searchTerm, Movie movie, boolean withIds) {
            this.searchTerm = searchTerm;
            this.movie = movie;
            this.withIds = withIds;
            this.language = (MediaLanguages)((Object)MovieChooserDialog.this.cbLanguage.getSelectedItem());
        }

        @Override
        public Void doInBackground() {
            MovieChooserDialog.this.startProgressBar(TmmResourceBundle.getString("chooser.searchingfor") + " " + this.searchTerm);
            try {
                this.searchResult = MovieChooserDialog.this.movieList.searchMovie(this.searchTerm, this.movie.getYear(), this.withIds ? this.movie.getIds() : null, MovieChooserDialog.this.mediaScraper, this.language);
            }
            catch (Exception e) {
                this.error = e;
            }
            return null;
        }

        public void cancel() {
            this.cancel = true;
            super.cancel(true);
        }

        @Override
        public void done() {
            MovieChooserDialog.this.stopProgressBar();
            MovieChooserDialog.this.searchResultEventList.clear();
            if (this.error != null) {
                MovieChooserDialog.this.searchResultEventList.add((Object)MovieChooserModel.emptyResult);
                SwingUtilities.invokeLater(() -> MovieChooserDialog.this.lblError.setText(this.error.getMessage()));
            } else if (!this.cancel) {
                if (this.searchResult == null || this.searchResult.isEmpty()) {
                    MovieChooserDialog.this.searchResultEventList.add((Object)MovieChooserModel.emptyResult);
                } else {
                    MediaScraper mpFromResult = null;
                    for (MediaSearchResult result : this.searchResult) {
                        if (mpFromResult == null) {
                            mpFromResult = MovieChooserDialog.this.movieList.getMediaScraperById(result.getProviderId());
                        }
                        if (mpFromResult == null) {
                            mpFromResult = (MediaScraper)MovieChooserDialog.this.cbScraper.getSelectedItem();
                        }
                        MovieChooserDialog.this.searchResultEventList.add((Object)new MovieChooserModel(MovieChooserDialog.this.movieToScrape, mpFromResult, MovieChooserDialog.this.artworkScrapers, MovieChooserDialog.this.trailerScrapers, result, this.language));
                    }
                }
            }
            if (!MovieChooserDialog.this.searchResultEventList.isEmpty()) {
                MovieChooserDialog.this.tableSearchResults.setRowSelectionInterval(0, 0);
            }
        }
    }

    private class ChangeScraperAction
    extends AbstractAction {
        private static final long serialVersionUID = -4365761222995534769L;

        private ChangeScraperAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieChooserDialog.this.mediaScraper = (MediaScraper)MovieChooserDialog.this.cbScraper.getSelectedItem();
            MovieChooserDialog.this.searchMovie(MovieChooserDialog.this.textFieldSearchString.getText(), false);
        }
    }
}

