/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.List;
import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractTextMovieUIFilter;

public class MovieAllInOneFilter
extends AbstractTextMovieUIFilter {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();

    @Override
    protected JLabel createLabel() {
        TmmLabel label = new TmmLabel(TmmResourceBundle.getString("filter.universal"));
        label.setHintIcon(IconManager.HINT);
        label.setToolTipText(TmmResourceBundle.getString("filter.universal.hint2"));
        return label;
    }

    @Override
    public String getId() {
        return "movieAllInOne";
    }

    @Override
    public boolean accept(Movie movie) {
        if (StringUtils.isBlank((CharSequence)this.normalizedFilterText)) {
            return true;
        }
        List<AbstractSettings.UniversalFilterFields> filterFields = this.settings.getUniversalFilterFields();
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.NOTE) && this.filterField(movie.getNote())) {
            return true;
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.FILENAME)) {
            for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.VIDEO)) {
                if (!this.filterField(mediaFile.getFilename())) continue;
                return true;
            }
            if (this.filterField(movie.getOriginalFilename())) {
                return true;
            }
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.PRODUCTION_COMPANY) && this.filterField(movie.getProductionCompany())) {
            return true;
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.COUNTRY) && this.filterField(movie.getCountry())) {
            return true;
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.PLOT) && this.filterField(movie.getPlot())) {
            return true;
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.TAGLINE) && this.filterField(movie.getTagline())) {
            return true;
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.SPOKEN_LANGUAGE)) {
            if (this.filterField(movie.getSpokenLanguages())) {
                return true;
            }
            if (this.filterField(movie.getLocalizedSpokenLanguages())) {
                return true;
            }
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.ACTOR)) {
            for (Person cast : movie.getActors()) {
                if (!this.filterField(cast.getName())) continue;
                return true;
            }
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.PRODUCER)) {
            for (Person producer : movie.getProducers()) {
                if (!this.filterField(producer.getName())) continue;
                return true;
            }
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.DIRECTOR)) {
            for (Person director : movie.getDirectors()) {
                if (!this.filterField(director.getName())) continue;
                return true;
            }
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.WRITER)) {
            for (Person writer : movie.getWriters()) {
                if (!this.filterField(writer.getName())) continue;
                return true;
            }
        }
        if (filterFields.contains((Object)AbstractSettings.UniversalFilterFields.TAGS)) {
            for (String tag : movie.getTags()) {
                if (!this.filterField(tag)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean filterField(String textToFilter) {
        try {
            Matcher matcher;
            if (StringUtils.isNotBlank((CharSequence)textToFilter) && (matcher = this.filterPattern.matcher(StrgUtils.normalizeString(textToFilter))).find()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

