/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractTextMovieUIFilter;

public class MovieCastFilter
extends AbstractTextMovieUIFilter {
    @Override
    public String getId() {
        return "movieCast";
    }

    @Override
    public boolean accept(Movie movie) {
        if (StringUtils.isBlank((CharSequence)this.normalizedFilterText)) {
            return true;
        }
        try {
            Matcher matcher;
            for (Person director : movie.getDirectors()) {
                if (!StringUtils.isNotEmpty((CharSequence)director.getName()) || !(matcher = this.filterPattern.matcher(StrgUtils.normalizeString(director.getName()))).find()) continue;
                return true;
            }
            for (Person writer : movie.getWriters()) {
                if (!StringUtils.isNotEmpty((CharSequence)writer.getName()) || !(matcher = this.filterPattern.matcher(StrgUtils.normalizeString(writer.getName()))).find()) continue;
                return true;
            }
            for (Person cast : movie.getActors()) {
                if (!StringUtils.isNotEmpty((CharSequence)cast.getName()) || !(matcher = this.filterPattern.matcher(StrgUtils.normalizeString(cast.getName()))).find()) continue;
                return true;
            }
            for (Person producer : movie.getProducers()) {
                if (!StringUtils.isNotEmpty((CharSequence)producer.getName())) continue;
                matcher = this.filterPattern.matcher(StrgUtils.normalizeString(producer.getName()));
                return matcher.find();
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.cast"));
    }
}

