/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.movies.filters.AbstractMovieUIFilter;

public class MovieDateAddedFilter
extends AbstractMovieUIFilter {
    private DatePicker datePicker;

    @Override
    protected JComponent createFilterComponent() {
        this.datePicker = new DatePicker();
        this.datePicker.addPropertyChangeListener("date", e -> this.filterChanged());
        return this.datePicker;
    }

    @Override
    public String getFilterValueAsString() {
        Date date = this.datePicker.getDate();
        if (date != null) {
            return String.valueOf(date.getTime());
        }
        return null;
    }

    @Override
    public void setFilterValue(Object value) {
        if (value != null && StringUtils.isNotBlank((CharSequence)value.toString())) {
            try {
                Date date = new Date(Long.parseLong(value.toString()));
                this.datePicker.setDate(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void clearFilter() {
        this.datePicker.setDate(null);
    }

    @Override
    public String getId() {
        return "movieDateAdded";
    }

    @Override
    public boolean accept(Movie movie) {
        if (this.datePicker.getDate() == null) {
            return true;
        }
        Date date = this.datePicker.getDate();
        return DateUtils.isSameDay((Date)date, (Date)movie.getDateAddedForUi());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.dateadded"));
    }
}

