/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieHDRFormatFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieHDRFormatFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.buildHdrFormatArray();
        this.movieList.addPropertyChangeListener("hdrFormat", evt -> SwingUtilities.invokeLater(this::buildHdrFormatArray));
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.hdrformat"));
    }

    @Override
    public String getId() {
        return "movieHdrFormat";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains(movie.getVideoHDRFormat());
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    public void buildHdrFormatArray() {
        ArrayList<String> hdrFormats = new ArrayList<String>(this.movieList.getHDRFormatInMovies());
        Collections.sort(hdrFormats);
        this.setValues(hdrFormats);
    }
}

