/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieMissingArtworkFilter
extends AbstractCheckComboBoxMovieUIFilter<MetadataField> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieMissingArtworkFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        ArrayList<MetadataField> values = new ArrayList<MetadataField>();
        for (MovieScraperMetadataConfig config : MovieScraperMetadataConfig.values()) {
            if (!config.isArtwork()) continue;
            values.add(new MetadataField(config));
        }
        this.setValues(values);
    }

    @Override
    public String getId() {
        return "movieMissingArtwork";
    }

    @Override
    protected String parseTypeToString(MetadataField type) throws Exception {
        return type.config.name();
    }

    @Override
    protected MetadataField parseStringToType(String string) throws Exception {
        try {
            return new MetadataField(MovieScraperMetadataConfig.valueOf(string));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean accept(Movie movie) {
        ArrayList<MovieScraperMetadataConfig> values = new ArrayList<MovieScraperMetadataConfig>();
        for (MetadataField metadataField : this.checkComboBox.getSelectedItems()) {
            values.add(metadataField.config);
        }
        return !this.movieList.detectMissingFields(movie, values).isEmpty();
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.missingartwork"));
    }

    public static class MetadataField {
        private final MovieScraperMetadataConfig config;

        public MetadataField(MovieScraperMetadataConfig config) {
            this.config = config;
        }

        public String toString() {
            return this.config.getDescription();
        }
    }
}

