/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.panels;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.ActorImageLabel;
import org.tinymediamanager.ui.components.PersonTable;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.movies.MovieSelectionModel;

public class MovieCastPanel
extends JPanel {
    private static final long serialVersionUID = 2972207353452870494L;
    private final MovieSelectionModel selectionModel;
    private EventList<Person> actorEventList = null;
    private EventList<Person> producerEventList = null;
    private JLabel lblDirector;
    private JLabel lblWriter;
    private ActorImageLabel lblActorThumb;
    private TmmTable tableProducer;
    private TmmTable tableActors;

    public MovieCastPanel(MovieSelectionModel model) {
        this.selectionModel = model;
        this.producerEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(Person.class)));
        this.actorEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(Person.class)));
        this.initComponents();
        this.initDataBindings();
        this.lblActorThumb.enableLightbox();
        this.lblActorThumb.setCacheUrl(true);
        this.tableActors.getSelectionModel().addListSelectionListener(arg0 -> {
            if (!arg0.getValueIsAdjusting()) {
                int selectedRow = this.tableActors.convertRowIndexToModel(this.tableActors.getSelectedRow());
                if (selectedRow >= 0 && selectedRow < this.actorEventList.size()) {
                    Person actor = (Person)this.actorEventList.get(selectedRow);
                    this.lblActorThumb.setActor(this.selectionModel.getSelectedMovie(), actor);
                } else {
                    this.lblActorThumb.clearImage();
                }
            }
        });
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != MovieSelectionModel.class) {
                return;
            }
            if ("selectedMovie".equals(property) || "actors".equals(property)) {
                this.actorEventList.clear();
                this.actorEventList.addAll(this.selectionModel.getSelectedMovie().getActors());
                if (!this.actorEventList.isEmpty()) {
                    this.tableActors.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
            if ("selectedMovie".equals(property) || "producers".equals(property)) {
                this.producerEventList.clear();
                this.producerEventList.addAll(this.selectionModel.getSelectedMovie().getProducers());
                if (!this.producerEventList.isEmpty()) {
                    this.tableProducer.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public String getName() {
        return "movie.moviecast";
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[][400lp,grow][150lp,grow]", "[][][100lp:150lp,grow][150lp:200lp,grow]"));
        TmmLabel lblDirectorT = new TmmLabel(TmmResourceBundle.getString("metatag.director"));
        this.add((Component)lblDirectorT, "cell 0 0");
        this.lblDirector = new JLabel("");
        lblDirectorT.setLabelFor(this.lblDirector);
        this.add((Component)this.lblDirector, "cell 1 0 2 1,growx,wmin 0");
        TmmLabel lblWriterT = new TmmLabel(TmmResourceBundle.getString("metatag.writer"));
        this.add((Component)lblWriterT, "cell 0 1");
        this.lblWriter = new JLabel("");
        lblWriterT.setLabelFor(this.lblWriter);
        this.add((Component)this.lblWriter, "cell 1 1 2 1,growx,wmin 0");
        TmmLabel lblProducersT = new TmmLabel(TmmResourceBundle.getString("metatag.producers"));
        this.add((Component)lblProducersT, "cell 0 2,aligny top");
        this.tableProducer = new PersonTable(this.producerEventList);
        this.tableProducer.setName(this.getName() + ".producerTable");
        TmmUILayoutStore.getInstance().install(this.tableProducer);
        JScrollPane scrollPanePerson = new JScrollPane();
        this.tableProducer.configureScrollPane(scrollPanePerson);
        this.add((Component)scrollPanePerson, "cell 1 2,grow");
        TmmLabel lblActorsT = new TmmLabel(TmmResourceBundle.getString("metatag.actors"));
        this.add((Component)lblActorsT, "cell 0 3,aligny top");
        this.tableActors = new PersonTable(this.actorEventList);
        this.tableActors.setName(this.getName() + ".actorTable");
        TmmUILayoutStore.getInstance().install(this.tableActors);
        JScrollPane scrollPanePersons = new JScrollPane();
        this.tableActors.configureScrollPane(scrollPanePersons);
        this.add((Component)scrollPanePersons, "cell 1 3,grow");
        this.lblActorThumb = new ActorImageLabel();
        this.add((Component)this.lblActorThumb, "cell 2 3,grow");
    }

    protected void initDataBindings() {
        BeanProperty movieSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovie.directorsAsString");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)movieSelectionModelBeanProperty, (Object)this.lblDirector, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty movieSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedMovie.writersAsString");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)movieSelectionModelBeanProperty_1, (Object)this.lblWriter, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
    }
}

