/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.panels;

import java.beans.PropertyChangeListener;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.panels.TrailerPanel;

public class MovieTrailerPanel
extends TrailerPanel {
    private final MovieSelectionModel movieSelectionModel;

    public MovieTrailerPanel(MovieSelectionModel model) {
        this.movieSelectionModel = model;
        this.createLayout();
        this.table.setName(this.getName() + ".table");
        TmmUILayoutStore.getInstance().install(this.table);
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != MovieSelectionModel.class) {
                return;
            }
            if ("selectedMovie".equals(property) || "trailer".equals(property)) {
                try {
                    this.trailerEventList.getReadWriteLock().writeLock().lock();
                    this.trailerEventList.clear();
                    this.trailerEventList.addAll(this.movieSelectionModel.getSelectedMovie().getTrailer());
                }
                catch (Exception exception) {
                }
                finally {
                    this.trailerEventList.getReadWriteLock().writeLock().unlock();
                    this.table.adjustColumnPreferredWidths(7);
                }
            }
        };
        this.movieSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public String getName() {
        return "movie.movietrailer";
    }

    @Override
    protected void downloadTrailer(MediaTrailer trailer) {
        MovieHelpers.downloadTrailer(this.movieSelectionModel.getSelectedMovie(), trailer);
    }
}

