/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.ScrollingEventDelegator;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieRenamerSettingsPanel
extends JPanel
implements HierarchyListener {
    private static final long serialVersionUID = 5039498266207230875L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieRenamerSettingsPanel.class);
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final List<String> spaceReplacement = new ArrayList<String>(Arrays.asList("_", ".", "-"));
    private final List<String> colonReplacement = new ArrayList<String>(Arrays.asList(" ", "-", "_"));
    private final EventList<MovieRenamerExample> exampleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(MovieRenamerExample.class)));
    private EnhancedTextField tfMoviePath;
    private EnhancedTextField tfMovieFilename;
    private JLabel lblExample;
    private JCheckBox chckbxAsciiReplacement;
    private JCheckBox chckbxFoldernameSpaceReplacement;
    private JComboBox cbFoldernameSpaceReplacement;
    private JCheckBox chckbxFilenameSpaceReplacement;
    private JComboBox cbFilenameSpaceReplacement;
    private JComboBox cbMovieForPreview;
    private JCheckBox chckbxRemoveOtherNfos;
    private JCheckBox chckbxMoviesetSingleMovie;
    private TmmTable tableExamples;
    private ReadOnlyTextArea taWarning;
    private JComboBox cbColonReplacement;
    private JTextField tfFirstCharacter;
    private JCheckBox chckbxAllowMerge;
    private JCheckBox chckbxAutomaticRename;

    public MovieRenamerSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }
        };
        this.tfMoviePath.getDocument().addDocumentListener(documentListener);
        this.tfMovieFilename.getDocument().addDocumentListener(documentListener);
        this.tfFirstCharacter.getDocument().addDocumentListener(documentListener);
        String replacement = this.settings.getRenamerPathnameSpaceReplacement();
        int index = this.spaceReplacement.indexOf(replacement);
        if (index >= 0) {
            this.cbFoldernameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.spaceReplacement.indexOf(replacement = this.settings.getRenamerFilenameSpaceReplacement())) >= 0) {
            this.cbFilenameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.colonReplacement.indexOf(replacement = this.settings.getRenamerColonReplacement())) >= 0) {
            this.cbColonReplacement.setSelectedIndex(index);
        }
        this.cbFoldernameSpaceReplacement.addActionListener(arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        });
        this.cbFilenameSpaceReplacement.addActionListener(arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        });
        this.cbColonReplacement.addActionListener(arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        });
        this.lblExample.putClientProperty("clipPosition", 2);
        this.exampleEventList.add((Object)new MovieRenamerExample("${title}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${originalTitle}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${originalFilename}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${title[0]}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${title;first}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${title[0,2]}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${titleSortable}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${releaseDate}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${year}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${movieSet.title}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${movieSet.titleSortable}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${movieSetIndex}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${rating}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${imdb}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${tmdb}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${certification}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${directors[0].name}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${actors[0].name}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${genres[0]}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${genres[0].name}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${genresAsString}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${tags[0]}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${productionCompany}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${productionCompanyAsArray[0]}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${language}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${videoResolution}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${aspectRatio}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${aspectRatio2}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${videoCodec}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${videoFormat}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${videoBitDepth}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${videoBitRate}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioCodec}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioCodecList}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioCodecsAsString}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioChannels}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioChannelList}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioChannelsAsString}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioLanguage}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioLanguageList}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioLanguagesAsString}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${subtitleLanguageList}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${subtitleLanguagesAsString}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${mediaSource}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${3Dformat}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${hdr}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${hdrformat}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${filesize}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${edition}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${parent}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${note}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${decadeShort}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${decadeLong}"));
        ActionListener actionCreateRenamerExample = e -> this.createRenamerExample();
        this.cbMovieForPreview.addActionListener(actionCreateRenamerExample);
        this.chckbxMoviesetSingleMovie.addActionListener(actionCreateRenamerExample);
        this.chckbxAsciiReplacement.addActionListener(actionCreateRenamerExample);
        this.chckbxFilenameSpaceReplacement.addActionListener(actionCreateRenamerExample);
        this.chckbxFoldernameSpaceReplacement.addActionListener(actionCreateRenamerExample);
        this.tableExamples.setPreferredScrollableViewportSize(this.tableExamples.getPreferredSize());
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 1", "[600lp,grow]", "[][15lp!][][15lp!][]"));
        JPanel panelPatterns = new JPanel((LayoutManager)new MigLayout("insets 0, hidemode 1", "[20lp!][15lp][][300lp,grow]", "[][][][][][]"));
        TmmLabel lblPatternsT = new TmmLabel(TmmResourceBundle.getString("Settings.movie.renamer.title"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelPatterns, lblPatternsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#renamer-pattern"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblMoviePath = new JLabel(TmmResourceBundle.getString("Settings.renamer.folder"));
        panelPatterns.add((Component)lblMoviePath, "cell 1 0 2 1,alignx right");
        this.tfMoviePath = new EnhancedTextField(IconManager.UNDO_GREY);
        this.tfMoviePath.setIconToolTipText(TmmResourceBundle.getString("Settings.renamer.reverttodefault"));
        this.tfMoviePath.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MovieRenamerSettingsPanel.this.tfMoviePath.setText("${title} ${- ,edition,} (${year})");
            }
        });
        panelPatterns.add((Component)this.tfMoviePath, "cell 3 0,growx");
        JLabel lblDefault = new JLabel(TmmResourceBundle.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 1 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, TmmFontHelper.L2);
        ReadOnlyTextArea tpDefaultFolderPattern = new ReadOnlyTextArea("${title} ${- ,edition,} (${year})");
        panelPatterns.add((Component)tpDefaultFolderPattern, "cell 3 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFolderPattern, TmmFontHelper.L2);
        JLabel lblMovieFilename = new JLabel(TmmResourceBundle.getString("Settings.renamer.file"));
        panelPatterns.add((Component)lblMovieFilename, "cell 1 2 2 1,alignx right");
        this.tfMovieFilename = new EnhancedTextField(IconManager.UNDO_GREY);
        this.tfMovieFilename.setIconToolTipText(TmmResourceBundle.getString("Settings.renamer.reverttodefault"));
        this.tfMovieFilename.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MovieRenamerSettingsPanel.this.tfMovieFilename.setText("${title} ${- ,edition,} (${year}) ${videoFormat} ${audioCodec}");
            }
        });
        panelPatterns.add((Component)this.tfMovieFilename, "cell 3 2,growx");
        lblDefault = new JLabel(TmmResourceBundle.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 3 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, TmmFontHelper.L2);
        ReadOnlyTextArea tpDefaultFilePattern = new ReadOnlyTextArea("${title} ${- ,edition,} (${year}) ${videoFormat} ${audioCodec}");
        panelPatterns.add((Component)tpDefaultFilePattern, "cell 3 3,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFilePattern, TmmFontHelper.L2);
        JLabel lblRenamerHintT = new JLabel(TmmResourceBundle.getString("Settings.movie.renamer.example"));
        panelPatterns.add((Component)lblRenamerHintT, "cell 1 4 3 1");
        JButton btnHelp = new JButton(TmmResourceBundle.getString("tmm.help"));
        btnHelp.addActionListener(e -> {
            String url = StringEscapeUtils.unescapeHtml4((String)"https://www.tinymediamanager.org/docs/movies/renamer");
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e1) {
                LOGGER.error("Wiki", (Throwable)e1);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
            }
        });
        panelPatterns.add((Component)btnHelp, "cell 1 4 3 1");
        this.taWarning = new ReadOnlyTextArea();
        this.taWarning.setForeground(Color.red);
        panelPatterns.add((Component)this.taWarning, "cell 3 5,growx,wmin 0");
        JPanel panelAdvancedOptions = new JPanel();
        panelAdvancedOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][][][][]"));
        TmmLabel lblAdvancedOptions = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelAdvancedOptions, lblAdvancedOptions, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#advanced-options-4"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        this.chckbxAutomaticRename = new JCheckBox(TmmResourceBundle.getString("Settings.movie.automaticrename"));
        panelAdvancedOptions.add((Component)this.chckbxAutomaticRename, "cell 1 0 2 1");
        JLabel lblAutomaticRenameHint = new JLabel(IconManager.HINT);
        lblAutomaticRenameHint.setToolTipText(TmmResourceBundle.getString("Settings.movie.automaticrename.desc"));
        panelAdvancedOptions.add((Component)lblAutomaticRenameHint, "cell 1 0 2 1");
        this.chckbxFoldernameSpaceReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.folderspacereplacement"));
        this.chckbxFoldernameSpaceReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.folderspacereplacement.hint"));
        panelAdvancedOptions.add((Component)this.chckbxFoldernameSpaceReplacement, "cell 1 1 2 1");
        this.cbFoldernameSpaceReplacement = new JComboBox<Object>(this.spaceReplacement.toArray());
        panelAdvancedOptions.add((Component)this.cbFoldernameSpaceReplacement, "cell 1 1 2 1");
        this.chckbxFilenameSpaceReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.spacereplacement"));
        this.chckbxFilenameSpaceReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.spacereplacement.hint"));
        panelAdvancedOptions.add((Component)this.chckbxFilenameSpaceReplacement, "cell 1 2 2 1");
        this.cbFilenameSpaceReplacement = new JComboBox<Object>(this.spaceReplacement.toArray());
        panelAdvancedOptions.add((Component)this.cbFilenameSpaceReplacement, "cell 1 2 2 1");
        JLabel lblColonReplacement = new JLabel(TmmResourceBundle.getString("Settings.renamer.colonreplacement"));
        panelAdvancedOptions.add((Component)lblColonReplacement, "cell 1 3 2 1");
        lblColonReplacement.setToolTipText(TmmResourceBundle.getString("Settings.renamer.colonreplacement.hint"));
        this.cbColonReplacement = new JComboBox<Object>(this.colonReplacement.toArray());
        panelAdvancedOptions.add((Component)this.cbColonReplacement, "cell 1 3 2 1");
        this.chckbxAsciiReplacement = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.asciireplacement"));
        panelAdvancedOptions.add((Component)this.chckbxAsciiReplacement, "cell 1 4 2 1");
        JLabel lblAsciiHint = new JLabel(TmmResourceBundle.getString("Settings.renamer.asciireplacement.hint"));
        panelAdvancedOptions.add((Component)lblAsciiHint, "cell 2 5");
        TmmFontHelper.changeFont((JComponent)lblAsciiHint, TmmFontHelper.L2);
        JLabel lblFirstCharacterT = new JLabel(TmmResourceBundle.getString("Settings.renamer.firstnumbercharacterreplacement"));
        panelAdvancedOptions.add((Component)lblFirstCharacterT, "flowx,cell 1 6 2 1");
        this.tfFirstCharacter = new JTextField();
        panelAdvancedOptions.add((Component)this.tfFirstCharacter, "cell 1 6 2 1");
        this.tfFirstCharacter.setColumns(2);
        this.chckbxMoviesetSingleMovie = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.moviesetsinglemovie"));
        panelAdvancedOptions.add((Component)this.chckbxMoviesetSingleMovie, "cell 1 7 2 1");
        this.chckbxRemoveOtherNfos = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.removenfo"));
        panelAdvancedOptions.add((Component)this.chckbxRemoveOtherNfos, "cell 1 8 2 1");
        this.chckbxAllowMerge = new JCheckBox(TmmResourceBundle.getString("Settings.renamer.movie.allowmerge"));
        panelAdvancedOptions.add((Component)this.chckbxAllowMerge, "cell 1 9 2 1");
        JPanel panelExample = new JPanel();
        panelExample.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][300lp,grow]", ""));
        TmmLabel lblExampleHeader = new TmmLabel(TmmResourceBundle.getString("Settings.example"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelExample, lblExampleHeader, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#example"));
        this.add((Component)collapsiblePanel, "cell 0 4, growx, wmin 0");
        JLabel lblExampleT = new JLabel(TmmResourceBundle.getString("tmm.movie"));
        panelExample.add((Component)lblExampleT, "cell 1 0");
        this.cbMovieForPreview = new JComboBox();
        panelExample.add((Component)this.cbMovieForPreview, "cell 1 0, wmin 0");
        this.lblExample = new TmmLabel("", TmmFontHelper.L1);
        panelExample.add((Component)this.lblExample, "cell 1 1, wmin 0");
        this.tableExamples = new TmmTable((TableModel)((Object)new TmmTableModel<MovieRenamerExample>((EventList<MovieRenamerExample>)GlazedListsSwing.swingThreadProxyList(this.exampleEventList), new MovieRenamerExampleTableFormat())));
        NoBorderScrollPane scrollPaneExamples = new NoBorderScrollPane();
        this.tableExamples.configureScrollPane(scrollPaneExamples);
        scrollPaneExamples.setVerticalScrollBarPolicy(21);
        ScrollingEventDelegator.install(scrollPaneExamples);
        panelExample.add((Component)scrollPaneExamples, "cell 1 2,grow");
        this.tableExamples.setRowHeight(35);
    }

    private void buildAndInstallMovieArray() {
        this.cbMovieForPreview.removeAllItems();
        ArrayList<Movie> allMovies = new ArrayList<Movie>(MovieModuleManager.getInstance().getMovieList().getMovies());
        Movie sel = MovieUIModule.getInstance().getSelectionModel().getSelectedMovie();
        allMovies.sort(new MovieComparator());
        for (Movie movie : allMovies) {
            MoviePreviewContainer container = new MoviePreviewContainer();
            container.movie = movie;
            this.cbMovieForPreview.addItem(container);
            if (sel == null || !movie.equals(sel)) continue;
            this.cbMovieForPreview.setSelectedItem(container);
        }
    }

    private void createRenamerExample() {
        Movie movie = null;
        String warning = "";
        if (!this.tfMoviePath.getText().isEmpty() && !MovieRenamer.isFolderPatternUnique(this.tfMoviePath.getText())) {
            warning = TmmResourceBundle.getString("Settings.renamer.folder.warning");
        }
        if (!warning.isEmpty()) {
            this.taWarning.setVisible(true);
            this.taWarning.setText(warning);
        } else {
            this.taWarning.setVisible(false);
        }
        if (this.cbMovieForPreview.getSelectedItem() instanceof MoviePreviewContainer) {
            MoviePreviewContainer container = (MoviePreviewContainer)this.cbMovieForPreview.getSelectedItem();
            movie = container.movie;
        }
        if (movie != null) {
            String path = "";
            Object filename = "";
            if (StringUtils.isNotBlank((CharSequence)this.tfMoviePath.getText())) {
                path = MovieRenamer.createDestinationForFoldername(this.tfMoviePath.getText(), movie);
                path = Paths.get(movie.getDataSource(), path).toString();
            } else {
                path = movie.getPathNIO().toString();
            }
            if (StringUtils.isNotBlank((CharSequence)this.tfMovieFilename.getText())) {
                List<MediaFile> mediaFiles = movie.getMediaFiles(MediaFileType.VIDEO);
                if (!mediaFiles.isEmpty()) {
                    String extension = FilenameUtils.getExtension((String)mediaFiles.get(0).getFilename());
                    filename = MovieRenamer.createDestinationForFilename(this.tfMovieFilename.getText(), movie);
                    if (!((String)filename).endsWith(extension)) {
                        filename = (String)filename + "." + extension;
                    }
                }
            } else {
                filename = movie.getMediaFiles(MediaFileType.VIDEO).get(0).getFilename();
            }
            try {
                String result = Paths.get(path, new String[]{filename}).toString();
                this.lblExample.setText(result);
                this.lblExample.setToolTipText(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (MovieRenamerExample example : this.exampleEventList) {
                example.createExample(movie);
            }
            TableColumnResizer.adjustColumnPreferredWidths(this.tableExamples, 7);
        } else {
            this.lblExample.setText(TmmResourceBundle.getString("Settings.movie.renamer.nomovie"));
            this.lblExample.setToolTipText(null);
        }
    }

    private void checkChanges() {
        String replacement = (String)this.cbFoldernameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerPathnameSpaceReplacement(replacement);
        replacement = (String)this.cbFilenameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerFilenameSpaceReplacement(replacement);
        replacement = (String)this.cbColonReplacement.getSelectedItem();
        this.settings.setRenamerColonReplacement(replacement);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent arg0) {
        if (this.isShowing()) {
            this.buildAndInstallMovieArray();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"renamerPathname");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, (Object)this.tfMoviePath, (Property)jTextFieldBeanProperty_3);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_12 = BeanProperty.create((String)"renamerFilename");
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_12, (Object)this.tfMovieFilename, (Property)jTextFieldBeanProperty_4);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"renamerPathnameSpaceSubstitution");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxFoldernameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"renamerFilenameSpaceSubstitution");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.chckbxFilenameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"renamerNfoCleanup");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxRemoveOtherNfos, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"renamerCreateMoviesetForSingleMovie");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (Object)this.chckbxMoviesetSingleMovie, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty settingsBeanProperty_7 = BeanProperty.create((String)"asciiReplacement");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_7, (Object)this.chckbxAsciiReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"renamerFirstCharacterNumberReplacement");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.tfFirstCharacter, (Property)jTextFieldBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"allowMultipleMoviesInSameDir");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, (Object)this.chckbxAllowMerge, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"renameAfterScrape");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.chckbxAutomaticRename, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
    }

    private static class MovieRenamerExampleTableFormat
    extends TmmTableFormat<MovieRenamerExample> {
        public MovieRenamerExampleTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("Settings.renamer.token.name"), "name", token -> token.completeToken, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("Settings.renamer.token"), "description", token -> token.description, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("Settings.renamer.value"), "value", token -> token.example, String.class);
            this.addColumn(col);
        }
    }

    private static class MovieRenamerExample
    extends AbstractModelObject {
        private static final Pattern TOKEN_PATTERN = Pattern.compile("^\\$\\{(.*?)([\\}\\[;\\.]+.*)");
        private String token;
        private String completeToken;
        private String description;
        private String example = "";

        private MovieRenamerExample(String token) {
            this.token = token;
            this.completeToken = this.createCompleteToken();
            try {
                this.description = TmmResourceBundle.getString("Settings.movie.renamer." + token);
            }
            catch (Exception e) {
                this.description = "";
            }
        }

        private String createCompleteToken() {
            Object result = this.token;
            Matcher matcher = TOKEN_PATTERN.matcher(this.token);
            if (matcher.find() && matcher.groupCount() > 1) {
                String alias = matcher.group(1);
                String sourceToken = MovieRenamer.getTokenMap().get(alias);
                if (StringUtils.isNotBlank((CharSequence)sourceToken)) {
                    result = "<html>" + this.token + "<br>${" + sourceToken + matcher.group(2) + "</html>";
                }
            }
            return result;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String example) {
            this.example = example;
        }

        private void createExample(Movie movie) {
            String oldValue = this.example;
            this.example = movie == null ? "" : MovieRenamer.createDestination(this.token, movie, true);
            this.firePropertyChange("example", oldValue, this.example);
        }
    }

    private static class MovieComparator
    implements Comparator<Movie> {
        private MovieComparator() {
        }

        @Override
        public int compare(Movie arg0, Movie arg1) {
            return arg0.getTitle().compareTo(arg1.getTitle());
        }
    }

    private static class MoviePreviewContainer {
        Movie movie;

        private MoviePreviewContainer() {
        }

        public String toString() {
            return this.movie.getTitle();
        }
    }
}

