/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.MovieSettingsDefaults;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.thirdparty.trakttv.MovieClearTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.TmmLabel;

public class MovieSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -4173835431245178069L;
    private static final int COL_COUNT = 7;
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private JButton btnClearTraktData;
    private JCheckBox chckbxTraktSync;
    private JCheckBox chckbxRenameAfterScrape;
    private JCheckBox chckbxARDAfterScrape;
    private JCheckBox chckbxAutoUpdateOnStart;
    private JCheckBox chckbxBuildImageCache;
    private JCheckBox chckbxExtractArtworkFromVsmeta;
    private JCheckBox chckbxRuntimeFromMi;
    private JButton btnPresetKodi;
    private JButton btnPresetXbmc;
    private JButton btnPresetMediaPortal1;
    private JButton btnPresetMediaPortal2;
    private JButton btnPresetPlex;
    private JCheckBox chckbxIncludeExternalAudioStreams;
    private JCheckBox chckbxUseMediainfoMetadata;
    private JCheckBox chckbxTraktSyncWatched;
    private JCheckBox chckbxTraktSyncRating;
    private JCheckBox chckbxTraktSyncCollection;
    private JButton btnPresetJellyfin;
    private JButton btnPresetEmby;

    public MovieSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnClearTraktData.addActionListener(e -> {
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            int confirm = JOptionPane.showOptionDialog(null, TmmResourceBundle.getString("Settings.trakt.clearmovies.hint"), TmmResourceBundle.getString("Settings.trakt.clearmovies"), 0, 3, null, options, null);
            if (confirm == 0) {
                MovieClearTraktTvTask task = new MovieClearTraktTvTask();
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
        });
        this.btnPresetXbmc.addActionListener(evt -> MovieSettingsDefaults.setDefaultSettingsForXbmc());
        this.btnPresetKodi.addActionListener(evt -> MovieSettingsDefaults.setDefaultSettingsForKodi());
        this.btnPresetJellyfin.addActionListener(evt -> MovieSettingsDefaults.setDefaultSettingsForJellyfin());
        this.btnPresetEmby.addActionListener(evt -> MovieSettingsDefaults.setDefaultSettingsForEmby());
        this.btnPresetPlex.addActionListener(evt -> MovieSettingsDefaults.setDefaultSettingsForPlex());
        this.btnPresetMediaPortal1.addActionListener(evt -> MovieSettingsDefaults.setDefaultSettingsForMediaPortal1());
        this.btnPresetMediaPortal2.addActionListener(evt -> MovieSettingsDefaults.setDefaultSettingsForMediaPortal2());
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][]"));
        JPanel panelAutomaticTasks = new JPanel();
        panelAutomaticTasks.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][15lp!][]"));
        TmmLabel lblAutomaticTasksT = new TmmLabel(TmmResourceBundle.getString("Settings.automatictasks"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelAutomaticTasks, lblAutomaticTasksT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#automatic-tasks"));
        JPanel panelPresets = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][15lp][120lp:n][15lp!][120lp:n][15lp!][120lp:n][grow]", "[][][][]"));
        TmmLabel lblPresets = new TmmLabel(TmmResourceBundle.getString("Settings.preset"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel_1 = new CollapsiblePanel((JComponent)panelPresets, lblPresets, true);
        collapsiblePanel_1.addExtraTitleComponent(new DocsButton("/movies/settings#media-center-presets"));
        this.add((Component)collapsiblePanel_1, "cell 0 0,growx,wmin 0");
        JLabel lblPresetHintT = new JLabel(TmmResourceBundle.getString("Settings.preset.desc"));
        panelPresets.add((Component)lblPresetHintT, "cell 1 0 7 1");
        this.btnPresetKodi = new JButton("Kodi v17+");
        panelPresets.add((Component)this.btnPresetKodi, "cell 2 1,growx");
        this.btnPresetXbmc = new JButton("XBMC/Kodi <v17");
        panelPresets.add((Component)this.btnPresetXbmc, "cell 4 1,growx");
        this.btnPresetJellyfin = new JButton("Jellyfin");
        panelPresets.add((Component)this.btnPresetJellyfin, "cell 2 2,growx");
        this.btnPresetEmby = new JButton("Emby");
        panelPresets.add((Component)this.btnPresetEmby, "cell 4 2,growx");
        this.btnPresetPlex = new JButton("Plex");
        panelPresets.add((Component)this.btnPresetPlex, "cell 6 2,growx");
        this.btnPresetMediaPortal1 = new JButton("MediaPortal 1.x");
        panelPresets.add((Component)this.btnPresetMediaPortal1, "cell 2 3,growx");
        this.btnPresetMediaPortal2 = new JButton("MediaPortal 2.x");
        panelPresets.add((Component)this.btnPresetMediaPortal2, "cell 4 3,growx");
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        this.chckbxRenameAfterScrape = new JCheckBox(TmmResourceBundle.getString("Settings.movie.automaticrename"));
        panelAutomaticTasks.add((Component)this.chckbxRenameAfterScrape, "cell 1 0 2 1");
        JLabel lblAutomaticRenameHint = new JLabel(IconManager.HINT);
        lblAutomaticRenameHint.setToolTipText(TmmResourceBundle.getString("Settings.movie.automaticrename.desc"));
        panelAutomaticTasks.add((Component)lblAutomaticRenameHint, "cell 1 0 2 1");
        this.chckbxARDAfterScrape = new JCheckBox(TmmResourceBundle.getString("Settings.movie.automaticard"));
        panelAutomaticTasks.add((Component)this.chckbxARDAfterScrape, "cell 1 1 2 1");
        JLabel lblAutomaticARDHint = new JLabel(IconManager.HINT);
        lblAutomaticARDHint.setToolTipText(TmmResourceBundle.getString("Settings.movie.automaticard.desc"));
        panelAutomaticTasks.add((Component)lblAutomaticARDHint, "cell 1 1 2 1");
        this.chckbxTraktSync = new JCheckBox(TmmResourceBundle.getString("Settings.trakt"));
        panelAutomaticTasks.add((Component)this.chckbxTraktSync, "cell 1 2 2 1");
        this.btnClearTraktData = new JButton(TmmResourceBundle.getString("Settings.trakt.clearmovies"));
        panelAutomaticTasks.add((Component)this.btnClearTraktData, "cell 1 2 2 1");
        this.chckbxTraktSyncCollection = new JCheckBox(TmmResourceBundle.getString("Settings.trakt.collection"));
        panelAutomaticTasks.add((Component)this.chckbxTraktSyncCollection, "cell 2 3");
        this.chckbxTraktSyncWatched = new JCheckBox(TmmResourceBundle.getString("Settings.trakt.watched"));
        panelAutomaticTasks.add((Component)this.chckbxTraktSyncWatched, "cell 2 4");
        this.chckbxTraktSyncRating = new JCheckBox(TmmResourceBundle.getString("Settings.trakt.rating"));
        panelAutomaticTasks.add((Component)this.chckbxTraktSyncRating, "cell 2 5");
        this.chckbxAutoUpdateOnStart = new JCheckBox(TmmResourceBundle.getString("Settings.movie.automaticupdate"));
        panelAutomaticTasks.add((Component)this.chckbxAutoUpdateOnStart, "cell 1 7 2 1");
        JLabel lblAutomaticUpdateHint = new JLabel(IconManager.HINT);
        lblAutomaticUpdateHint.setToolTipText(TmmResourceBundle.getString("Settings.movie.automaticupdate.desc"));
        panelAutomaticTasks.add((Component)lblAutomaticUpdateHint, "cell 1 7 2 1");
        JPanel panelMisc = new JPanel();
        panelMisc.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][]"));
        TmmLabel lblMiscT = new TmmLabel(TmmResourceBundle.getString("Settings.misc"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#misc-settings"));
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        this.chckbxUseMediainfoMetadata = new JCheckBox(TmmResourceBundle.getString("Settings.usemediainfometadata"));
        panelMisc.add((Component)this.chckbxUseMediainfoMetadata, "cell 1 0 2 1");
        this.chckbxExtractArtworkFromVsmeta = new JCheckBox(TmmResourceBundle.getString("Settings.extractartworkfromvsmeta"));
        panelMisc.add((Component)this.chckbxExtractArtworkFromVsmeta, "cell 1 1 2 1");
        this.chckbxBuildImageCache = new JCheckBox(TmmResourceBundle.getString("Settings.imagecacheimport"));
        panelMisc.add((Component)this.chckbxBuildImageCache, "cell 1 2 2 1");
        JLabel lblBuildImageCacheHint = new JLabel(IconManager.HINT);
        lblBuildImageCacheHint.setToolTipText(TmmResourceBundle.getString("Settings.imagecacheimporthint"));
        panelMisc.add((Component)lblBuildImageCacheHint, "cell 1 2 2 1");
        this.chckbxRuntimeFromMi = new JCheckBox(TmmResourceBundle.getString("Settings.runtimefrommediafile"));
        panelMisc.add((Component)this.chckbxRuntimeFromMi, "cell 1 3 2 1");
        this.chckbxIncludeExternalAudioStreams = new JCheckBox(TmmResourceBundle.getString("Settings.includeexternalstreamsinnfo"));
        panelMisc.add((Component)this.chckbxIncludeExternalAudioStreams, "cell 1 4 2 1");
    }

    private void addMetadataCheckbox(JPanel panel, MovieScraperMetadataConfig config, Map<MovieScraperMetadataConfig, JCheckBox> map, GridBagConstraints gbc) {
        JCheckBox checkBox;
        if (StringUtils.isNotBlank((CharSequence)config.getToolTip())) {
            checkBox = new JHintCheckBox(config.getDescription());
            checkBox.setToolTipText(config.getToolTip());
            ((JHintCheckBox)checkBox).setHintIcon(IconManager.HINT);
        } else {
            checkBox = new JCheckBox(config.getDescription());
        }
        map.put(config, checkBox);
        if (gbc.gridx >= 7) {
            gbc.gridx = 0;
            ++gbc.gridy;
        }
        panel.add((Component)checkBox, gbc);
        ++gbc.gridx;
    }

    protected void initDataBindings() {
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"renameAfterScrape");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, (Object)this.chckbxRenameAfterScrape, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"syncTrakt");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.chckbxTraktSync, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty movieSettingsBeanProperty_3 = BeanProperty.create((String)"buildImageCacheOnImport");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_3, (Object)this.chckbxBuildImageCache, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_4 = BeanProperty.create((String)"runtimeFromMediaInfo");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_4, (Object)this.chckbxRuntimeFromMi, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty movieSettingsBeanProperty_9 = BeanProperty.create((String)"includeExternalAudioStreams");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_9, (Object)this.chckbxIncludeExternalAudioStreams, (Property)jCheckBoxBeanProperty);
        autoBinding_9.bind();
        BeanProperty movieSettingsBeanProperty_11 = BeanProperty.create((String)"extractArtworkFromVsmeta");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_11, (Object)this.chckbxExtractArtworkFromVsmeta, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
        BeanProperty movieSettingsBeanProperty_12 = BeanProperty.create((String)"updateOnStart");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_12, (Object)this.chckbxAutoUpdateOnStart, (Property)jCheckBoxBeanProperty);
        autoBinding_12.bind();
        BeanProperty movieSettingsBeanProperty_6 = BeanProperty.create((String)"useMediainfoMetadata");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_6, (Object)this.chckbxUseMediainfoMetadata, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxTraktSync, (Property)jCheckBoxBeanProperty, (Object)this.chckbxTraktSyncCollection, (Property)jCheckBoxBeanProperty_1);
        autoBinding_6.bind();
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxTraktSync, (Property)jCheckBoxBeanProperty, (Object)this.chckbxTraktSyncWatched, (Property)jCheckBoxBeanProperty_1);
        autoBinding_7.bind();
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxTraktSync, (Property)jCheckBoxBeanProperty, (Object)this.chckbxTraktSyncRating, (Property)jCheckBoxBeanProperty_1);
        autoBinding_10.bind();
        BeanProperty movieSettingsBeanProperty_7 = BeanProperty.create((String)"syncTraktRating");
        AutoBinding autoBinding_18 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_7, (Object)this.chckbxTraktSyncRating, (Property)jCheckBoxBeanProperty);
        autoBinding_18.bind();
        BeanProperty movieSettingsBeanProperty_10 = BeanProperty.create((String)"syncTraktWatched");
        AutoBinding autoBinding_19 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_10, (Object)this.chckbxTraktSyncWatched, (Property)jCheckBoxBeanProperty);
        autoBinding_19.bind();
        BeanProperty movieSettingsBeanProperty_18 = BeanProperty.create((String)"syncTraktCollection");
        AutoBinding autoBinding_20 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_18, (Object)this.chckbxTraktSyncCollection, (Property)jCheckBoxBeanProperty);
        autoBinding_20.bind();
        BeanProperty movieSettingsBeanProperty_22 = BeanProperty.create((String)"ardAfterScrape");
        AutoBinding autoBinding_22 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_22, (Object)this.chckbxARDAfterScrape, (Property)jCheckBoxBeanProperty);
        autoBinding_22.bind();
    }
}

