/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.ScraperInTable;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

class MovieTrailerSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -1607146878528487625L;
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final List<ScraperInTable> scrapers = new ArrayList<ScraperInTable>();
    private final ItemListener checkBoxListener;
    private final ButtonGroup trailerFilenameButtonGroup = new ButtonGroup();
    private TmmTable tableScraperInTable;
    private JTextPane tpScraperDescription;
    private JComboBox<TrailerSources> cbTrailerSource;
    private JComboBox<TrailerQuality> cbTrailerQuality;
    private JCheckBox checkBox;
    private JCheckBox chckbxAutomaticTrailerDownload;
    private JPanel panelScraperOptions;
    private JCheckBox cbTrailerFilename1;
    private JCheckBox cbTrailerFilename2;
    private JCheckBox cbTrailerFilename3;
    private JLabel lblAutomaticTrailerDownloadHint;

    MovieTrailerSettingsPanel() {
        this.checkBoxListener = e -> this.checkChanges();
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName())) {
                this.buildCheckBoxes();
            }
        });
        List<String> enabledTrailerProviders = this.settings.getTrailerScrapers();
        int selectedIndex = -1;
        int counter = 0;
        for (MediaScraper scraper : MovieModuleManager.getInstance().getMovieList().getAvailableTrailerScrapers()) {
            ScraperInTable ScraperInTable2 = new ScraperInTable(scraper);
            if (enabledTrailerProviders.contains(ScraperInTable2.getScraperId())) {
                ScraperInTable2.setActive(true);
                if (selectedIndex < 0) {
                    selectedIndex = counter;
                }
            }
            this.scrapers.add(ScraperInTable2);
            ++counter;
        }
        this.initComponents();
        this.initDataBindings();
        TableColumnResizer.setMaxWidthForColumn(this.tableScraperInTable, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraperInTable, 1, 10);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraperInTable, 5);
        this.tableScraperInTable.getModel().addTableModelListener(arg0 -> {
            if (arg0.getColumn() == 0) {
                int row = arg0.getFirstRow();
                ScraperInTable changedScraper = this.scrapers.get(row);
                if (changedScraper.getActive().booleanValue()) {
                    this.settings.addMovieTrailerScraper(changedScraper.getScraperId());
                } else {
                    this.settings.removeMovieTrailerScraper(changedScraper.getScraperId());
                }
            }
        });
        this.tableScraperInTable.getSelectionModel().addListSelectionListener(e -> {
            int index = this.tableScraperInTable.convertRowIndexToModel(this.tableScraperInTable.getSelectedRow());
            if (index > -1) {
                this.panelScraperOptions.removeAll();
                if (this.scrapers.get(index).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                    this.panelScraperOptions.add(new MediaScraperConfigurationPanel(this.scrapers.get(index).getMediaProvider()));
                }
                this.panelScraperOptions.revalidate();
            }
        });
        Font font = UIManager.getFont("Label.font");
        Color color = UIManager.getColor("Label.foreground");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "); }";
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (counter > 0) {
            this.tableScraperInTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
        this.buildCheckBoxes();
    }

    private void buildCheckBoxes() {
        this.cbTrailerFilename1.removeItemListener(this.checkBoxListener);
        this.cbTrailerFilename2.removeItemListener(this.checkBoxListener);
        this.cbTrailerFilename3.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.cbTrailerFilename1, this.cbTrailerFilename2, this.cbTrailerFilename3);
        List<MovieTrailerNaming> movieTrailerFilenames = this.settings.getTrailerFilenames();
        if (movieTrailerFilenames.contains(MovieTrailerNaming.FILENAME_TRAILER)) {
            this.cbTrailerFilename1.setSelected(true);
        } else if (movieTrailerFilenames.contains(MovieTrailerNaming.MOVIE_TRAILER)) {
            this.cbTrailerFilename2.setSelected(true);
        } else if (movieTrailerFilenames.contains(MovieTrailerNaming.TRAILERS_FILENAME_TRAILER)) {
            this.cbTrailerFilename3.setSelected(true);
        }
        this.cbTrailerFilename1.addItemListener(this.checkBoxListener);
        this.cbTrailerFilename2.addItemListener(this.checkBoxListener);
        this.cbTrailerFilename3.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.setSelected(false);
        }
    }

    private void checkChanges() {
        this.settings.clearTrailerFilenames();
        if (this.cbTrailerFilename1.isSelected()) {
            this.settings.addTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        }
        if (this.cbTrailerFilename2.isSelected()) {
            this.settings.addTrailerFilename(MovieTrailerNaming.MOVIE_TRAILER);
        }
        if (this.cbTrailerFilename3.isSelected()) {
            this.settings.addTrailerFilename(MovieTrailerNaming.TRAILERS_FILENAME_TRAILER);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 0", "[600lp,grow]", "[][15lp!][]"));
        JPanel panelScraper = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][grow]", "[][shrink 0][]"));
        TmmLabel lblScraper = new TmmLabel(TmmResourceBundle.getString("scraper.trailer"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelScraper, lblScraper, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#trailer"));
        this.add((Component)collapsiblePanel, "cell 0 0,wmin 0,grow");
        this.tableScraperInTable = new TmmTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                ScraperInTable scraper = MovieTrailerSettingsPanel.this.scrapers.get(row);
                comp.setEnabled(scraper.isEnabled());
                return comp;
            }
        };
        this.tableScraperInTable.setRowHeight(29);
        this.tableScraperInTable.setShowGrid(true);
        panelScraper.add((Component)this.tableScraperInTable, "cell 1 0,grow");
        JSeparator separator = new JSeparator();
        panelScraper.add((Component)separator, "cell 1 1,growx");
        ScrollablePanel panelScraperDetails = new ScrollablePanel();
        panelScraper.add((Component)panelScraperDetails, "cell 1 2,grow");
        panelScraperDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[][grow]"));
        this.tpScraperDescription = new ReadOnlyTextPane();
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "cell 0 0,grow");
        this.panelScraperOptions = new ScrollablePanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "cell 0 1,grow");
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", ""));
        TmmLabel lblOptionsT = new TmmLabel(TmmResourceBundle.getString("Settings.advancedoptions"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptionsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#advanced-options-2"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        this.checkBox = new JCheckBox(TmmResourceBundle.getString("Settings.trailer.preferred"));
        panelOptions.add((Component)this.checkBox, "cell 1 0 2 1");
        JLabel lblTrailerSource = new JLabel(TmmResourceBundle.getString("Settings.trailer.source"));
        panelOptions.add((Component)lblTrailerSource, "cell 2 1");
        this.cbTrailerSource = new JComboBox();
        this.cbTrailerSource.setModel(new DefaultComboBoxModel<TrailerSources>(TrailerSources.values()));
        panelOptions.add(this.cbTrailerSource, "cell 2 1");
        JLabel lblTrailerQuality = new JLabel(TmmResourceBundle.getString("Settings.trailer.quality"));
        panelOptions.add((Component)lblTrailerQuality, "cell 2 2");
        this.cbTrailerQuality = new JComboBox();
        this.cbTrailerQuality.setModel(new DefaultComboBoxModel<TrailerQuality>(TrailerQuality.values()));
        panelOptions.add(this.cbTrailerQuality, "cell 2 2");
        this.chckbxAutomaticTrailerDownload = new JCheckBox(TmmResourceBundle.getString("Settings.trailer.automaticdownload"));
        panelOptions.add((Component)this.chckbxAutomaticTrailerDownload, "cell 2 3");
        this.lblAutomaticTrailerDownloadHint = new JLabel(TmmResourceBundle.getString("Settings.trailer.automaticdownload.hint"));
        panelOptions.add((Component)this.lblAutomaticTrailerDownloadHint, "cell 2 4");
        TmmFontHelper.changeFont((JComponent)this.lblAutomaticTrailerDownloadHint, TmmFontHelper.L2);
        JPanel panelTrailerFilenames = new JPanel();
        panelOptions.add((Component)panelTrailerFilenames, "cell 1 5 2 1");
        panelTrailerFilenames.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", "[][][]"));
        JLabel lblTrailerFileNaming = new JLabel(TmmResourceBundle.getString("Settings.trailerFileNaming"));
        panelTrailerFilenames.add((Component)lblTrailerFileNaming, "cell 0 0");
        this.cbTrailerFilename1 = new JCheckBox(TmmResourceBundle.getString("Settings.moviefilename") + "-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.cbTrailerFilename1);
        panelTrailerFilenames.add((Component)this.cbTrailerFilename1, "cell 1 0");
        this.cbTrailerFilename2 = new JCheckBox("movie-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.cbTrailerFilename2);
        panelTrailerFilenames.add((Component)this.cbTrailerFilename2, "cell 1 1");
        this.cbTrailerFilename3 = new JCheckBox("trailers/movie-trailer." + TmmResourceBundle.getString("Settings.artwork.extension"));
        this.trailerFilenameButtonGroup.add(this.cbTrailerFilename3);
        panelTrailerFilenames.add((Component)this.cbTrailerFilename3, "cell 1 2");
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraperInTable);
        BeanProperty ScraperInTableBeanProperty = BeanProperty.create((String)"active");
        jTableBinding.addColumnBinding((Property)ScraperInTableBeanProperty).setColumnName(TmmResourceBundle.getString("Settings.active")).setColumnClass(Boolean.class);
        BeanProperty ScraperInTableBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)ScraperInTableBeanProperty_1).setColumnName(TmmResourceBundle.getString("mediafiletype.logo")).setEditable(false).setColumnClass(ImageIcon.class);
        BeanProperty ScraperInTableBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)ScraperInTableBeanProperty_2).setColumnName(TmmResourceBundle.getString("metatag.name")).setEditable(false).setColumnClass(String.class);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraperInTable, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"trailerSource");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, this.cbTrailerSource, (Property)jComboBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"trailerQuality");
        BeanProperty jComboBoxBeanProperty_1 = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, this.cbTrailerQuality, (Property)jComboBoxBeanProperty_1);
        autoBinding_2.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"useTrailerPreference");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.checkBox, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_3 = BeanProperty.create((String)"automaticTrailerDownload");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_3, (Object)this.chckbxAutomaticTrailerDownload, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.checkBox, (Property)jCheckBoxBeanProperty, (Object)this.chckbxAutomaticTrailerDownload, (Property)jCheckBoxBeanProperty_1);
        autoBinding_5.bind();
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.checkBox, (Property)jCheckBoxBeanProperty, (Object)this.lblAutomaticTrailerDownloadHint, (Property)jLabelBeanProperty);
        autoBinding_6.bind();
    }
}

