/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableFormat;
import org.tinymediamanager.ui.renderer.RightAlignTableCellRenderer;
import org.tinymediamanager.ui.renderer.RuntimeTableCellRenderer;

public class MovieSetTableFormat
extends TmmTreeTableFormat<TmmTreeNode> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieSetTableFormat() {
        FontMetrics fontMetrics = this.getFontMetrics();
        Comparator integerComparator = (o1, o2) -> {
            int value1 = 0;
            int value2 = 0;
            try {
                value1 = Integer.parseInt(o1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                value2 = Integer.parseInt(o2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Integer.compare(value1, value2);
        };
        Comparator floatComparator = (o1, o2) -> {
            float value1 = 0.0f;
            float value2 = 0.0f;
            try {
                value1 = Float.parseFloat(o1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                value2 = Float.parseFloat(o2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Float.compare(value1, value2);
        };
        TmmTableFormat.VideoFormatComparator videoFormatComparator = new TmmTableFormat.VideoFormatComparator();
        TmmTableFormat.FileSizeComparator fileSizeComparator = new TmmTableFormat.FileSizeComparator();
        TmmTableFormat.ImageComparator imageComparator = new TmmTableFormat.ImageComparator();
        TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
        TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("movieset.moviecount"), "seasons", this::getMovieCount, String.class);
        col.setHeaderIcon(IconManager.COUNT);
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("99") * 1.2f));
        col.setColumnComparator(integerComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.year"), "year", this::getYear, String.class);
        col.setColumnComparator(integerComparator);
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", this::getVideoFilename, String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setColumnTooltip(this::getVideoFilename);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.path"), "path", this::getMoviePath, String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setColumnTooltip(this::getMoviePath);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.rating"), "rating", this::getRating, String.class);
        col.setHeaderIcon(IconManager.RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("99.9") * 1.2f));
        col.setDefaultHidden(true);
        col.setColumnComparator(floatComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.userrating"), "userrating", this::getUserRating, String.class);
        col.setColumnComparator(floatComparator);
        col.setHeaderIcon(IconManager.RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("99.9") * 1.2f + 10.0f));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.votes"), "votes", this::getVotes, String.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.VOTES);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("1000000") * 1.2f + 10.0f));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.runtime") + " [min]", "runtime", this::getRuntime, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.RUNTIME);
        col.setCellRenderer(new RuntimeTableCellRenderer(RuntimeTableCellRenderer.FORMAT.MINUTES));
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("200") * 1.2f + 10.0f));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.runtime") + " [hh:mm]", "runtime2", this::getRuntime, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.RUNTIME);
        col.setCellRenderer(new RuntimeTableCellRenderer(RuntimeTableCellRenderer.FORMAT.HOURS_MINUTES));
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("4:00") * 1.2f + 10.0f));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.format"), "format", this::getMediaInfoVideoFormat, String.class);
        col.setHeaderIcon(IconManager.VIDEO_FORMAT);
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("1080p") * 1.2f));
        col.setColumnComparator(videoFormatComparator);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videocodec"), "videoCodec", this::getMediaInfoVideoCodec, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.VIDEO_CODEC);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("MPEG-2") * 1.2f + 10.0f));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videobitrate"), "videoBitrate", this::getMediaInfoVideoBitrate, String.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.VIDEO_BITRATE);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("20000") * 1.2f + 10.0f));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.audio"), "audio", this::getAudioInformation, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.AUDIO);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("DTS 7ch") * 1.2f + 10.0f));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videofilesize"), "fileSize", this::getFileSize, String.class);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("50000M") * 1.2f));
        col.setColumnComparator(fileSizeComparator);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.totalfilesize"), "totalFileSize", this::getTotalFileSize, String.class);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("50000M") * 1.2f));
        col.setDefaultHidden(true);
        col.setColumnComparator(fileSizeComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.metadata"), "metadata", this::hasMetadata, ImageIcon.class);
        col.setHeaderIcon(IconManager.NFO);
        col.setColumnResizeable(false);
        col.setColumnComparator(imageComparator);
        col.setColumnTooltip(this::hasMetadataTooltip);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.images"), "images", this::hasImages, ImageIcon.class);
        col.setHeaderIcon(IconManager.IMAGES);
        col.setColumnResizeable(false);
        col.setColumnComparator(imageComparator);
        col.setColumnTooltip(this::hasImagesTooltip);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.watched"), "watched", this::isWatched, ImageIcon.class);
        col.setHeaderIcon(IconManager.WATCHED);
        col.setColumnResizeable(false);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
    }

    @Override
    public String getColumnName(int i) {
        if (i == -1) {
            return TmmResourceBundle.getString("metatag.title");
        }
        return super.getColumnName(i);
    }

    private String getMovieCount(TmmTreeNode node) {
        int size;
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet && (size = ((MovieSet)userObject).getMovies().size()) > 0) {
            return String.valueOf(size);
        }
        return null;
    }

    private String getRating(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if (userObject instanceof Movie && (mediaRating = ((MediaEntity)userObject).getRating()) != null && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getRating());
        }
        return null;
    }

    private String getFileSize(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            long size = ((Movie)userObject).getVideoFilesize();
            return (int)((double)size / 1000000.0) + " M";
        }
        return null;
    }

    private String getTotalFileSize(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            long size = ((Movie)userObject).getTotalFilesize();
            return (int)((double)size / 1000000.0) + " M";
        }
        return null;
    }

    private ImageIcon hasMetadata(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            return this.getCheckIcon(this.movieList.detectMissingMetadata((MovieSet)userObject).isEmpty());
        }
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            return this.getCheckIcon(this.movieList.detectMissingMetadata((Movie)userObject).isEmpty());
        }
        return null;
    }

    private String hasMetadataTooltip(TmmTreeNode node) {
        if (!MovieModuleManager.getInstance().getSettings().isShowMovieSetTableTooltips()) {
            return null;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            ArrayList<MovieSetScraperMetadataConfig> values = new ArrayList<MovieSetScraperMetadataConfig>();
            if (MovieModuleManager.getInstance().getSettings().isMovieSetDisplayAllMissingMetadata()) {
                for (MovieSetScraperMetadataConfig config : MovieSetScraperMetadataConfig.values()) {
                    if (!config.isMetaData() && !config.isCast()) continue;
                    values.add(config);
                }
            } else {
                values.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetCheckMetadata());
            }
            return this.getMissingToolTip(this.movieList.detectMissingFields((MovieSet)userObject, values));
        }
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            ArrayList<MovieScraperMetadataConfig> values = new ArrayList<MovieScraperMetadataConfig>();
            for (MovieScraperMetadataConfig config : MovieScraperMetadataConfig.values()) {
                if (!config.isMetaData() && !config.isCast()) continue;
                values.add(config);
            }
            return this.getMissingToolTip(this.movieList.detectMissingFields((Movie)userObject, values));
        }
        return null;
    }

    private ImageIcon hasImages(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            return this.getCheckIcon(this.movieList.detectMissingArtwork((MovieSet)userObject).isEmpty());
        }
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            return this.getCheckIcon(this.movieList.detectMissingArtwork((Movie)userObject).isEmpty());
        }
        return null;
    }

    private String hasImagesTooltip(TmmTreeNode node) {
        if (!MovieModuleManager.getInstance().getSettings().isShowMovieSetTableTooltips()) {
            return null;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            ArrayList<MovieSetScraperMetadataConfig> values = new ArrayList<MovieSetScraperMetadataConfig>();
            if (MovieModuleManager.getInstance().getSettings().isMovieSetDisplayAllMissingArtwork()) {
                for (MovieSetScraperMetadataConfig config : MovieSetScraperMetadataConfig.values()) {
                    if (!config.isArtwork()) continue;
                    values.add(config);
                }
            } else {
                values.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetCheckArtwork());
            }
            return this.getMissingToolTip(this.movieList.detectMissingFields((MovieSet)userObject, values));
        }
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            ArrayList<MovieScraperMetadataConfig> values = new ArrayList<MovieScraperMetadataConfig>();
            for (MovieScraperMetadataConfig config : MovieScraperMetadataConfig.values()) {
                if (!config.isArtwork()) continue;
                values.add(config);
            }
            return this.getMissingToolTip(this.movieList.detectMissingFields((Movie)userObject, values));
        }
        return null;
    }

    private ImageIcon isWatched(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet) {
            return this.getCheckIcon(((MovieSet)userObject).isWatched());
        }
        if (userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            return this.getCheckIcon(((Movie)userObject).isWatched());
        }
        return null;
    }

    private Integer getRuntime(TmmTreeNode node) {
        int runtime;
        Object userObject = node.getUserObject();
        if (userObject instanceof Movie && (runtime = ((Movie)userObject).getRuntime()) > 0) {
            return runtime;
        }
        return null;
    }

    private String getYear(TmmTreeNode node) {
        int year;
        String years;
        Object userobject = node.getUserObject();
        if (userobject instanceof MovieSet && StringUtils.isNotBlank((CharSequence)(years = ((MovieSet)userobject).getYears()))) {
            return years;
        }
        if (userobject instanceof Movie && (year = ((Movie)userobject).getYear()) > 0) {
            return String.valueOf(year);
        }
        return null;
    }

    private String getMediaInfoVideoFormat(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            String videoFormat = ((Movie)userObject).getMediaInfoVideoFormat();
            return videoFormat;
        }
        return null;
    }

    private String getMediaInfoVideoCodec(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            String videoCodec = ((Movie)userObject).getMediaInfoVideoCodec();
            return videoCodec;
        }
        return null;
    }

    private String getMediaInfoVideoBitrate(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            return String.valueOf(((Movie)userObject).getMediaInfoVideoBitrate());
        }
        return null;
    }

    private String getUserRating(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie && (mediaRating = ((MediaEntity)userObject).getUserRating()) != null && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getRating());
        }
        return null;
    }

    private String getVotes(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            return String.valueOf(((MediaEntity)userObject).getRating().getVotes());
        }
        return null;
    }

    private String getAudioInformation(TmmTreeNode node) {
        MediaFile mediaFile;
        List<MediaFile> videos;
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie && !(videos = ((MediaEntity)userObject).getMediaFiles(MediaFileType.VIDEO)).isEmpty() && StringUtils.isNotBlank((CharSequence)(mediaFile = videos.get(0)).getAudioCodec())) {
            return mediaFile.getAudioCodec() + " " + mediaFile.getAudioChannels();
        }
        return null;
    }

    private String getMoviePath(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            return ((MediaEntity)userObject).getPathNIO().toString();
        }
        return null;
    }

    private String getVideoFilename(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof MovieSet || userObject instanceof MovieSet.MovieSetMovie) {
            return null;
        }
        if (userObject instanceof Movie) {
            return ((Movie)userObject).getMainVideoFile().getFilename();
        }
        return null;
    }

    private String getMissingToolTip(List<? extends ScraperMetadataConfig> missingValues) {
        if (!missingValues.isEmpty()) {
            StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
            for (ScraperMetadataConfig scraperMetadataConfig : missingValues) {
                missing.append("\n").append(scraperMetadataConfig.getDescription());
            }
            return missing.toString();
        }
        return null;
    }
}

