/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.dialogs.MovieEditorDialog;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;
import org.tinymediamanager.ui.moviesets.dialogs.MovieSetEditorDialog;

public class MovieSetEditAction
extends TmmAction {
    private static final long serialVersionUID = 1848573591741154631L;

    public MovieSetEditAction() {
        this.putValue("Name", TmmResourceBundle.getString("movieset.edit"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", TmmResourceBundle.getString("movieset.edit"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = MovieSetUIModule.getInstance().getSelectionModel().getSelectedObjects();
        int selectedCount = selectedObjects.size();
        int index = 0;
        if (selectedObjects.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        do {
            TmmDialog editor;
            Object object;
            if ((object = selectedObjects.get(index)) instanceof MovieSet) {
                MovieSet movieSet = (MovieSet)object;
                editor = new MovieSetEditorDialog(movieSet, index, selectedCount);
                editor.setVisible(true);
                if (!((MovieSetEditorDialog)editor).isContinueQueue()) break;
                index = ((MovieSetEditorDialog)editor).isNavigateBack() ? --index : ++index;
            }
            if (!(object instanceof Movie)) continue;
            Movie movie = (Movie)object;
            editor = new MovieEditorDialog(movie, index, selectedCount);
            editor.setVisible(true);
            if (!((MovieEditorDialog)editor).isContinueQueue()) break;
            if (((MovieEditorDialog)editor).isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < selectedCount);
    }
}

