/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetRenameAction
extends TmmAction {
    private static final long serialVersionUID = 1677285197819210130L;

    public MovieSetRenameAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.rename"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.rename"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = MovieSetUIModule.getInstance().getSelectionModel().getSelectedObjects();
        HashSet<Movie> selectedMovies = new HashSet<Movie>();
        for (Object obj : selectedObjects) {
            if (obj instanceof MovieSet.MovieSetMovie) continue;
            if (obj instanceof Movie) {
                selectedMovies.add((Movie)obj);
                continue;
            }
            if (!(obj instanceof MovieSet)) continue;
            selectedMovies.addAll(((MovieSet)obj).getMovies());
        }
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MovieRenameTask renameTask = new MovieRenameTask(new ArrayList<Movie>(selectedMovies));
        TmmTaskManager.getInstance().addMainTask(renameTask);
    }
}

