/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;
import org.tinymediamanager.ui.moviesets.dialogs.MovieSetChooserDialog;

public class MovieSetSearchAction
extends TmmAction {
    private static final long serialVersionUID = -2260581786599155278L;

    public MovieSetSearchAction() {
        this.putValue("Name", TmmResourceBundle.getString("movieset.search"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("ShortDescription", TmmResourceBundle.getString("movieset.search"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        MovieSet movieSet;
        MovieSetChooserDialog chooser;
        List<MovieSet> selectedMovieSets = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets();
        if (selectedMovieSets.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        Iterator<MovieSet> iterator = selectedMovieSets.iterator();
        while (iterator.hasNext() && (chooser = new MovieSetChooserDialog(movieSet = iterator.next(), selectedMovieSets.size() > 1)).showDialog()) {
        }
    }
}

