/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.thirdparty.trakttv.MovieSyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetSyncSelectedRatingTraktTvAction
extends TmmAction {
    private static final long serialVersionUID = 6640292090443882545L;

    public MovieSetSyncSelectedRatingTraktTvAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.synctrakt.selected.rating"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.synctrakt.selected.rating.desc"));
        this.putValue("SmallIcon", IconManager.RATING_BLUE);
        this.putValue("SwingLargeIconKey", IconManager.RATING_BLUE);
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MovieSyncTraktTvTask task = new MovieSyncTraktTvTask(selectedMovies);
        task.setSyncRating(true);
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

