/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.filenaming.MovieSetBannerNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetClearartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetClearlogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetDiscartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetLogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetPosterNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetThumbNaming;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;

class MovieSetImageSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 7312645402037806284L;
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private final ItemListener checkBoxListener = e -> this.checkChanges();
    private JCheckBox chckbxPoster1;
    private JCheckBox chckbxPoster2;
    private JCheckBox chckbxPoster3;
    private JCheckBox chckbxFanart1;
    private JCheckBox chckbxFanart2;
    private JCheckBox chckbxFanart3;
    private JCheckBox chckbxBanner1;
    private JCheckBox chckbxBanner2;
    private JCheckBox chckbxBanner3;
    private JCheckBox chckbxLogo1;
    private JCheckBox chckbxLogo2;
    private JCheckBox chckbxLogo3;
    private JCheckBox chckbxClearlogo1;
    private JCheckBox chckbxClearlogo2;
    private JCheckBox chckbxClearlogo3;
    private JCheckBox chckbxClearart1;
    private JCheckBox chckbxClearart2;
    private JCheckBox chckbxClearart3;
    private JCheckBox chckbxThumb1;
    private JCheckBox chckbxThumb2;
    private JCheckBox chckbxThumb3;
    private JCheckBox chckbxThumb4;
    private JCheckBox chckbxThumb5;
    private JCheckBox chckbxThumb6;
    private JCheckBox chckbxDiscart1;
    private JCheckBox chckbxDiscart2;
    private JCheckBox chckbxDiscart3;
    private JCheckBox chckbxDiscart4;
    private JCheckBox chckbxDiscart5;
    private JCheckBox chckbxDiscart6;
    private JCheckBox chckbxAutomaticScrape;

    MovieSetImageSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.buildCheckBoxes();
    }

    private void buildCheckBoxes() {
        this.clearSelection(this.chckbxFanart1, this.chckbxFanart2, this.chckbxFanart3);
        this.clearSelection(this.chckbxPoster1, this.chckbxPoster2, this.chckbxPoster3);
        this.clearSelection(this.chckbxBanner1, this.chckbxBanner2, this.chckbxBanner3);
        this.clearSelection(this.chckbxClearart1, this.chckbxClearart2, this.chckbxClearart3);
        this.clearSelection(this.chckbxClearlogo1, this.chckbxClearlogo2, this.chckbxClearlogo3);
        this.clearSelection(this.chckbxLogo1, this.chckbxLogo2, this.chckbxLogo3);
        this.clearSelection(this.chckbxThumb1, this.chckbxThumb2, this.chckbxThumb3, this.chckbxThumb4, this.chckbxThumb5, this.chckbxThumb6);
        this.clearSelection(this.chckbxDiscart1, this.chckbxDiscart2, this.chckbxDiscart3, this.chckbxDiscart4, this.chckbxDiscart5, this.chckbxDiscart6);
        for (MovieSetPosterNaming poster : this.settings.getMovieSetPosterFilenames()) {
            switch (poster) {
                case MOVIE_POSTER: {
                    this.chckbxPoster1.setSelected(true);
                    break;
                }
                case KODI_POSTER: {
                    this.chckbxPoster2.setSelected(true);
                    break;
                }
                case AUTOMATOR_POSTER: {
                    this.chckbxPoster3.setSelected(true);
                }
            }
        }
        for (MovieSetFanartNaming fanart : this.settings.getMovieSetFanartFilenames()) {
            switch (fanart) {
                case MOVIE_FANART: {
                    this.chckbxFanart1.setSelected(true);
                    break;
                }
                case KODI_FANART: {
                    this.chckbxFanart2.setSelected(true);
                    break;
                }
                case AUTOMATOR_FANART: {
                    this.chckbxFanart3.setSelected(true);
                }
            }
        }
        for (MovieSetBannerNaming banner : this.settings.getMovieSetBannerFilenames()) {
            switch (banner) {
                case MOVIE_BANNER: {
                    this.chckbxBanner1.setSelected(true);
                    break;
                }
                case KODI_BANNER: {
                    this.chckbxBanner2.setSelected(true);
                    break;
                }
                case AUTOMATOR_BANNER: {
                    this.chckbxBanner3.setSelected(true);
                }
            }
        }
        for (MovieSetClearartNaming clearart : this.settings.getMovieSetClearartFilenames()) {
            switch (clearart) {
                case MOVIE_CLEARART: {
                    this.chckbxClearart1.setSelected(true);
                    break;
                }
                case KODI_CLEARART: {
                    this.chckbxClearart2.setSelected(true);
                    break;
                }
                case AUTOMATOR_CLEARART: {
                    this.chckbxClearart3.setSelected(true);
                }
            }
        }
        for (MovieSetThumbNaming thumb : this.settings.getMovieSetThumbFilenames()) {
            switch (thumb) {
                case MOVIE_THUMB: {
                    this.chckbxThumb1.setSelected(true);
                    break;
                }
                case KODI_THUMB: {
                    this.chckbxThumb2.setSelected(true);
                    break;
                }
                case AUTOMATOR_THUMB: {
                    this.chckbxThumb3.setSelected(true);
                    break;
                }
                case MOVIE_LANDSCAPE: {
                    this.chckbxThumb4.setSelected(true);
                    break;
                }
                case KODI_LANDSCAPE: {
                    this.chckbxThumb5.setSelected(true);
                    break;
                }
                case AUTOMATOR_LANDSCAPE: {
                    this.chckbxThumb6.setSelected(true);
                }
            }
        }
        for (MovieSetLogoNaming logo : this.settings.getMovieSetLogoFilenames()) {
            switch (logo) {
                case MOVIE_LOGO: {
                    this.chckbxLogo1.setSelected(true);
                    break;
                }
                case KODI_LOGO: {
                    this.chckbxLogo2.setSelected(true);
                    break;
                }
                case AUTOMATOR_LOGO: {
                    this.chckbxLogo3.setSelected(true);
                }
            }
        }
        for (MovieSetClearlogoNaming clearlogo : this.settings.getMovieSetClearlogoFilenames()) {
            switch (clearlogo) {
                case MOVIE_CLEARLOGO: {
                    this.chckbxClearlogo1.setSelected(true);
                    break;
                }
                case KODI_CLEARLOGO: {
                    this.chckbxClearlogo2.setSelected(true);
                    break;
                }
                case AUTOMATOR_CLEARLOGO: {
                    this.chckbxClearlogo3.setSelected(true);
                }
            }
        }
        for (MovieSetDiscartNaming disc : this.settings.getMovieSetDiscartFilenames()) {
            switch (disc) {
                case MOVIE_DISC: {
                    this.chckbxDiscart1.setSelected(true);
                    break;
                }
                case KODI_DISC: {
                    this.chckbxDiscart2.setSelected(true);
                    break;
                }
                case AUTOMATOR_DISC: {
                    this.chckbxDiscart3.setSelected(true);
                    break;
                }
                case MOVIE_DISCART: {
                    this.chckbxDiscart4.setSelected(true);
                    break;
                }
                case KODI_DISCART: {
                    this.chckbxDiscart5.setSelected(true);
                    break;
                }
                case AUTOMATOR_DISCART: {
                    this.chckbxDiscart6.setSelected(true);
                }
            }
        }
        this.chckbxPoster1.addItemListener(this.checkBoxListener);
        this.chckbxPoster2.addItemListener(this.checkBoxListener);
        this.chckbxPoster3.addItemListener(this.checkBoxListener);
        this.chckbxFanart1.addItemListener(this.checkBoxListener);
        this.chckbxFanart2.addItemListener(this.checkBoxListener);
        this.chckbxFanart3.addItemListener(this.checkBoxListener);
        this.chckbxBanner1.addItemListener(this.checkBoxListener);
        this.chckbxBanner2.addItemListener(this.checkBoxListener);
        this.chckbxBanner3.addItemListener(this.checkBoxListener);
        this.chckbxClearart1.addItemListener(this.checkBoxListener);
        this.chckbxClearart2.addItemListener(this.checkBoxListener);
        this.chckbxClearart3.addItemListener(this.checkBoxListener);
        this.chckbxClearlogo1.addItemListener(this.checkBoxListener);
        this.chckbxClearlogo2.addItemListener(this.checkBoxListener);
        this.chckbxClearlogo3.addItemListener(this.checkBoxListener);
        this.chckbxLogo1.addItemListener(this.checkBoxListener);
        this.chckbxLogo2.addItemListener(this.checkBoxListener);
        this.chckbxLogo3.addItemListener(this.checkBoxListener);
        this.chckbxThumb1.addItemListener(this.checkBoxListener);
        this.chckbxThumb2.addItemListener(this.checkBoxListener);
        this.chckbxThumb3.addItemListener(this.checkBoxListener);
        this.chckbxThumb4.addItemListener(this.checkBoxListener);
        this.chckbxThumb5.addItemListener(this.checkBoxListener);
        this.chckbxThumb5.addItemListener(this.checkBoxListener);
        this.chckbxDiscart1.addItemListener(this.checkBoxListener);
        this.chckbxDiscart2.addItemListener(this.checkBoxListener);
        this.chckbxDiscart3.addItemListener(this.checkBoxListener);
        this.chckbxDiscart4.addItemListener(this.checkBoxListener);
        this.chckbxDiscart5.addItemListener(this.checkBoxListener);
        this.chckbxDiscart6.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.removeItemListener(this.checkBoxListener);
            checkBox.setSelected(false);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[900lp,grow]", "[]"));
        JPanel panelMovieSet = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][][20lp!][][20lp!][][20lp!][grow]", "[][10lp!][][10lp!][][10lp!][][20lp!][][][10lp!][][10lp!][][10lp!][][10lp!][][10lp!][][][10lp!][][10lp!][][10lp!][][][20lp!][]"));
        TmmLabel lblTitle = new TmmLabel(TmmResourceBundle.getString("Settings.movieset"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelMovieSet, lblTitle, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        this.chckbxAutomaticScrape = new JCheckBox(TmmResourceBundle.getString("Settings.default.autoscrape"));
        panelMovieSet.add((Component)this.chckbxAutomaticScrape, "cell 1 0 8 1");
        ReadOnlyTextArea readOnlyTextArea = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.movieset.artwork.desc"));
        panelMovieSet.add((Component)readOnlyTextArea, "cell 1 2 8 1,wmin 0,grow");
        JPanel panelFolderSettings = new JPanel();
        panelMovieSet.add((Component)panelFolderSettings, "cell 1 4 8 1,grow");
        panelFolderSettings.setLayout((LayoutManager)new MigLayout("insets 0", "[][grow]", "[][][]"));
        TmmLabel lblMovieFolderT = new TmmLabel(TmmResourceBundle.getString("Settings.movieset.moviefolder") + ":");
        panelFolderSettings.add((Component)lblMovieFolderT, "cell 0 0");
        JLabel lblMovieFolder = new JLabel(TmmResourceBundle.getString("Settings.movieset.moviefolder.example"));
        panelFolderSettings.add((Component)lblMovieFolder, "cell 1 0");
        TmmLabel lblKodiFolderT = new TmmLabel(TmmResourceBundle.getString("Settings.movieset.foldername.kodi") + ":");
        panelFolderSettings.add((Component)lblKodiFolderT, "cell 0 1");
        JLabel lblKodiFolder = new JLabel(TmmResourceBundle.getString("Settings.movieset.foldername.kodi.example"));
        panelFolderSettings.add((Component)lblKodiFolder, "cell 1 1");
        TmmLabel lblAutomatorFolderT = new TmmLabel(TmmResourceBundle.getString("Settings.movieset.foldername.automator") + ":");
        panelFolderSettings.add((Component)lblAutomatorFolderT, "cell 0 2");
        JLabel lblAutomatorFolder = new JLabel(TmmResourceBundle.getString("Settings.movieset.foldername.automator.example"));
        panelFolderSettings.add((Component)lblAutomatorFolder, "cell 1 2");
        ReadOnlyTextArea taHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.movieset.artwork.hint"));
        panelMovieSet.add((Component)taHint, "cell 2 6 7 1,wmin 0,grow");
        TmmLabel lblMovieFolderT2 = new TmmLabel(TmmResourceBundle.getString("Settings.movieset.moviefolder"));
        panelMovieSet.add((Component)lblMovieFolderT2, "cell 4 8");
        TmmLabel lblKodiStyleT = new TmmLabel("Kodi/Artwork Beef style");
        panelMovieSet.add((Component)lblKodiStyleT, "cell 6 8");
        TmmLabel lblMovieSetAutomatorT = new TmmLabel("Movie Set Artwork Automator style");
        panelMovieSet.add((Component)lblMovieSetAutomatorT, "cell 8 8");
        JLabel lblMovieFolder2T = new JLabel(TmmResourceBundle.getString("Settings.moviefolder"));
        panelMovieSet.add((Component)lblMovieFolder2T, "flowx,cell 4 9");
        JLabel lblArtworkFolder2T = new JLabel(TmmResourceBundle.getString("Settings.movieset.moviesetartworkfolder"));
        panelMovieSet.add((Component)lblArtworkFolder2T, "cell 6 9");
        JLabel lblArtworkFolder3T = new JLabel(TmmResourceBundle.getString("Settings.movieset.moviesetartworkfolder"));
        panelMovieSet.add((Component)lblArtworkFolder3T, "cell 8 9");
        TmmLabel lblPosterFilenameT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster"));
        panelMovieSet.add((Component)lblPosterFilenameT, "cell 1 11 2 1");
        this.chckbxPoster1 = new JCheckBox("movieset-poster." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxPoster1, "cell 4 11");
        this.chckbxPoster2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/poster." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxPoster2, "cell 6 11");
        this.chckbxPoster3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-poster." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxPoster3, "cell 8 11");
        TmmLabel lblFanartFilenameT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart"));
        panelMovieSet.add((Component)lblFanartFilenameT, "cell 1 13 2 1");
        this.chckbxFanart1 = new JCheckBox("movieset-fanart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxFanart1, "cell 4 13");
        this.chckbxFanart2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/fanart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxFanart2, "cell 6 13");
        this.chckbxFanart3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-fanart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxFanart3, "cell 8 13");
        TmmLabel lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        panelMovieSet.add((Component)lblBannerT, "cell 1 15 2 1");
        this.chckbxBanner1 = new JCheckBox("movieset-banner." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxBanner1, "cell 4 15");
        this.chckbxBanner2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/banner." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxBanner2, "cell 6 15");
        this.chckbxBanner3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-banner." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxBanner3, "cell 8 15");
        TmmLabel lblClearartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearart"));
        panelMovieSet.add((Component)lblClearartT, "cell 1 17 2 1");
        this.chckbxClearart1 = new JCheckBox("movieset-clearart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearart1, "cell 4 17");
        this.chckbxClearart2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/clearart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearart2, "cell 6 17");
        this.chckbxClearart3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-clearart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearart3, "cell 8 17");
        TmmLabel lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        panelMovieSet.add((Component)lblThumbT, "cell 1 19 2 1");
        this.chckbxThumb1 = new JCheckBox("movieset-thumb." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb1, "cell 4 19");
        this.chckbxThumb2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/thumb." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb2, "cell 6 19");
        this.chckbxThumb3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-thumb." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb3, "cell 8 19");
        this.chckbxThumb4 = new JCheckBox("movieset-landscape." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb4, "cell 4 20");
        this.chckbxThumb5 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/landscape." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb5, "cell 6 20");
        this.chckbxThumb6 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-landscape." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxThumb6, "cell 8 20");
        TmmLabel lblLogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.logo"));
        panelMovieSet.add((Component)lblLogoT, "cell 1 22 2 1");
        this.chckbxLogo1 = new JCheckBox("movieset-logo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxLogo1, "cell 4 22");
        this.chckbxLogo2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/logo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxLogo2, "cell 6 22");
        this.chckbxLogo3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-logo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxLogo3, "cell 8 22");
        TmmLabel lblClearlogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        panelMovieSet.add((Component)lblClearlogoT, "cell 1 24 2 1");
        this.chckbxClearlogo1 = new JCheckBox("movieset-clearlogo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearlogo1, "cell 4 24");
        this.chckbxClearlogo2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/clearlogo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearlogo2, "cell 6 24");
        this.chckbxClearlogo3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-clearlogo." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxClearlogo3, "cell 8 24");
        TmmLabel lblDiscartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.disc"));
        panelMovieSet.add((Component)lblDiscartT, "cell 1 26 2 1");
        this.chckbxDiscart1 = new JCheckBox("movieset-disc." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart1, "cell 4 26");
        this.chckbxDiscart2 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/disc." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart2, "cell 6 26");
        this.chckbxDiscart3 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-disc." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart3, "cell 8 26");
        this.chckbxDiscart4 = new JCheckBox("movieset-discart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart4, "cell 4 27");
        this.chckbxDiscart5 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "/discart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart5, "cell 6 27");
        this.chckbxDiscart6 = new JCheckBox(TmmResourceBundle.getString("Settings.movieset.moviesetname") + "-discart." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panelMovieSet.add((Component)this.chckbxDiscart6, "cell 8 27");
        ReadOnlyTextArea tpFileNamingHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.naming.info"));
        panelMovieSet.add((Component)tpFileNamingHint, "cell 2 29 7 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpFileNamingHint, 0.833);
    }

    private void checkChanges() {
        this.settings.clearMovieSetPosterFilenames();
        if (this.chckbxPoster1.isSelected()) {
            this.settings.addMovieSetPosterFilename(MovieSetPosterNaming.MOVIE_POSTER);
        }
        if (this.chckbxPoster2.isSelected()) {
            this.settings.addMovieSetPosterFilename(MovieSetPosterNaming.KODI_POSTER);
        }
        if (this.chckbxPoster3.isSelected()) {
            this.settings.addMovieSetPosterFilename(MovieSetPosterNaming.AUTOMATOR_POSTER);
        }
        this.settings.clearMovieSetFanartFilenames();
        if (this.chckbxFanart1.isSelected()) {
            this.settings.addMovieSetFanartFilename(MovieSetFanartNaming.MOVIE_FANART);
        }
        if (this.chckbxFanart2.isSelected()) {
            this.settings.addMovieSetFanartFilename(MovieSetFanartNaming.KODI_FANART);
        }
        if (this.chckbxFanart3.isSelected()) {
            this.settings.addMovieSetFanartFilename(MovieSetFanartNaming.AUTOMATOR_FANART);
        }
        this.settings.clearMovieSetBannerFilenames();
        if (this.chckbxBanner1.isSelected()) {
            this.settings.addMovieSetBannerFilename(MovieSetBannerNaming.MOVIE_BANNER);
        }
        if (this.chckbxBanner2.isSelected()) {
            this.settings.addMovieSetBannerFilename(MovieSetBannerNaming.KODI_BANNER);
        }
        if (this.chckbxBanner3.isSelected()) {
            this.settings.addMovieSetBannerFilename(MovieSetBannerNaming.AUTOMATOR_BANNER);
        }
        this.settings.clearMovieSetClearartFilenames();
        if (this.chckbxClearart1.isSelected()) {
            this.settings.addMovieSetClearartFilename(MovieSetClearartNaming.MOVIE_CLEARART);
        }
        if (this.chckbxClearart2.isSelected()) {
            this.settings.addMovieSetClearartFilename(MovieSetClearartNaming.KODI_CLEARART);
        }
        if (this.chckbxClearart3.isSelected()) {
            this.settings.addMovieSetClearartFilename(MovieSetClearartNaming.AUTOMATOR_CLEARART);
        }
        this.settings.clearMovieSetThumbFilenames();
        if (this.chckbxThumb1.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.MOVIE_THUMB);
        }
        if (this.chckbxThumb2.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.KODI_THUMB);
        }
        if (this.chckbxThumb3.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.AUTOMATOR_THUMB);
        }
        if (this.chckbxThumb4.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.MOVIE_LANDSCAPE);
        }
        if (this.chckbxThumb5.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.KODI_LANDSCAPE);
        }
        if (this.chckbxThumb6.isSelected()) {
            this.settings.addMovieSetThumbFilename(MovieSetThumbNaming.AUTOMATOR_LANDSCAPE);
        }
        this.settings.clearMovieSetLogoFilenames();
        if (this.chckbxLogo1.isSelected()) {
            this.settings.addMovieSetLogoFilename(MovieSetLogoNaming.MOVIE_LOGO);
        }
        if (this.chckbxLogo2.isSelected()) {
            this.settings.addMovieSetLogoFilename(MovieSetLogoNaming.KODI_LOGO);
        }
        if (this.chckbxLogo3.isSelected()) {
            this.settings.addMovieSetLogoFilename(MovieSetLogoNaming.AUTOMATOR_LOGO);
        }
        this.settings.clearMovieSetClearlogoFilenames();
        if (this.chckbxClearlogo1.isSelected()) {
            this.settings.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.MOVIE_CLEARLOGO);
        }
        if (this.chckbxClearlogo2.isSelected()) {
            this.settings.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.KODI_CLEARLOGO);
        }
        if (this.chckbxClearlogo3.isSelected()) {
            this.settings.addMovieSetClearlogoFilename(MovieSetClearlogoNaming.AUTOMATOR_CLEARLOGO);
        }
        this.settings.clearMovieSetDiscartFilenames();
        if (this.chckbxDiscart1.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.MOVIE_DISC);
        }
        if (this.chckbxDiscart2.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.KODI_DISC);
        }
        if (this.chckbxDiscart3.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.AUTOMATOR_DISC);
        }
        if (this.chckbxDiscart4.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.MOVIE_DISCART);
        }
        if (this.chckbxDiscart5.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.KODI_DISCART);
        }
        if (this.chckbxDiscart6.isSelected()) {
            this.settings.addMovieSetDiscartFilename(MovieSetDiscartNaming.AUTOMATOR_DISCART);
        }
    }

    protected void initDataBindings() {
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"scrapeBestImageMovieSet");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.chckbxAutomaticScrape, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
    }
}

