/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import com.madgag.gif.fmsware.GifDecoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.WrapLayout;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.NoBorderScrollPane;

public class ImagePanel
extends JPanel
implements HierarchyListener {
    private static final long serialVersionUID = -5344085698387374260L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagePanel.class);
    private final List<MediaFile> mediaFiles;
    protected int maxWidth = 300;
    protected int maxHeight = 100;
    private ImageLoader activeWorker = null;
    private final JPanel panelImages;
    private final JScrollPane scrollPane;

    public ImagePanel(List<MediaFile> mediaFiles) {
        this.mediaFiles = mediaFiles;
        this.setLayout((LayoutManager)new MigLayout("", "[400lp,grow]", "[300lp,grow]"));
        this.scrollPane = new NoBorderScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)this.scrollPane, "cell 0 0,grow");
        this.panelImages = new JPanel();
        this.panelImages.setLayout(new WrapLayout(0));
        this.scrollPane.setViewportView(this.panelImages);
    }

    public void rebuildPanel() {
        if (this.activeWorker != null && !this.activeWorker.isDone()) {
            this.activeWorker.cancel(true);
        }
        this.panelImages.removeAll();
        this.panelImages.revalidate();
        this.scrollPane.repaint();
        this.activeWorker = new ImageLoader(this.mediaFiles);
        this.activeWorker.execute();
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent arg0) {
        if (this.isShowing() && this.panelImages.getComponents().length == 0 && !this.mediaFiles.isEmpty()) {
            this.rebuildPanel();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    private static class ImageLabelClickListener
    implements MouseListener {
        private final String pathToFile;

        private ImageLabelClickListener(String path) {
            this.pathToFile = path;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (StringUtils.isNotBlank((CharSequence)this.pathToFile)) {
                MainWindow.getInstance().createLightbox(this.pathToFile, "");
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    protected static class ImageChunk {
        private final String pathToImage;
        private final JComponent image;
        private final MediaFileType type;

        private ImageChunk(String path, MediaFileType type, JComponent image) {
            this.pathToImage = path;
            this.type = type;
            this.image = image;
        }
    }

    protected class ImageLoader
    extends SwingWorker<Void, ImageChunk> {
        private final List<MediaFile> mediaFiles;

        private ImageLoader(List<MediaFile> mediaFiles) {
            this.mediaFiles = mediaFiles;
        }

        @Override
        protected Void doInBackground() {
            for (MediaFile mediaFile : this.mediaFiles) {
                if (!ImagePanel.this.isShowing()) continue;
                if (this.isCancelled()) {
                    return null;
                }
                try {
                    Point size;
                    byte[] bytes;
                    GifDecoder decoder;
                    int status;
                    JComponent imageLabel = null;
                    Path file = ImageCache.getCachedFile(mediaFile);
                    if (file == null) {
                        file = mediaFile.getFileAsPath();
                    }
                    if ((status = (decoder = new GifDecoder()).read((InputStream)new ByteArrayInputStream(bytes = Files.readAllBytes(file)))) == 0 && decoder.getFrameCount() > 1) {
                        JPanel panel = new JPanel(new BorderLayout());
                        size = ImageUtils.calculateSize(ImagePanel.this.maxWidth, ImagePanel.this.maxHeight, decoder.getFrameSize().width, decoder.getFrameSize().height, true);
                        panel.setPreferredSize(new Dimension(size.x, size.y));
                        ImageLabel label = new ImageLabel(false);
                        label.setOriginalImage(bytes);
                        panel.add((Component)label, "Center");
                        imageLabel = panel;
                    } else {
                        BufferedImage bufferedImage = ImageUtils.createImage(bytes);
                        size = ImageUtils.calculateSize(ImagePanel.this.maxWidth, ImagePanel.this.maxHeight, bufferedImage.getWidth(), bufferedImage.getHeight(), true);
                        imageLabel = new JLabel(new ImageIcon(Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)size.x, (int)size.y, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS})));
                        imageLabel.addMouseListener(new ImageLabelClickListener(mediaFile.getFileAsPath().toString()));
                    }
                    if (this.isCancelled() || imageLabel == null) {
                        return null;
                    }
                    this.publish(new ImageChunk(mediaFile.getFileAsPath().toString(), mediaFile.getType(), imageLabel));
                }
                catch (Exception e) {
                    LOGGER.trace("scaling image failed: {}", (Object)e.getMessage());
                }
            }
            return null;
        }

        @Override
        protected void process(List<ImageChunk> chunks) {
            for (ImageChunk chunk : chunks) {
                try {
                    if (this.isCancelled()) {
                        return;
                    }
                    JPanel panelContainer = new JPanel(new BorderLayout());
                    panelContainer.add((Component)chunk.image, "Center");
                    JLabel lblImageType = new JLabel(TmmResourceBundle.getString("mediafiletype." + chunk.type.name().toLowerCase(Locale.ROOT)));
                    lblImageType.setHorizontalAlignment(0);
                    panelContainer.add((Component)lblImageType, "South");
                    ImagePanel.this.panelImages.add(panelContainer);
                    ImagePanel.this.panelImages.revalidate();
                    ImagePanel.this.scrollPane.repaint();
                }
                catch (Exception exception) {}
            }
        }
    }
}

