/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.AspectRatio;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.tasks.MediaFileARDetectorTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.thirdparty.FFmpeg;
import org.tinymediamanager.ui.DoubleInputVerifier;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.IntegerInputVerifier;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;

public class MediaFileEditorPanel
extends JPanel {
    private static final long serialVersionUID = -2416409052145301941L;
    private final BindingGroup bindingGroup = new BindingGroup();
    private TmmTask ardTask;
    private List<MediaFileContainer> mediaFiles = ObservableCollections.observableList(new ArrayList());
    private TmmTable tableMediaFiles;
    private JLabel lblFilename;
    private JTextField tfCodec;
    private JTextField tfContainerFormat;
    private JTextField tfWidth;
    private JTextField tfHeight;
    private TmmTable tableAudioStreams;
    private TmmTable tableSubtitles;
    private JButton btnAddAudioStream;
    private JButton btnRemoveAudioStream;
    private JButton btnAddSubtitle;
    private JButton btnRemoveSubtitle;
    private JComboBox<String> cb3dFormat;
    private JComboBox cbAspectRatio;
    private JComboBox cbAspectRatio2;
    private JTextField tfFrameRate;
    private JTextField tfBitDepth;
    private JTextField tfHdrFormat;
    private JTextField tfVideoBitrate;
    private JTextField tfRuntime;
    private JButton btnARD;

    public MediaFileEditorPanel(List<MediaFile> mediaFiles) {
        for (MediaFile mediaFile : mediaFiles) {
            MediaFileContainer container = new MediaFileContainer(mediaFile);
            this.mediaFiles.add(container);
        }
        HashSet<MediaFileType> videoTypes = new HashSet<MediaFileType>(Arrays.asList(MediaFileType.VIDEO, MediaFileType.SAMPLE, MediaFileType.TRAILER));
        String[] threeDFormats = new String[]{"", "3D", "3D SBS", "3D HSBS", "3D TAB", "3D HTAB", "3D MVC"};
        this.setLayout((LayoutManager)new MigLayout("", "[300lp:450lp,grow]", "[200lp:450lp,grow]"));
        JSplitPane splitPane = new JSplitPane();
        this.add((Component)splitPane, "cell 0 0,grow");
        JPanel panelMediaFiles = new JPanel();
        panelMediaFiles.setLayout((LayoutManager)new MigLayout("", "[200lp:250lp,grow]", "[200lp:300lp,grow]"));
        JScrollPane scrollPaneMediaFiles = new JScrollPane();
        panelMediaFiles.add((Component)scrollPaneMediaFiles, "cell 0 0,grow");
        splitPane.setLeftComponent(panelMediaFiles);
        this.tableMediaFiles = new TmmTable();
        this.tableMediaFiles.configureScrollPane(scrollPaneMediaFiles);
        JPanel panelDetails = new JPanel();
        splitPane.setRightComponent(panelDetails);
        panelDetails.setLayout((LayoutManager)new MigLayout("", "[][75lp:n][20lp:n][][75lp:n][20lp:n][][75lp:n][50lp:n,grow]", "[][][][][][][100lp:150lp][100lp:150lp]"));
        this.lblFilename = new JLabel("");
        TmmFontHelper.changeFont(this.lblFilename, 1.167, 1);
        panelDetails.add((Component)this.lblFilename, "cell 0 0 9 1,growx");
        TmmLabel lblCodec = new TmmLabel(TmmResourceBundle.getString("metatag.codec"));
        panelDetails.add((Component)lblCodec, "cell 0 1,alignx right");
        this.tfCodec = new JTextField();
        panelDetails.add((Component)this.tfCodec, "cell 1 1,growx");
        this.tfCodec.setColumns(10);
        TmmLabel lblContainerFormat = new TmmLabel(TmmResourceBundle.getString("metatag.container"));
        panelDetails.add((Component)lblContainerFormat, "cell 3 1,alignx right");
        this.tfContainerFormat = new JTextField();
        panelDetails.add((Component)this.tfContainerFormat, "cell 4 1,growx");
        this.tfContainerFormat.setColumns(10);
        TmmLabel lblWidth = new TmmLabel(TmmResourceBundle.getString("metatag.width"));
        panelDetails.add((Component)lblWidth, "cell 0 2,alignx right");
        this.tfWidth = new JTextField();
        this.tfWidth.setInputVerifier(new IntegerInputVerifier());
        panelDetails.add((Component)this.tfWidth, "cell 1 2,growx");
        this.tfWidth.setColumns(10);
        TmmLabel lblHeight = new TmmLabel(TmmResourceBundle.getString("metatag.height"));
        panelDetails.add((Component)lblHeight, "cell 3 2,alignx right");
        this.tfHeight = new JTextField();
        this.tfHeight.setInputVerifier(new IntegerInputVerifier());
        panelDetails.add((Component)this.tfHeight, "cell 4 2,growx");
        this.tfHeight.setColumns(10);
        this.btnARD = new JButton(new ScanAspectRationAction());
        MediaFile mf = this.mediaFiles.get((int)0).mediaFile;
        this.btnARD.setEnabled(videoTypes.contains((Object)mf.getType()));
        panelDetails.add((Component)this.btnARD, "cell 7 1");
        TmmLabel lblAspectT = new TmmLabel(TmmResourceBundle.getString("metatag.aspect"));
        panelDetails.add((Component)lblAspectT, "cell 6 2,alignx right");
        this.cbAspectRatio = new JComboBox<Float>(MediaFileEditorPanel.getAspectRatios().keySet().toArray(new Float[0]));
        this.cbAspectRatio.setEditable(true);
        this.cbAspectRatio.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text = MediaFileEditorPanel.getAspectRatios().get(value);
                if (StringUtils.isBlank((CharSequence)text)) {
                    text = String.valueOf(text);
                }
                return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            }
        });
        panelDetails.add((Component)this.cbAspectRatio, "cell 7 2");
        lblAspectT = new TmmLabel(TmmResourceBundle.getString("metatag.aspect2"));
        panelDetails.add((Component)lblAspectT, "cell 6 3,alignx right");
        this.cbAspectRatio2 = new JComboBox<Float>(MediaFileEditorPanel.getAspectRatios2().keySet().toArray(new Float[0]));
        this.cbAspectRatio2.setEditable(true);
        this.cbAspectRatio2.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text = MediaFileEditorPanel.getAspectRatios2().get(value);
                if (StringUtils.isBlank((CharSequence)text)) {
                    text = String.valueOf(text);
                }
                return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            }
        });
        panelDetails.add((Component)this.cbAspectRatio2, "cell 7 3");
        TmmLabel lblFrameRate = new TmmLabel(TmmResourceBundle.getString("metatag.framerate"));
        panelDetails.add((Component)lblFrameRate, "cell 0 3,alignx trailing");
        this.tfFrameRate = new JTextField();
        this.tfFrameRate.setInputVerifier(new DoubleInputVerifier());
        panelDetails.add((Component)this.tfFrameRate, "cell 1 3,growx");
        this.tfFrameRate.setColumns(10);
        TmmLabel lblVideoBitrate = new TmmLabel(TmmResourceBundle.getString("metatag.bitrate"));
        panelDetails.add((Component)lblVideoBitrate, "cell 3 3,alignx trailing");
        this.tfVideoBitrate = new JTextField();
        panelDetails.add((Component)this.tfVideoBitrate, "cell 4 3");
        this.tfVideoBitrate.setColumns(10);
        this.tfVideoBitrate.setInputVerifier(new IntegerInputVerifier());
        TmmLabel lblBitDepthT = new TmmLabel(TmmResourceBundle.getString("metatag.videobitdepth"));
        panelDetails.add((Component)lblBitDepthT, "cell 0 4,alignx trailing");
        this.tfBitDepth = new JTextField();
        this.tfBitDepth.setInputVerifier(new IntegerInputVerifier());
        panelDetails.add((Component)this.tfBitDepth, "cell 1 4,growx");
        this.tfBitDepth.setColumns(10);
        TmmLabel lblHdrFormatT = new TmmLabel(TmmResourceBundle.getString("metatag.hdrformat"));
        panelDetails.add((Component)lblHdrFormatT, "cell 3 4,alignx trailing");
        this.tfHdrFormat = new JTextField();
        panelDetails.add((Component)this.tfHdrFormat, "cell 4 4,growx");
        this.tfHdrFormat.setColumns(10);
        TmmLabel lblRuntimeT = new TmmLabel(TmmResourceBundle.getString("metatag.runtime"));
        panelDetails.add((Component)lblRuntimeT, "cell 0 5,alignx trailing");
        this.tfRuntime = new JTextField();
        panelDetails.add((Component)this.tfRuntime, "cell 1 5");
        this.tfRuntime.setColumns(5);
        this.tfRuntime.setInputVerifier(new IntegerInputVerifier());
        TmmLabel lbl3d = new TmmLabel("3D Format");
        panelDetails.add((Component)lbl3d, "cell 3 5,alignx right");
        this.cb3dFormat = new JComboBox<String>(threeDFormats);
        panelDetails.add(this.cb3dFormat, "cell 4 5");
        TmmLabel lblAudiostreams = new TmmLabel("AudioStreams");
        panelDetails.add((Component)lblAudiostreams, "flowy,cell 0 6,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        panelDetails.add((Component)scrollPane, "cell 1 6 8 1,grow");
        this.tableAudioStreams = new TmmTable();
        this.tableAudioStreams.configureScrollPane(scrollPane);
        TmmLabel lblSubtitles = new TmmLabel("Subtitles");
        panelDetails.add((Component)lblSubtitles, "flowy,cell 0 7,alignx right,aligny top");
        scrollPane = new JScrollPane();
        panelDetails.add((Component)scrollPane, "cell 1 7 8 1,grow");
        this.tableSubtitles = new TmmTable();
        this.tableSubtitles.configureScrollPane(scrollPane);
        this.btnAddAudioStream = new SquareIconButton(new AddAudioStreamAction());
        panelDetails.add((Component)this.btnAddAudioStream, "cell 0 6,alignx right,aligny top");
        this.btnRemoveAudioStream = new SquareIconButton(new RemoveAudioStreamAction());
        panelDetails.add((Component)this.btnRemoveAudioStream, "cell 0 6,alignx right,aligny top");
        this.btnAddSubtitle = new SquareIconButton(new AddSubtitleAction());
        panelDetails.add((Component)this.btnAddSubtitle, "cell 0 7,alignx right,aligny top");
        this.btnRemoveSubtitle = new SquareIconButton(new RemoveSubtitleAction());
        panelDetails.add((Component)this.btnRemoveSubtitle, "cell 0 7,alignx right,aligny top");
        this.initDataBindings();
        if (!this.mediaFiles.isEmpty()) {
            this.tableMediaFiles.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.tableMediaFiles.getSelectionModel().addListSelectionListener(listener -> {
            int selectedRow;
            if (!listener.getValueIsAdjusting() && (selectedRow = this.tableMediaFiles.convertRowIndexToModel(this.tableMediaFiles.getSelectedRow())) > -1) {
                MediaFile mf = this.mediaFiles.get((int)selectedRow).mediaFile;
                this.tfCodec.setEnabled(mf.getType() != MediaFileType.NFO);
                this.btnAddAudioStream.setEnabled(videoTypes.contains((Object)mf.getType()));
                this.btnRemoveAudioStream.setEnabled(videoTypes.contains((Object)mf.getType()));
                this.btnAddSubtitle.setEnabled(videoTypes.contains((Object)mf.getType()));
                this.btnRemoveSubtitle.setEnabled(videoTypes.contains((Object)mf.getType()));
                this.cb3dFormat.setEnabled(videoTypes.contains((Object)mf.getType()));
                this.tfRuntime.setEnabled(videoTypes.contains((Object)mf.getType()));
                this.btnARD.setEnabled(videoTypes.contains((Object)mf.getType()) && FFmpeg.isAvailable());
            }
        });
    }

    private static Map<Float, String> getAspectRatios() {
        LinkedHashMap<Float, String> predefinedValues = new LinkedHashMap<Float, String>();
        predefinedValues.put(Float.valueOf(0.0f), TmmResourceBundle.getString("aspectratio.calculated"));
        predefinedValues.putAll(AspectRatio.getDefaultValues());
        return predefinedValues;
    }

    private static Map<Float, String> getAspectRatios2() {
        LinkedHashMap<Float, String> predefinedValues = new LinkedHashMap<Float, String>();
        predefinedValues.put(null, TmmResourceBundle.getString("aspectratio.nomultiformat"));
        predefinedValues.putAll(AspectRatio.getDefaultValues());
        return predefinedValues;
    }

    private int[] convertSelectedRowsToModelRows(JTable table) {
        int[] tableRows = table.getSelectedRows();
        int[] modelRows = new int[tableRows.length];
        for (int i = 0; i < tableRows.length; ++i) {
            modelRows[i] = table.convertRowIndexToModel(tableRows[i]);
        }
        ArrayUtils.reverse((int[])modelRows);
        return modelRows;
    }

    public static void syncMediaFiles(List<MediaFile> mfsFromEditor, List<MediaFile> mfsFromMediaEntity) {
        block0: for (MediaFile mfEditor : mfsFromEditor) {
            for (MediaFile mfOriginal : mfsFromMediaEntity) {
                if (!mfEditor.equals(mfOriginal)) continue;
                if (!mfEditor.getVideoCodec().equals(mfOriginal.getVideoCodec())) {
                    mfOriginal.setVideoCodec(mfEditor.getVideoCodec());
                }
                if (!mfEditor.getContainerFormat().equals(mfOriginal.getContainerFormat())) {
                    mfOriginal.setContainerFormat(mfEditor.getContainerFormat());
                }
                if (mfEditor.getVideoWidth() != mfOriginal.getVideoWidth()) {
                    mfOriginal.setVideoWidth(mfEditor.getVideoWidth());
                }
                if (mfEditor.getVideoHeight() != mfOriginal.getVideoHeight()) {
                    mfOriginal.setVideoHeight(mfEditor.getVideoHeight());
                }
                if (mfEditor.getAspectRatio() != mfOriginal.getAspectRatio()) {
                    mfOriginal.setAspectRatio(mfEditor.getAspectRatio());
                }
                if (mfEditor.getAspectRatio2() != mfOriginal.getAspectRatio2()) {
                    mfOriginal.setAspectRatio2(mfEditor.getAspectRatio2());
                }
                if (mfEditor.getFrameRate() != mfOriginal.getFrameRate()) {
                    mfOriginal.setFrameRate(mfEditor.getFrameRate());
                }
                if (!mfEditor.getVideo3DFormat().equals(mfOriginal.getVideo3DFormat())) {
                    mfOriginal.setVideo3DFormat(mfEditor.getVideo3DFormat());
                }
                if (!mfEditor.getHdrFormat().equals(mfOriginal.getHdrFormat())) {
                    mfOriginal.setHdrFormat(mfEditor.getHdrFormat());
                }
                if (mfEditor.getBitDepth() != mfOriginal.getBitDepth()) {
                    mfOriginal.setBitDepth(mfEditor.getBitDepth());
                }
                if (mfEditor.getOverallBitRate() != mfOriginal.getOverallBitRate()) {
                    mfOriginal.setOverallBitRate(mfEditor.getOverallBitRate());
                }
                if (mfEditor.getDuration() != mfOriginal.getDuration()) {
                    mfOriginal.setDuration(mfEditor.getDuration());
                }
                mfOriginal.setAudioStreams(mfEditor.getAudioStreams());
                mfOriginal.setSubtitles(mfEditor.getSubtitles());
                continue block0;
            }
        }
    }

    public void unbindBindings() {
        this.bindingGroup.unbind();
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.mediaFiles, (JTable)this.tableMediaFiles);
        BeanProperty mediaFileContainerBeanProperty = BeanProperty.create((String)"mediaFile.filename");
        jTableBinding.addColumnBinding((Property)mediaFileContainerBeanProperty).setColumnName("Filename").setEditable(false);
        jTableBinding.setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.mediaFile.filename");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty, (Object)this.lblFilename, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty jTableBeanProperty_1 = BeanProperty.create((String)"selectedElement.mediaFile.videoCodec");
        BeanProperty jTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_1, (Object)this.tfCodec, (Property)jTextFieldBeanProperty);
        autoBinding_1.bind();
        BeanProperty jTableBeanProperty_3 = BeanProperty.create((String)"selectedElement.mediaFile.containerFormat");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_3, (Object)this.tfContainerFormat, (Property)jTextFieldBeanProperty_2);
        autoBinding_3.bind();
        BeanProperty jTableBeanProperty_5 = BeanProperty.create((String)"selectedElement.mediaFile.videoWidth");
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_5, (Object)this.tfWidth, (Property)jTextFieldBeanProperty_4);
        autoBinding_5.bind();
        BeanProperty jTableBeanProperty_6 = BeanProperty.create((String)"selectedElement.mediaFile.videoHeight");
        BeanProperty jTextFieldBeanProperty_5 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_6, (Object)this.tfHeight, (Property)jTextFieldBeanProperty_5);
        autoBinding_6.bind();
        BeanProperty jTableBeanProperty_2 = BeanProperty.create((String)"selectedElement.audioStreams");
        JTableBinding jTableBinding_1 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_2, (JTable)this.tableAudioStreams);
        BeanProperty mediaFileAudioStreamBeanProperty = BeanProperty.create((String)"language");
        jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty).setColumnName("Language").setColumnClass(String.class);
        BeanProperty mediaFileAudioStreamBeanProperty_1 = BeanProperty.create((String)"codec");
        jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty_1).setColumnName("Codec");
        BeanProperty mediaFileAudioStreamBeanProperty_2 = BeanProperty.create((String)"audioChannels");
        jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty_2).setColumnName("Channels");
        BeanProperty mediaFileAudioStreamBeanProperty_3 = BeanProperty.create((String)"bitrate");
        jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty_3).setColumnName("Bitrate").setColumnClass(Integer.class);
        BeanProperty mediaFileAudioStreamBeanProperty_4 = BeanProperty.create((String)"audioTitle");
        jTableBinding_1.addColumnBinding((Property)mediaFileAudioStreamBeanProperty_4).setColumnName("Audio Title").setColumnClass(String.class);
        jTableBinding_1.bind();
        BeanProperty jTableBeanProperty_4 = BeanProperty.create((String)"selectedElement.subtitles");
        JTableBinding jTableBinding_2 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_4, (JTable)this.tableSubtitles);
        BeanProperty mediaFileSubtitleBeanProperty = BeanProperty.create((String)"language");
        jTableBinding_2.addColumnBinding((Property)mediaFileSubtitleBeanProperty).setColumnName("Language").setColumnClass(String.class);
        BeanProperty mediaFileSubtitleBeanProperty_1 = BeanProperty.create((String)"forced");
        jTableBinding_2.addColumnBinding((Property)mediaFileSubtitleBeanProperty_1).setColumnName("Forced").setColumnClass(Boolean.class);
        BeanProperty mediaFileSubtitleBeanProperty_2 = BeanProperty.create((String)"sdh");
        jTableBinding_2.addColumnBinding((Property)mediaFileSubtitleBeanProperty_2).setColumnName("Hearing Impaired").setColumnClass(Boolean.class);
        BeanProperty mediaFileSubtitleBeanProperty_3 = BeanProperty.create((String)"title");
        jTableBinding_2.addColumnBinding((Property)mediaFileSubtitleBeanProperty_3).setColumnName("Title").setColumnClass(String.class);
        jTableBinding_2.bind();
        BeanProperty jTableBeanProperty_7 = BeanProperty.create((String)"selectedElement.mediaFile.video3DFormat");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)jTableBeanProperty_7, this.cb3dFormat, (Property)jComboBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty tmmTableBeanProperty = BeanProperty.create((String)"selectedElement.mediaFile.aspectRatio");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty, (Object)this.cbAspectRatio, (Property)jComboBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty tmmTableBeanProperty_6 = BeanProperty.create((String)"selectedElement.mediaFile.aspectRatio2");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_6, (Object)this.cbAspectRatio2, (Property)jComboBoxBeanProperty);
        autoBinding_12.bind();
        BeanProperty tmmTableBeanProperty_1 = BeanProperty.create((String)"selectedElement.mediaFile.frameRate");
        BeanProperty jFormattedTextFieldBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_1, (Object)this.tfFrameRate, (Property)jFormattedTextFieldBeanProperty);
        autoBinding_7.bind();
        BeanProperty tmmTableBeanProperty_2 = BeanProperty.create((String)"selectedElement.mediaFile.bitDepth");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_2, (Object)this.tfBitDepth, (Property)jTextFieldBeanProperty_1);
        autoBinding_8.bind();
        BeanProperty tmmTableBeanProperty_3 = BeanProperty.create((String)"selectedElement.mediaFile.overallBitRate");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_3, (Object)this.tfVideoBitrate, (Property)jTextFieldBeanProperty_3);
        autoBinding_9.bind();
        BeanProperty tmmTableBeanProperty_4 = BeanProperty.create((String)"selectedElement.mediaFile.hdrFormat");
        BeanProperty jTextFieldBeanProperty_6 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_4, (Object)this.tfHdrFormat, (Property)jTextFieldBeanProperty_6);
        autoBinding_10.bind();
        BeanProperty tmmTableBeanProperty_5 = BeanProperty.create((String)"selectedElement.mediaFile.durationInMinutes");
        BeanProperty jTextFieldBeanProperty_7 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tableMediaFiles, (Property)tmmTableBeanProperty_5, (Object)this.tfRuntime, (Property)jTextFieldBeanProperty_7);
        autoBinding_11.bind();
        this.bindingGroup.addBinding((Binding)jTableBinding);
        this.bindingGroup.addBinding((Binding)jTableBinding_1);
        this.bindingGroup.addBinding((Binding)jTableBinding_2);
    }

    public void cancelTask() {
        if (this.ardTask != null) {
            this.ardTask.cancel();
            this.ardTask = null;
        }
    }

    public static class MediaFileContainer {
        private final MediaFile mediaFile;
        private final List<MediaFileAudioStream> audioStreams;
        private final List<MediaFileSubtitle> subtitles;

        private MediaFileContainer(MediaFile mediaFile) {
            this.mediaFile = mediaFile;
            this.audioStreams = ObservableCollections.observableList(new ArrayList<MediaFileAudioStream>(mediaFile.getAudioStreams()));
            this.subtitles = ObservableCollections.observableList(new ArrayList<MediaFileSubtitle>(mediaFile.getSubtitles()));
        }

        public MediaFile getMediaFile() {
            return this.mediaFile;
        }

        public List<MediaFileAudioStream> getAudioStreams() {
            return this.audioStreams;
        }

        public List<MediaFileSubtitle> getSubtitles() {
            return this.subtitles;
        }

        public void addAudioStream() {
            this.audioStreams.add(new MediaFileAudioStream());
            this.mediaFile.setAudioStreams(this.audioStreams);
        }

        public void removeAudioStream(int index) {
            this.audioStreams.remove(index);
            this.mediaFile.setAudioStreams(this.audioStreams);
        }

        public void addSubtitle() {
            this.subtitles.add(new MediaFileSubtitle());
            this.mediaFile.setSubtitles(this.subtitles);
        }

        public void removeSubtitle(int index) {
            this.subtitles.remove(index);
            this.mediaFile.setSubtitles(this.subtitles);
        }
    }

    private class ScanAspectRationAction
    extends AbstractAction
    implements TmmTaskListener {
        private static final long serialVersionUID = 8777310652284455423L;

        public ScanAspectRationAction() {
            this.putValue("Name", TmmResourceBundle.getString("task.ard"));
            this.putValue("SmallIcon", IconManager.ASPECT_RATIO);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow();
            if (mediaFileRow > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                MediaFileARDetectorTask task = new MediaFileARDetectorTask(mf.getMediaFile());
                task.addListener(this);
                TmmTaskManager.getInstance().addUnnamedTask(task);
                MediaFileEditorPanel.this.ardTask = task;
            }
        }

        @Override
        public void processTaskEvent(TmmTaskHandle task) {
            if (TmmTaskHandle.TaskState.QUEUED.equals((Object)task.getState())) {
                MediaFileEditorPanel.this.btnARD.setEnabled(false);
            } else if (TmmTaskHandle.TaskState.FINISHED.equals((Object)task.getState())) {
                MediaFileEditorPanel.this.btnARD.setEnabled(true);
            }
        }
    }

    private class RemoveSubtitleAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079866940827356996L;

        public RemoveSubtitleAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("subtitle.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow;
            int[] subtitleRows = MediaFileEditorPanel.this.convertSelectedRowsToModelRows(MediaFileEditorPanel.this.tableSubtitles);
            if (subtitleRows.length > 0 && (mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow()) > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                for (int row : subtitleRows) {
                    mf.removeSubtitle(row);
                }
            }
        }
    }

    private class AddSubtitleAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414523349767L;

        public AddSubtitleAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("subtitle.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow();
            if (mediaFileRow > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                mf.addSubtitle();
            }
        }
    }

    private class RemoveAudioStreamAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826940827356996L;

        public RemoveAudioStreamAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("audiostream.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow;
            int[] audioRows = MediaFileEditorPanel.this.convertSelectedRowsToModelRows(MediaFileEditorPanel.this.tableAudioStreams);
            if (audioRows.length > 0 && (mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow()) > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                for (int row : audioRows) {
                    mf.removeAudioStream(row);
                }
            }
        }
    }

    private class AddAudioStreamAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414523349267L;

        public AddAudioStreamAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("audiostream.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.getSelectedRow();
            if (mediaFileRow > -1) {
                mediaFileRow = MediaFileEditorPanel.this.tableMediaFiles.convertRowIndexToModel(mediaFileRow);
                MediaFileContainer mf = MediaFileEditorPanel.this.mediaFiles.get(mediaFileRow);
                mf.addAudioStream();
            }
        }
    }
}

