/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.renderer;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class MultilineTableCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border DEFAULT_NO_FOCUS_BORDER;
    protected static Border noFocusBorder;

    public MultilineTableCellRenderer() {
        this(false);
    }

    public MultilineTableCellRenderer(boolean withWordWrap) {
        this.setForeground(null);
        this.setBackground(null);
        this.setOpaque(false);
        this.setBorder(this.getNoFocusBorder());
        this.setAlignmentY(0.5f);
        if (withWordWrap) {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }
    }

    private Border getNoFocusBorder() {
        Border border = UIManager.getBorder("Table.cellNoFocusBorder");
        if (System.getSecurityManager() != null) {
            if (border != null) {
                return border;
            }
            return SAFE_NO_FOCUS_BORDER;
        }
        if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
            return border;
        }
        return noFocusBorder;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(new EmptyBorder(1, 2, 1, 2));
        }
        this.setText(value == null ? "" : value.toString());
        return this;
    }

    static {
        noFocusBorder = DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    }
}

