/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.renderer;

import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class RuntimeTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 2136302874452711571L;
    private final FORMAT format;

    public RuntimeTableCellRenderer(FORMAT format) {
        this.format = format;
        this.setHorizontalAlignment(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
        if (value instanceof Integer) {
            int runtime = (Integer)value;
            long h = TimeUnit.MINUTES.toHours(runtime);
            long m = TimeUnit.MINUTES.toMinutes((long)runtime - TimeUnit.HOURS.toMinutes(h));
            if (this.format == FORMAT.MINUTES) {
                this.setText(value.toString());
            } else if (this.format == FORMAT.HOURS_MINUTES) {
                this.setText(String.format("%2d:%02d", h, m));
            }
        } else {
            this.setText("");
        }
        return this;
    }

    public static enum FORMAT {
        MINUTES,
        HOURS_MINUTES;

    }
}

