/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.DateField;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.DocsButton;
import org.tinymediamanager.ui.components.LinkTextArea;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;

class UiSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 6409982195347794360L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UiSettingsPanel.class);
    private static final Integer[] DEFAULT_FONT_SIZES = new Integer[]{12, 14, 16, 18, 20, 22, 24, 26, 28};
    private final Settings settings = Settings.getInstance();
    private final List<LocaleComboBox> locales = new ArrayList<LocaleComboBox>();
    private JComboBox cbLanguage;
    private LinkTextArea lblLinkTranslate;
    private JComboBox cbFontSize;
    private JComboBox cbFontFamily;
    private JLabel lblLanguageChangeHint;
    private JCheckBox chckbxStoreWindowPreferences;
    private JComboBox cbTheme;
    private JLabel lblThemeHint;
    private JCheckBox chckbxShowMemory;
    private JComboBox cbDatefield;
    private JCheckBox chckbxImageChooserLastFolder;
    private JCheckBox chckbxImageChooserEntityFolder;

    UiSettingsPanel() {
        LocaleComboBox actualLocale = null;
        Locale settingsLang = Utils.getLocaleFromLanguage(Settings.getInstance().getLanguage());
        for (Locale l : Utils.getLanguages()) {
            LocaleComboBox localeComboBox = new LocaleComboBox(l);
            this.locales.add(localeComboBox);
            if (!l.equals(settingsLang)) continue;
            actualLocale = localeComboBox;
        }
        Collections.sort(this.locales);
        this.initComponents();
        this.initDataBindings();
        if (actualLocale != null) {
            this.cbLanguage.setSelectedItem(actualLocale);
        }
        this.cbFontFamily.setSelectedItem(Settings.getInstance().getFontFamily());
        int index = this.cbFontFamily.getSelectedIndex();
        if (index < 0) {
            this.cbFontFamily.setSelectedItem("Dialog");
            index = this.cbFontFamily.getSelectedIndex();
        }
        if (index < 0) {
            this.cbFontFamily.setSelectedIndex(0);
        }
        this.cbFontSize.setSelectedItem(Settings.getInstance().getFontSize());
        index = this.cbFontSize.getSelectedIndex();
        if (index < 0) {
            this.cbFontSize.setSelectedIndex(0);
        }
        this.cbTheme.setSelectedItem(Settings.getInstance().getTheme());
        index = this.cbTheme.getSelectedIndex();
        if (index < 0) {
            this.cbTheme.setSelectedIndex(0);
        }
        this.lblLinkTranslate.addActionListener(arg0 -> {
            try {
                TmmUIHelper.browseUrl(this.lblLinkTranslate.getText());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.lblLinkTranslate.getText(), "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        ActionListener actionListener = e -> SwingUtilities.invokeLater(this::checkChanges);
        this.cbLanguage.addActionListener(actionListener);
        this.cbFontFamily.addActionListener(actionListener);
        this.cbFontSize.addActionListener(actionListener);
        this.cbTheme.addActionListener(actionListener);
        Settings.getInstance().addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "theme": {
                    if (Settings.getInstance().getTheme().equals(this.cbTheme.getSelectedItem())) break;
                    this.cbTheme.setSelectedItem(Settings.getInstance().getTheme());
                    break;
                }
                case "fontSize": {
                    if (this.cbFontSize.getSelectedItem() == null || Settings.getInstance().getFontSize() == ((Integer)this.cbFontSize.getSelectedItem()).intValue()) break;
                    this.cbFontSize.setSelectedItem(Settings.getInstance().getFontSize());
                    break;
                }
                case "fontFamily": {
                    if (Settings.getInstance().getFontFamily().equals(this.cbFontFamily.getSelectedItem())) break;
                    this.cbFontFamily.setSelectedItem(Settings.getInstance().getFontFamily());
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.chckbxImageChooserLastFolder);
        buttonGroup.add(this.chckbxImageChooserEntityFolder);
        if (this.settings.isImageChooserUseEntityFolder()) {
            this.chckbxImageChooserEntityFolder.setSelected(true);
        }
        this.chckbxImageChooserLastFolder.addActionListener(actionListener);
        this.chckbxImageChooserEntityFolder.addActionListener(actionListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 1", "[600lp,grow]", "[][15lp!][][15lp!][][15lp!][]"));
        JPanel panelLanguage = new JPanel();
        panelLanguage.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", ""));
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("Settings.language"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelLanguage, lblLanguageT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#ui-language"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.cbLanguage = new JComboBox<Object>(this.locales.toArray());
        panelLanguage.add((Component)this.cbLanguage, "cell 1 0 2 1");
        JLabel lblLanguageHint = new JLabel(TmmResourceBundle.getString("tmm.helptranslate"));
        panelLanguage.add((Component)lblLanguageHint, "cell 1 1 2 1");
        this.lblLinkTranslate = new LinkTextArea("https://www.reddit.com/r/tinyMediaManager/comments/kt2iyq/basic_information/");
        panelLanguage.add((Component)this.lblLinkTranslate, "cell 1 2 2 1, grow, wmin 0");
        this.lblLanguageChangeHint = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblLanguageChangeHint, 1);
        panelLanguage.add((Component)this.lblLanguageChangeHint, "cell 0 3 3 1");
        JPanel panelTheme = new JPanel();
        panelTheme.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", ""));
        TmmLabel lblThemeT = new TmmLabel(TmmResourceBundle.getString("Settings.uitheme"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelTheme, lblThemeT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#ui-theme"));
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        this.cbTheme = new JComboBox<String>(new String[]{"Light", "Dark"});
        panelTheme.add((Component)this.cbTheme, "cell 1 0 2 1");
        this.lblThemeHint = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblThemeHint, 1);
        panelTheme.add((Component)this.lblThemeHint, "cell 0 1 3 1");
        JPanel panelFont = new JPanel();
        panelFont.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][][grow]", "[][][]"));
        TmmLabel lblFontT = new TmmLabel(TmmResourceBundle.getString("Settings.font"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelFont, lblFontT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#font"));
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        JLabel lblFontFamilyT = new JLabel(TmmResourceBundle.getString("Settings.fontfamily"));
        panelFont.add((Component)lblFontFamilyT, "cell 1 0");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.cbFontFamily = new JComboBox<String>(env.getAvailableFontFamilyNames());
        panelFont.add((Component)this.cbFontFamily, "cell 2 0");
        JLabel lblFontSizeT = new JLabel(TmmResourceBundle.getString("Settings.fontsize"));
        panelFont.add((Component)lblFontSizeT, "cell 1 1");
        this.cbFontSize = new JComboBox<Integer>(DEFAULT_FONT_SIZES);
        panelFont.add((Component)this.cbFontSize, "cell 2 1");
        ReadOnlyTextArea tpFontHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.fonts.hint"));
        panelFont.add((Component)tpFontHint, "cell 1 2 2 1,growx");
        JPanel panelMisc = new JPanel();
        panelMisc.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][10lp!][][][][10lp!][][]"));
        TmmLabel lblMiscT = new TmmLabel(TmmResourceBundle.getString("Settings.misc"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/settings#misc-settings"));
        this.add((Component)collapsiblePanel, "cell 0 6,growx,wmin 0");
        JLabel lblDatefield = new JLabel(TmmResourceBundle.getString("Settings.datefield"));
        panelMisc.add((Component)lblDatefield, "cell 1 0 2 1");
        this.cbDatefield = new JComboBox<Object>(ArrayUtils.removeElement((Object[])DateField.values(), (Object)((Object)DateField.RELEASE_DATE)));
        panelMisc.add((Component)this.cbDatefield, "cell 1 0");
        JLabel lblDatefieldHint = new JLabel(TmmResourceBundle.getString("Settings.datefield.desc"));
        panelMisc.add((Component)lblDatefieldHint, "cell 2 1");
        JLabel lblImageChooserDefaultFolderT = new JLabel(TmmResourceBundle.getString("Settings.imagechooser.folder"));
        panelMisc.add((Component)lblImageChooserDefaultFolderT, "cell 1 3 2 1");
        this.chckbxImageChooserLastFolder = new JCheckBox(TmmResourceBundle.getString("Settings.imagechooser.last"));
        panelMisc.add((Component)this.chckbxImageChooserLastFolder, "cell 2 4");
        this.chckbxImageChooserEntityFolder = new JCheckBox(TmmResourceBundle.getString("Settings.imagechooser.entity"));
        panelMisc.add((Component)this.chckbxImageChooserEntityFolder, "cell 2 5");
        this.chckbxStoreWindowPreferences = new JCheckBox(TmmResourceBundle.getString("Settings.storewindowpreferences"));
        panelMisc.add((Component)this.chckbxStoreWindowPreferences, "cell 1 7 2 1");
        this.chckbxShowMemory = new JCheckBox(TmmResourceBundle.getString("Settings.showmemory"));
        panelMisc.add((Component)this.chckbxShowMemory, "cell 1 8 2 1");
    }

    private void checkChanges() {
        Locale actualLocale;
        Locale locale;
        LocaleComboBox loc = (LocaleComboBox)this.cbLanguage.getSelectedItem();
        if (loc != null && !(locale = loc.loc).equals(actualLocale = Utils.getLocaleFromLanguage(Settings.getInstance().getLanguage()))) {
            Settings.getInstance().setLanguage(locale.toString());
            this.lblLanguageChangeHint.setText(TmmResourceBundle.getString("Settings.languagehint"));
        }
        String theme = (String)this.cbTheme.getSelectedItem();
        if (!Settings.getInstance().getTheme().equals(theme)) {
            Settings.getInstance().setTheme(theme);
            try {
                TmmUIHelper.setTheme();
                TmmUIHelper.updateUI();
            }
            catch (Exception e) {
                this.lblThemeHint.setText(TmmResourceBundle.getString("Settings.uitheme.hint"));
            }
        }
        String fontFamily = (String)this.cbFontFamily.getSelectedItem();
        Integer fontSize = (Integer)this.cbFontSize.getSelectedItem();
        if (fontFamily != null && !fontFamily.equals(Settings.getInstance().getFontFamily()) || fontSize != null && fontSize.intValue() != Settings.getInstance().getFontSize()) {
            Settings.getInstance().setFontFamily(fontFamily);
            Settings.getInstance().setFontSize(fontSize);
            Font font = UIManager.getFont("defaultFont");
            Font newFont = new Font(fontFamily, font.getStyle(), fontSize);
            UIManager.put("defaultFont", newFont);
            TmmUIHelper.updateUI();
        }
        this.settings.setImageChooserUseEntityFolder(this.chckbxImageChooserEntityFolder.isSelected());
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"storeWindowPreferences");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxStoreWindowPreferences, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"showMemory");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxShowMemory, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"dateField");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.cbDatefield, (Property)jComboBoxBeanProperty);
        autoBinding_2.bind();
    }

    private static class LocaleComboBox
    implements Comparable<LocaleComboBox> {
        private final Locale loc;
        private final List<Locale> countries;

        LocaleComboBox(Locale loc) {
            this.loc = loc;
            this.countries = LocaleUtils.countriesByLanguage((String)loc.getLanguage().toLowerCase(Locale.ROOT));
        }

        public Locale getLocale() {
            return this.loc;
        }

        public String toString() {
            if (this.loc.getLanguage().equalsIgnoreCase(this.loc.getCountry())) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (this.loc.toString().equals("en_US")) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (this.countries.size() == 1) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (StringUtils.isNotBlank((CharSequence)this.loc.getDisplayCountry(this.loc))) {
                return this.loc.getDisplayLanguage(this.loc) + " (" + this.loc.getDisplayCountry(this.loc) + ")";
            }
            return this.loc.getDisplayLanguage(this.loc);
        }

        @Override
        public int compareTo(LocaleComboBox o) {
            return this.toString().toLowerCase(Locale.ROOT).compareTo(o.toString().toLowerCase(Locale.ROOT));
        }
    }
}

