/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.thirdparty;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.thirdparty.SplitUri;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.movies.actions.MovieKodiGetWatchedAction;
import org.tinymediamanager.ui.movies.actions.MovieKodiRefreshNfoAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetKodiGetWatchedMovieAction;
import org.tinymediamanager.ui.moviesets.actions.MovieSetKodiRefreshMovieNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowKodiGetWatchedAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowKodiRefreshNfoAction;

public class KodiRPCMenu {
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");

    private KodiRPCMenu() {
        throw new IllegalAccessError();
    }

    public static JMenu createMenuKodiMenuRightClickMovies() {
        String version = KodiRPC.getInstance().getVersion();
        final JMenu m = new JMenu(version);
        m.setIcon(IconManager.KODI);
        m.add(new MovieKodiRefreshNfoAction());
        m.add(new MovieKodiGetWatchedAction());
        m.addSeparator();
        final JMenuItem connectMenuItem = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.connect"), IconManager.CONNECT);
        connectMenuItem.addActionListener(e -> KodiRPC.getInstance().connect());
        m.add(connectMenuItem);
        JMenuItem disconnectMenuItem = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.disconnect"), IconManager.DISCONNECT);
        disconnectMenuItem.addActionListener(e -> KodiRPC.getInstance().disconnect());
        m.add(disconnectMenuItem);
        m.addSeparator();
        JMenuItem i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.updatemappings"), IconManager.SYNC);
        i.addActionListener(e -> KodiRPC.getInstance().updateMovieMappings());
        m.add(i);
        m.addSeparator();
        m.add(KodiRPCMenu.createMenuApplication());
        m.add(KodiRPCMenu.createMenuSystem());
        m.add(KodiRPCMenu.createMenuVideoDatasources());
        m.add(KodiRPCMenu.createMenuAudioDatasources());
        m.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean connected = KodiRPC.getInstance().isConnected();
                for (Component component : m.getMenuComponents()) {
                    if (component instanceof JSeparator) continue;
                    if (connected) {
                        if (component == connectMenuItem) {
                            component.setEnabled(false);
                            continue;
                        }
                        component.setEnabled(true);
                        continue;
                    }
                    if (component == connectMenuItem) {
                        component.setEnabled(true);
                        continue;
                    }
                    component.setEnabled(false);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return m;
    }

    public static JMenu createMenuKodiMenuRightClickMovieSets() {
        String version = KodiRPC.getInstance().getVersion();
        final JMenu m = new JMenu(version);
        m.setIcon(IconManager.KODI);
        m.add(new MovieSetKodiRefreshMovieNfoAction());
        m.add(new MovieSetKodiGetWatchedMovieAction());
        m.addSeparator();
        final JMenuItem connectMenuItem = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.connect"), IconManager.CONNECT);
        connectMenuItem.addActionListener(e -> KodiRPC.getInstance().connect());
        m.add(connectMenuItem);
        JMenuItem disconnectMenuItem = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.disconnect"), IconManager.DISCONNECT);
        disconnectMenuItem.addActionListener(e -> KodiRPC.getInstance().disconnect());
        m.add(disconnectMenuItem);
        m.addSeparator();
        JMenuItem i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.updatemappings"), IconManager.SYNC);
        i.addActionListener(e -> KodiRPC.getInstance().updateMovieMappings());
        m.add(i);
        m.addSeparator();
        m.add(KodiRPCMenu.createMenuApplication());
        m.add(KodiRPCMenu.createMenuSystem());
        m.add(KodiRPCMenu.createMenuVideoDatasources());
        m.add(KodiRPCMenu.createMenuAudioDatasources());
        m.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                for (Component component : m.getMenuComponents()) {
                    if (component instanceof JSeparator) continue;
                    if (KodiRPC.getInstance().isConnected()) {
                        if (component == connectMenuItem) {
                            component.setEnabled(false);
                            continue;
                        }
                        component.setEnabled(true);
                        continue;
                    }
                    if (component == connectMenuItem) {
                        component.setEnabled(true);
                        continue;
                    }
                    component.setEnabled(false);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return m;
    }

    public static JMenu createMenuKodiMenuRightClickTvShows() {
        String version = KodiRPC.getInstance().getVersion();
        final JMenu m = new JMenu(version);
        m.setIcon(IconManager.KODI);
        m.add(new TvShowKodiRefreshNfoAction());
        m.add(new TvShowKodiGetWatchedAction());
        m.addSeparator();
        final JMenuItem connectMenuItem = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.connect"), IconManager.CONNECT);
        connectMenuItem.addActionListener(e -> KodiRPC.getInstance().connect());
        m.add(connectMenuItem);
        JMenuItem disconnectMenuItem = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.disconnect"), IconManager.DISCONNECT);
        disconnectMenuItem.addActionListener(e -> KodiRPC.getInstance().disconnect());
        m.add(disconnectMenuItem);
        m.addSeparator();
        JMenuItem i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.updatemappings"), IconManager.SYNC);
        i.addActionListener(e -> KodiRPC.getInstance().updateTvShowMappings());
        m.add(i);
        m.addSeparator();
        m.add(KodiRPCMenu.createMenuApplication());
        m.add(KodiRPCMenu.createMenuSystem());
        m.add(KodiRPCMenu.createMenuVideoDatasources());
        m.add(KodiRPCMenu.createMenuAudioDatasources());
        m.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean connected = KodiRPC.getInstance().isConnected();
                for (Component component : m.getMenuComponents()) {
                    if (component instanceof JSeparator) continue;
                    if (connected) {
                        if (component == connectMenuItem) {
                            component.setEnabled(false);
                            continue;
                        }
                        component.setEnabled(true);
                        continue;
                    }
                    if (component == connectMenuItem) {
                        component.setEnabled(true);
                        continue;
                    }
                    component.setEnabled(false);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return m;
    }

    public static JMenu createKodiMenuTop() {
        String version = KodiRPC.getInstance().getVersion();
        final JMenu m = new JMenu(version);
        m.setIcon(IconManager.KODI);
        final JMenuItem connectMenuItem = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.connect"), IconManager.CONNECT);
        connectMenuItem.addActionListener(e -> KodiRPC.getInstance().connect());
        m.add(connectMenuItem);
        JMenuItem disconnectMenuItem = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.disconnect"), IconManager.DISCONNECT);
        disconnectMenuItem.addActionListener(e -> KodiRPC.getInstance().disconnect());
        m.add(disconnectMenuItem);
        m.addSeparator();
        JMenuItem i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.updatemappings"), IconManager.SYNC);
        i.addActionListener(e -> {
            KodiRPC.getInstance().updateMovieMappings();
            KodiRPC.getInstance().updateTvShowMappings();
        });
        m.add(i);
        m.addSeparator();
        m.add(KodiRPCMenu.createMenuApplication());
        m.add(KodiRPCMenu.createMenuSystem());
        m.add(KodiRPCMenu.createMenuVideoDatasources());
        m.add(KodiRPCMenu.createMenuAudioDatasources());
        m.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean connected = KodiRPC.getInstance().isConnected();
                for (Component component : m.getMenuComponents()) {
                    if (component instanceof JSeparator) continue;
                    if (connected) {
                        if (component == connectMenuItem) {
                            component.setEnabled(false);
                            continue;
                        }
                        component.setEnabled(true);
                        continue;
                    }
                    if (component == connectMenuItem) {
                        component.setEnabled(true);
                        continue;
                    }
                    component.setEnabled(false);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return m;
    }

    private static JMenu createMenuApplication() {
        JMenu m = new JMenu(TmmResourceBundle.getString("kodi.rpc.application"));
        m.setIcon(IconManager.MENU);
        JMenuItem i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.quit"));
        i.addActionListener(e -> KodiRPC.getInstance().quitApplication());
        m.add(i);
        i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.mute"));
        i.addActionListener(e -> KodiRPC.getInstance().muteApplication());
        m.add(i);
        m.add(KodiRPCMenu.createMenuVolume());
        return m;
    }

    private static JMenu createMenuVideoDatasources() {
        JMenu m = new JMenu(TmmResourceBundle.getString("kodi.rpc.videolibrary"));
        m.setIcon(IconManager.MOVIE);
        JMenuItem cleanLibraryMenuItem = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.cleanvideo"), IconManager.CLEAN);
        cleanLibraryMenuItem.setToolTipText(TmmResourceBundle.getString("kodi.rpc.cleanvideo.desc"));
        cleanLibraryMenuItem.addActionListener(event -> KodiRPC.getInstance().cleanVideoLibrary());
        m.add(cleanLibraryMenuItem);
        m.addSeparator();
        JMenuItem i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.scan.all"), IconManager.REFRESH);
        i.addActionListener(event -> KodiRPC.getInstance().scanVideoLibrary());
        i.setEnabled(false);
        m.add(i);
        if (!KodiRPC.getInstance().getVideoDataSources().isEmpty()) {
            i.setEnabled(true);
            for (SplitUri ds : KodiRPC.getInstance().getVideoDataSources()) {
                i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.scan.item") + " " + ds.label + "  (" + ds.type + ")", IconManager.REFRESH);
                if ("UPNP".equals(ds.type)) continue;
                i.addActionListener(event -> KodiRPC.getInstance().scanVideoLibrary(ds.file));
                m.add(i);
            }
        }
        return m;
    }

    private static JMenu createMenuAudioDatasources() {
        JMenu m = new JMenu(TmmResourceBundle.getString("kodi.rpc.audiolibrary"));
        m.setIcon(IconManager.MUSIC);
        JMenuItem cleanLibraryMenuItem = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.cleanaudio"), IconManager.CLEAN);
        cleanLibraryMenuItem.setToolTipText(TmmResourceBundle.getString("kodi.rpc.cleanaudio.desc"));
        cleanLibraryMenuItem.addActionListener(event -> KodiRPC.getInstance().cleanAudioLibrary());
        m.add(cleanLibraryMenuItem);
        m.addSeparator();
        JMenuItem i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.scan.all"), IconManager.REFRESH);
        i.addActionListener(event -> KodiRPC.getInstance().scanAudioLibrary());
        i.setEnabled(false);
        m.add(i);
        if (!KodiRPC.getInstance().getAudioDataSources().isEmpty()) {
            i.setEnabled(true);
            for (SplitUri ds : KodiRPC.getInstance().getAudioDataSources()) {
                i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.scan.item") + " " + ds.label + "  (" + ds.type + ")", IconManager.REFRESH);
                if ("UPNP".equals(ds.type)) continue;
                i.addActionListener(event -> KodiRPC.getInstance().scanAudioLibrary(ds.file));
                m.add(i);
            }
        }
        return m;
    }

    private static JMenu createMenuVolume() {
        JMenu m = new JMenu(TmmResourceBundle.getString("kodi.rpc.volume"));
        m.setIcon(IconManager.VOLUME);
        JMenuItem i = new JMenuItem("100%");
        i.addActionListener(new ApplicationVolumeListener(100));
        m.add(i);
        i = new JMenuItem(" 90%");
        i.addActionListener(new ApplicationVolumeListener(90));
        m.add(i);
        i = new JMenuItem(" 80%");
        i.addActionListener(new ApplicationVolumeListener(80));
        m.add(i);
        i = new JMenuItem(" 70%");
        i.addActionListener(new ApplicationVolumeListener(70));
        m.add(i);
        i = new JMenuItem(" 60%");
        i.addActionListener(new ApplicationVolumeListener(60));
        m.add(i);
        i = new JMenuItem(" 50%");
        i.addActionListener(new ApplicationVolumeListener(50));
        m.add(i);
        i = new JMenuItem(" 40%");
        i.addActionListener(new ApplicationVolumeListener(40));
        m.add(i);
        i = new JMenuItem(" 30%");
        i.addActionListener(new ApplicationVolumeListener(30));
        m.add(i);
        i = new JMenuItem(" 20%");
        i.addActionListener(new ApplicationVolumeListener(20));
        m.add(i);
        i = new JMenuItem(" 10%");
        i.addActionListener(new ApplicationVolumeListener(10));
        m.add(i);
        return m;
    }

    private static JMenu createMenuSystem() {
        JMenu m = new JMenu(TmmResourceBundle.getString("kodi.rpc.system"));
        m.setIcon(IconManager.MENU);
        JMenuItem i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.hibernate"));
        i.addActionListener(e -> KodiRPC.getInstance().SystemHibernate());
        m.add(i);
        i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.reboot"));
        i.addActionListener(e -> KodiRPC.getInstance().SystemReboot());
        m.add(i);
        i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.shutdown"));
        i.addActionListener(e -> KodiRPC.getInstance().SystemShutdown());
        m.add(i);
        i = new JMenuItem(TmmResourceBundle.getString("kodi.rpc.suspend"));
        i.addActionListener(e -> KodiRPC.getInstance().SystemSuspend());
        m.add(i);
        return m;
    }

    private static class ApplicationVolumeListener
    implements ActionListener {
        private final int vol;

        public ApplicationVolumeListener(int vol) {
            this.vol = vol;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KodiRPC.getInstance().setVolume(this.vol);
        }
    }
}

