/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.Date;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.MediaMetadata;

public class TvShowEpisodeChooserModel
extends AbstractModelObject {
    public static final TvShowEpisodeChooserModel emptyResult = new TvShowEpisodeChooserModel();
    private MediaMetadata mediaMetadata;
    private String originalTitle;
    private String title;
    private String overview;
    private Date firstAired;
    private int season;
    private int episode;

    public TvShowEpisodeChooserModel(MediaMetadata episode) {
        this.mediaMetadata = episode;
        this.setTitle(episode.getTitle());
        this.setOverview(this.mediaMetadata.getPlot());
        this.setSeason(this.mediaMetadata.getSeasonNumber());
        this.setEpisode(this.mediaMetadata.getEpisodeNumber());
        this.setFirstAired(this.mediaMetadata.getReleaseDate());
    }

    private TvShowEpisodeChooserModel() {
        this.setTitle(TmmResourceBundle.getString("chooser.nothingfound"));
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        this.firePropertyChange("title", oldValue, title);
    }

    public void setOverview(String overview) {
        String oldValue = this.overview;
        this.overview = overview;
        this.firePropertyChange("overview", oldValue, overview);
    }

    public void setSeason(int season) {
        int oldValue = this.season;
        this.season = season;
        this.firePropertyChange("season", oldValue, season);
    }

    public void setEpisode(int episode) {
        int oldValue = this.episode;
        this.episode = episode;
        this.firePropertyChange("episode", oldValue, episode);
    }

    public void setFirstAired(Date firstAired) {
        Date oldValue = this.firstAired;
        this.firstAired = firstAired;
        this.firePropertyChange("firstAired", oldValue, firstAired);
    }

    public String getTitle() {
        return this.title;
    }

    public String getOverview() {
        return this.overview;
    }

    public int getSeason() {
        return this.season;
    }

    public int getEpisode() {
        return this.episode;
    }

    public Date getFirstAired() {
        return this.firstAired;
    }

    public String getFirstAiredFormatted() {
        if (this.firstAired == null) {
            return "";
        }
        try {
            return TmmDateFormat.MEDIUM_DATE_FORMAT.format(this.firstAired);
        }
        catch (Exception e) {
            return "";
        }
    }

    public MediaMetadata getMediaMetadata() {
        return this.mediaMetadata;
    }
}

