/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableFormat;
import org.tinymediamanager.ui.renderer.DateTableCellRenderer;
import org.tinymediamanager.ui.renderer.RightAlignTableCellRenderer;

public class TvShowTableFormat
extends TmmTreeTableFormat<TmmTreeNode> {
    private final TvShowList tvShowList;
    private final TvShowSettings settings;
    private final Calendar calendar = Calendar.getInstance();

    public TvShowTableFormat() {
        Date date2;
        this.tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        this.settings = TvShowModuleManager.getInstance().getSettings();
        FontMetrics fontMetrics = this.getFontMetrics();
        TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
        Comparator integerComparator = (o1, o2) -> {
            int value1 = 0;
            int value2 = 0;
            try {
                value1 = Integer.parseInt(o1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                value2 = Integer.parseInt(o2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Integer.compare(value1, value2);
        };
        Comparator floatComparator = (o1, o2) -> {
            float value1 = 0.0f;
            float value2 = 0.0f;
            try {
                value1 = Float.parseFloat(o1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                value2 = Float.parseFloat(o2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Float.compare(value1, value2);
        };
        TmmTableFormat.DateComparator dateComparator = new TmmTableFormat.DateComparator();
        TmmTableFormat.DateTimeComparator dateTimeComparator = new TmmTableFormat.DateTimeComparator();
        TmmTableFormat.ImageComparator imageComparator = new TmmTableFormat.ImageComparator();
        TmmTableFormat.VideoFormatComparator videoFormatComparator = new TmmTableFormat.VideoFormatComparator();
        TmmTableFormat.FileSizeComparator fileSizeComparator = new TmmTableFormat.FileSizeComparator();
        TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.originaltitle"), "originalTitle", this::getOriginialTitle, String.class);
        col.setDefaultHidden(true);
        col.setColumnComparator(stringComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.year"), "year", this::getYear, String.class);
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("2000") * 1.3f + 10.0f));
        col.setColumnComparator(integerComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.season.count"), "seasons", this::getSeasons, String.class);
        col.setHeaderIcon(IconManager.SEASONS);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("99") * 1.2f));
        col.setColumnComparator(integerComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.episode.count"), "episodes", this::getEpisodes, String.class);
        col.setHeaderIcon(IconManager.EPISODES);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("999") * 1.2f + 10.0f));
        col.setColumnComparator(integerComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.path"), "path", this::getFolderPath, String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.rating"), "rating", this::getRating, String.class);
        col.setHeaderIcon(IconManager.RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("99.9") * 1.2f));
        col.setColumnComparator(floatComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.votes"), "votes", this::getVotes, String.class);
        col.setHeaderIcon(IconManager.VOTES);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("1000000") * 1.2f + 10.0f));
        col.setDefaultHidden(true);
        col.setColumnComparator(integerComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.userrating"), "userrating", this::getUserRating, String.class);
        col.setHeaderIcon(IconManager.USER_RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("99.9") * 1.2f));
        col.setColumnComparator(floatComparator);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.aired"), "aired", this::getAiredDate, Date.class);
        col.setHeaderIcon(IconManager.DATE_AIRED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        try {
            date2 = StrgUtils.parseDate("2012-12-12");
            col.setMinWidth((int)((float)fontMetrics.stringWidth(TmmDateFormat.MEDIUM_DATE_FORMAT.format(date2)) * 1.2f));
        }
        catch (Exception date2) {
            // empty catch block
        }
        col.setColumnComparator(dateComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.dateadded"), "dateAdded", this::getDateAdded, Date.class);
        col.setHeaderIcon(IconManager.DATE_ADDED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        try {
            date2 = StrgUtils.parseDate("2012-12-12");
            col.setMinWidth((int)((float)fontMetrics.stringWidth(TmmDateFormat.MEDIUM_DATE_FORMAT.format(date2)) * 1.2f + 10.0f));
        }
        catch (Exception date3) {
            // empty catch block
        }
        col.setColumnComparator(dateTimeComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.filecreationdate"), "fileCreationDate", this::getFileCreationDate, Date.class);
        col.setHeaderIcon(IconManager.DATE_CREATED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        try {
            date2 = StrgUtils.parseDate("2012-12-12");
            col.setMinWidth((int)((float)fontMetrics.stringWidth(TmmDateFormat.MEDIUM_DATE_FORMAT.format(date2)) * 1.2f + 10.0f));
        }
        catch (Exception exception) {
            // empty catch block
        }
        col.setColumnComparator(dateTimeComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.format"), "format", this::getFormat, String.class);
        col.setHeaderIcon(IconManager.VIDEO_FORMAT);
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("1080p") * 1.2f));
        col.setDefaultHidden(true);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnComparator(videoFormatComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.videocodec"), "videoCodec", this::getVideoCodec, String.class);
        col.setHeaderIcon(IconManager.VIDEO_CODEC);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("MPEG-2") * 1.2f + 10.0f));
        col.setDefaultHidden(true);
        col.setColumnComparator(stringComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.videobitrate"), "videoBitrate", this::getVideoBitrate, Integer.class);
        col.setHeaderIcon(IconManager.VIDEO_BITRATE);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("20000") * 1.2f + 10.0f));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.videofilesize"), "fileSize", this::getVideoFileSize, String.class);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("50000M") * 1.2f));
        col.setDefaultHidden(true);
        col.setColumnComparator(fileSizeComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.totalfilesize"), "totalFileSize", this::getTotalFileSize, String.class);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("50000M") * 1.2f));
        col.setDefaultHidden(true);
        col.setColumnComparator(fileSizeComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.aspectratio"), "aspectratio", this::getAspectRatio, Float.class);
        col.setHeaderIcon(IconManager.ASPECT_RATIO);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("1.78") * 1.2f + 10.0f));
        col.setDefaultHidden(true);
        col.setColumnComparator(floatComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.hdr"), "hdr", this::isHDR, ImageIcon.class);
        col.setHeaderIcon(IconManager.HDR);
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("movieextendedsearch.newepisodes"), "new", this::getNewIcon, ImageIcon.class);
        col.setHeaderIcon(IconManager.NEW);
        col.setColumnResizeable(false);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("tmm.metadata"), "metadata", this::hasMetadata, ImageIcon.class);
        col.setHeaderIcon(IconManager.NFO);
        col.setColumnResizeable(false);
        col.setColumnTooltip(this::hasMetadataTooltip);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("tmm.images"), "images", this::hasArtwork, ImageIcon.class);
        col.setHeaderIcon(IconManager.IMAGES);
        col.setColumnResizeable(false);
        col.setColumnTooltip(this::hasImageTooltip);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("tmm.subtitles"), "subtitles", this::hasSubtitles, ImageIcon.class);
        col.setHeaderIcon(IconManager.SUBTITLES);
        col.setColumnResizeable(false);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.watched"), "watched", this::isWatched, ImageIcon.class);
        col.setHeaderIcon(IconManager.WATCHED);
        col.setColumnResizeable(false);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.musictheme"), "theme", this::hasDownloadedMusicTheme, ImageIcon.class);
        col.setHeaderIcon(IconManager.MUSIC_HEADER);
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.note"), "note", this::hasNote, ImageIcon.class);
        col.setHeaderIcon(IconManager.INFO);
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        col.setColumnComparator(imageComparator);
        this.addColumn(col);
    }

    @Override
    public String getColumnName(int i) {
        if (i == -1) {
            return TmmResourceBundle.getString("metatag.title");
        }
        return super.getColumnName(i);
    }

    private String getYear(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            int year = ((TvShow)userObject).getYear();
            if (year > 0) {
                return String.valueOf(year);
            }
            return null;
        }
        if (userObject instanceof TvShowSeason) {
            Date firstAired = ((TvShowSeason)userObject).getFirstAired();
            if (firstAired != null) {
                this.calendar.setTime(firstAired);
                return String.valueOf(this.calendar.get(1));
            }
            return null;
        }
        return null;
    }

    private String getSeasons(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            return String.valueOf(((TvShow)userObject).getSeasonCount());
        }
        return null;
    }

    private String getEpisodes(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            return String.valueOf(((TvShow)userObject).getEpisodeCount());
        }
        if (userObject instanceof TvShowSeason && !((TvShowSeason)userObject).getEpisodes().isEmpty()) {
            return String.valueOf(((TvShowSeason)userObject).getEpisodes().size());
        }
        return null;
    }

    private String getFolderPath(TmmTreeNode node) {
        TvShowEpisode episode;
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return tvShow.getPathNIO().toAbsolutePath().toString();
        }
        if (userObject instanceof TvShowEpisode && (episode = (TvShowEpisode)userObject).getPathNIO() != null) {
            return episode.getPathNIO().toAbsolutePath().toString();
        }
        return null;
    }

    private ImageIcon getNewIcon(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getNewIcon(tvShow.isNewlyAdded() || tvShow.hasNewlyAddedEpisodes());
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.getNewIcon(season.isNewlyAdded());
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getNewIcon(episode.isNewlyAdded());
        }
        return null;
    }

    private String getRating(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if ((userObject instanceof TvShow || userObject instanceof TvShowEpisode) && (mediaRating = ((MediaEntity)userObject).getRating()) != null && mediaRating != MediaMetadata.EMPTY_RATING && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getRating());
        }
        return null;
    }

    private String getVotes(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if ((userObject instanceof TvShow || userObject instanceof TvShowEpisode) && (mediaRating = ((MediaEntity)userObject).getRating()) != null && mediaRating != MediaMetadata.EMPTY_RATING && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getVotes());
        }
        return null;
    }

    private String getUserRating(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if ((userObject instanceof TvShow || userObject instanceof TvShowEpisode) && (mediaRating = ((MediaEntity)userObject).getUserRating()) != null && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getRating());
        }
        return null;
    }

    private Date getAiredDate(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            return ((TvShow)userObject).getFirstAired();
        }
        if (userObject instanceof TvShowSeason) {
            return ((TvShowSeason)userObject).getFirstAired();
        }
        if (userObject instanceof TvShowEpisode) {
            return ((TvShowEpisode)userObject).getFirstAired();
        }
        return null;
    }

    private Date getDateAdded(TmmTreeNode node) {
        TvShowEpisode episode;
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            return ((TvShow)userObject).getDateAddedForUi();
        }
        if (userObject instanceof TvShowEpisode && !(episode = (TvShowEpisode)userObject).isDummy()) {
            return episode.getDateAddedForUi();
        }
        return null;
    }

    private Date getFileCreationDate(TmmTreeNode node) {
        TvShowEpisode episode;
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode && !(episode = (TvShowEpisode)userObject).isDummy()) {
            return episode.getMainVideoFile().getDateCreated();
        }
        return null;
    }

    private String getFormat(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            return ((TvShowEpisode)userObject).getMediaInfoVideoFormat();
        }
        return "";
    }

    private String getVideoCodec(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            return ((TvShowEpisode)userObject).getMediaInfoVideoCodec();
        }
        return "";
    }

    private Integer getVideoBitrate(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            return ((TvShowEpisode)userObject).getMediaInfoVideoBitrate();
        }
        return null;
    }

    private String getVideoFileSize(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            long size = ((TvShow)userObject).getVideoFilesize();
            return (int)((double)size / 1000000.0) + " M";
        }
        if (userObject instanceof TvShowSeason) {
            long size = ((TvShowSeason)userObject).getVideoFilesize();
            return (int)((double)size / 1000000.0) + " M";
        }
        if (userObject instanceof TvShowEpisode) {
            long size = ((TvShowEpisode)userObject).getVideoFilesize();
            return (int)((double)size / 1000000.0) + " M";
        }
        return "";
    }

    private String getTotalFileSize(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            long size = ((TvShow)userObject).getTotalFilesize();
            return (int)((double)size / 1000000.0) + " M";
        }
        if (userObject instanceof TvShowSeason) {
            long size = ((TvShowSeason)userObject).getTotalFilesize();
            return (int)((double)size / 1000000.0) + " M";
        }
        if (userObject instanceof TvShowEpisode) {
            long size = ((TvShowEpisode)userObject).getTotalFilesize();
            return (int)((double)size / 1000000.0) + " M";
        }
        return "";
    }

    private Float getAspectRatio(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            return Float.valueOf(((TvShowEpisode)userObject).getMediaInfoAspectRatio());
        }
        return null;
    }

    private ImageIcon isHDR(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(StringUtils.isNotEmpty((CharSequence)episode.getVideoHDRFormat()));
        }
        return null;
    }

    private ImageIcon hasMetadata(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getTriStateIcon(TmmTreeTableFormat.TRI_STATE.getState(this.tvShowList.detectMissingMetadata(tvShow).isEmpty(), tvShow.getHasEpisodeMetadata()));
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.getCheckIcon(season.getHasEpisodeMetadata());
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(this.tvShowList.detectMissingMetadata(episode).isEmpty());
        }
        return null;
    }

    private ImageIcon hasArtwork(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getTriStateIcon(TmmTreeTableFormat.TRI_STATE.getState(this.tvShowList.detectMissingArtwork(tvShow).isEmpty(), tvShow.getHasSeasonAndEpisodeImages()));
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.getTriStateIcon(TmmTreeTableFormat.TRI_STATE.getState(this.tvShowList.detectMissingArtwork(season).isEmpty(), season.getHasEpisodeImages()));
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(this.tvShowList.detectMissingArtwork(episode).isEmpty());
        }
        return null;
    }

    private ImageIcon hasSubtitles(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getCheckIcon(tvShow.hasEpisodeSubtitles());
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.getCheckIcon(season.hasEpisodeSubtitles());
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(episode.getHasSubtitles());
        }
        return null;
    }

    private ImageIcon isWatched(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            return this.getCheckIcon(((TvShow)userObject).isWatched());
        }
        if (userObject instanceof TvShowSeason) {
            return this.getCheckIcon(((TvShowSeason)userObject).isWatched());
        }
        if (userObject instanceof TvShowEpisode) {
            return this.getCheckIcon(((TvShowEpisode)userObject).isWatched());
        }
        return null;
    }

    private String hasMetadataTooltip(TmmTreeNode node) {
        TvShowEpisode episode;
        List<TvShowEpisodeScraperMetadataConfig> missingMetadata;
        if (!this.settings.isShowTvShowTableTooltips()) {
            return null;
        }
        ArrayList<TvShowScraperMetadataConfig> tvShowValues = new ArrayList<TvShowScraperMetadataConfig>();
        if (this.settings.isTvShowDisplayAllMissingMetadata()) {
            for (TvShowScraperMetadataConfig config : TvShowScraperMetadataConfig.values()) {
                if (!config.isMetaData() && !config.isCast()) continue;
                tvShowValues.add(config);
            }
        } else {
            tvShowValues.addAll(this.settings.getTvShowCheckMetadata());
        }
        ArrayList<TvShowEpisodeScraperMetadataConfig> episodeValues = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        if (this.settings.isEpisodeDisplayAllMissingMetadata()) {
            for (TvShowEpisodeScraperMetadataConfig config : TvShowEpisodeScraperMetadataConfig.values()) {
                if (!config.isMetaData() && !config.isCast()) continue;
                episodeValues.add(config);
            }
        } else {
            episodeValues.addAll(this.settings.getEpisodeCheckMetadata());
        }
        if (node.getUserObject() instanceof TvShow) {
            TvShow tvShow = (TvShow)node.getUserObject();
            List<TvShowScraperMetadataConfig> missingMetadata2 = this.tvShowList.detectMissingFields(tvShow, tvShowValues);
            boolean missingEpisodeData = false;
            for (TvShowEpisode episode2 : tvShow.getEpisodes()) {
                if (episode2.isDummy() || episode2.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingMetadata() || this.tvShowList.detectMissingFields(episode2, episodeValues).isEmpty()) continue;
                missingEpisodeData = true;
                break;
            }
            Object text = "";
            if (!missingMetadata2.isEmpty()) {
                StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
                for (TvShowScraperMetadataConfig metadataConfig : missingMetadata2) {
                    missing.append("\n").append(metadataConfig.getDescription());
                }
                text = missing.toString();
            }
            if (missingEpisodeData) {
                if (StringUtils.isNotBlank((CharSequence)text)) {
                    text = (String)text + "\n\n";
                }
                text = (String)text + TmmResourceBundle.getString("tvshow.tree.episode.metadata.problem");
            }
            if (StringUtils.isNotBlank((CharSequence)text)) {
                return text;
            }
        } else if (node.getUserObject() instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)node.getUserObject();
            for (TvShowEpisode episode3 : season.getEpisodes()) {
                if (episode3.isDummy() || this.tvShowList.detectMissingFields(episode3, episodeValues).isEmpty()) continue;
                return TmmResourceBundle.getString("tvshow.tree.episode.metadata.problem");
            }
        } else if (node.getUserObject() instanceof TvShowEpisode && !(missingMetadata = this.tvShowList.detectMissingFields(episode = (TvShowEpisode)node.getUserObject(), episodeValues)).isEmpty()) {
            StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
            for (TvShowEpisodeScraperMetadataConfig metadataConfig : missingMetadata) {
                missing.append("\n").append(metadataConfig.getDescription());
            }
            return missing.toString();
        }
        return null;
    }

    private String hasImageTooltip(TmmTreeNode node) {
        TvShowEpisode episode;
        List<TvShowEpisodeScraperMetadataConfig> missingMetadata;
        Object text;
        if (!this.settings.isShowTvShowTableTooltips()) {
            return null;
        }
        ArrayList<TvShowScraperMetadataConfig> tvShowValues = new ArrayList<TvShowScraperMetadataConfig>();
        if (this.settings.isTvShowDisplayAllMissingArtwork()) {
            for (TvShowScraperMetadataConfig config : TvShowScraperMetadataConfig.values()) {
                if (!config.isArtwork()) continue;
                tvShowValues.add(config);
            }
        } else {
            tvShowValues.addAll(this.settings.getTvShowCheckArtwork());
        }
        ArrayList<TvShowScraperMetadataConfig> seasonValues = new ArrayList<TvShowScraperMetadataConfig>();
        if (this.settings.isSeasonDisplayAllMissingArtwork()) {
            for (TvShowScraperMetadataConfig config : TvShowScraperMetadataConfig.values()) {
                if (!config.isArtwork() || !config.name().startsWith("SEASON")) continue;
                seasonValues.add(config);
            }
        } else {
            seasonValues.addAll(this.settings.getSeasonCheckArtwork());
        }
        ArrayList<TvShowEpisodeScraperMetadataConfig> episodeValues = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        if (this.settings.isEpisodeDisplayAllMissingArtwork()) {
            for (TvShowEpisodeScraperMetadataConfig config : TvShowEpisodeScraperMetadataConfig.values()) {
                if (!config.isArtwork()) continue;
                episodeValues.add(config);
            }
        } else {
            episodeValues.addAll(this.settings.getEpisodeCheckArtwork());
        }
        if (node.getUserObject() instanceof TvShow) {
            TvShow tvShow = (TvShow)node.getUserObject();
            List<TvShowScraperMetadataConfig> missingMetadata2 = this.tvShowList.detectMissingFields(tvShow, tvShowValues);
            boolean missingSeasonEpisodeData = false;
            for (TvShowSeason season : tvShow.getSeasons()) {
                if (!this.tvShowList.detectMissingFields(season, seasonValues).isEmpty()) {
                    missingSeasonEpisodeData = true;
                    break;
                }
                for (TvShowEpisode episode2 : season.getEpisodes()) {
                    if (episode2.isDummy() || episode2.getSeason() == 0 && !TvShowModuleManager.getInstance().getSettings().isEpisodeSpecialsCheckMissingMetadata() || this.tvShowList.detectMissingFields(episode2, episodeValues).isEmpty()) continue;
                    missingSeasonEpisodeData = true;
                    break;
                }
                if (!missingSeasonEpisodeData) continue;
                break;
            }
            text = "";
            if (!missingMetadata2.isEmpty()) {
                StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
                for (TvShowScraperMetadataConfig metadataConfig : missingMetadata2) {
                    missing.append("\n").append(metadataConfig.getDescription());
                }
                text = missing.toString();
            }
            if (missingSeasonEpisodeData) {
                if (StringUtils.isNotBlank((CharSequence)text)) {
                    text = (String)text + "\n\n";
                }
                text = (String)text + TmmResourceBundle.getString("tvshow.tree.season.artwork.problem");
            }
            if (StringUtils.isNotBlank((CharSequence)text)) {
                return text;
            }
        } else if (node.getUserObject() instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)node.getUserObject();
            List<TvShowScraperMetadataConfig> missingMetadata3 = this.tvShowList.detectMissingFields(season, seasonValues);
            boolean missingEpisodeData = false;
            for (TvShowEpisode episode3 : season.getEpisodes()) {
                if (episode3.isDummy() || this.tvShowList.detectMissingFields(episode3, episodeValues).isEmpty()) continue;
                missingEpisodeData = true;
                break;
            }
            text = "";
            if (!missingMetadata3.isEmpty()) {
                StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
                for (TvShowScraperMetadataConfig metadataConfig : missingMetadata3) {
                    missing.append("\n").append(metadataConfig.getDescription());
                }
                text = missing.toString();
            }
            if (missingEpisodeData) {
                if (StringUtils.isNotBlank((CharSequence)text)) {
                    text = (String)text + "\n\n";
                }
                text = (String)text + TmmResourceBundle.getString("tvshow.tree.episode.artwork.problem");
            }
            if (StringUtils.isNotBlank((CharSequence)text)) {
                return text;
            }
        } else if (node.getUserObject() instanceof TvShowEpisode && !(missingMetadata = this.tvShowList.detectMissingFields(episode = (TvShowEpisode)node.getUserObject(), episodeValues)).isEmpty()) {
            StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
            for (TvShowEpisodeScraperMetadataConfig metadataConfig : missingMetadata) {
                missing.append("\n").append(metadataConfig.getDescription());
            }
            return missing.toString();
        }
        return null;
    }

    private String getOriginialTitle(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            return ((TvShow)userObject).getOriginalTitle();
        }
        if (userObject instanceof TvShowEpisode) {
            return ((TvShowEpisode)userObject).getOriginalTitle();
        }
        return null;
    }

    private ImageIcon hasDownloadedMusicTheme(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            return this.getCheckIcon(((TvShow)userObject).getHasMusicTheme());
        }
        return null;
    }

    private ImageIcon hasNote(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            return this.getCheckIcon(((TvShow)userObject).getHasNote());
        }
        if (userObject instanceof TvShowEpisode) {
            return this.getCheckIcon(((TvShowEpisode)userObject).getHasNote());
        }
        return null;
    }
}

