/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.tree.TmmTreeDataProvider;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.ITmmTreeTableSortingStrategy;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableFormat;

public class TvShowTreeDataProvider
extends TmmTreeDataProvider<TmmTreeNode> {
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    private final TmmTreeTableFormat<TmmTreeNode> tableFormat;
    private final TmmTreeNode root = new TmmTreeNode(new Object(), this);
    private final PropertyChangeListener tvShowPropertyChangeListener;
    private final PropertyChangeListener episodePropertyChangeListener;
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    public TvShowTreeDataProvider(TmmTreeTableFormat<TmmTreeNode> tableFormat) {
        this.tableFormat = tableFormat;
        PropertyChangeListener tvShowListPropertyChangeListener = evt -> {
            switch (evt.getPropertyName()) {
                case "addedTvShow": {
                    TvShow tvShow = (TvShow)evt.getNewValue();
                    this.addTvShow(tvShow);
                    break;
                }
                case "removedTvShow": {
                    TvShow tvShow = (TvShow)evt.getNewValue();
                    this.removeTvShow(tvShow);
                    break;
                }
                default: {
                    if (evt.getSource() instanceof TvShowList) break;
                    this.nodeChanged(evt.getSource());
                }
            }
        };
        this.tvShowList.addPropertyChangeListener(tvShowListPropertyChangeListener);
        this.tvShowPropertyChangeListener = evt -> {
            if (!(evt.getSource() instanceof TvShow)) {
                return;
            }
            switch (evt.getPropertyName()) {
                case "addedSeason": {
                    TvShowSeason season = (TvShowSeason)evt.getNewValue();
                    this.addTvShowSeason(season);
                    break;
                }
                case "addedEpisode": {
                    TvShowEpisode episode = (TvShowEpisode)evt.getNewValue();
                    this.addTvShowEpisode(episode);
                    break;
                }
                case "removedEpisode": {
                    TvShowEpisode episode = (TvShowEpisode)evt.getNewValue();
                    this.removeTvShowEpisode(episode);
                    break;
                }
                case "episodeCount": 
                case "seasonCount": {
                    break;
                }
                default: {
                    this.nodeChanged(evt.getSource());
                }
            }
        };
        this.episodePropertyChangeListener = evt -> {
            TvShowEpisode episode = (TvShowEpisode)evt.getSource();
            switch (evt.getPropertyName()) {
                case "season": 
                case "episode": {
                    this.removeTvShowEpisode(episode);
                    this.addTvShowEpisode(episode);
                    this.updateDummyEpisodesForTvShow(episode.getTvShow());
                    break;
                }
                case "tvShow": {
                    break;
                }
                case "watched": 
                case "mediaFiles": {
                    this.nodeChanged(episode);
                    this.nodeChanged(episode.getTvShowSeason());
                    this.nodeChanged(episode.getTvShow());
                    break;
                }
                default: {
                    this.nodeChanged(episode);
                }
            }
        };
        this.setTreeComparator(new TvShowTreeNodeComparator());
        TvShowModuleManager.getInstance().getSettings().addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "displayMissingEpisodes": {
                    if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) {
                        this.addDummyEpisodes();
                        break;
                    }
                    this.removeDummyEpisodes();
                    break;
                }
                case "displayMissingSpecials": {
                    if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingSpecials()) {
                        this.addDummySpecials();
                        break;
                    }
                    this.removeDummySpecials();
                }
            }
        });
    }

    private void addDummyEpisodes() {
        for (TvShow tvShow : this.tvShowList.getTvShows()) {
            for (TvShowEpisode episode : tvShow.getEpisodesForDisplay()) {
                if (!episode.isDummy()) continue;
                this.addTvShowEpisode(episode);
            }
        }
    }

    private void removeDummyEpisodes() {
        for (TvShow tvShow : this.tvShowList.getTvShows()) {
            for (TvShowEpisode episode : tvShow.getDummyEpisodes()) {
                if (!episode.isDummy()) continue;
                this.removeTvShowEpisode(episode);
            }
            for (TvShowSeason season : tvShow.getSeasons()) {
                if (!season.isDummy()) continue;
                this.removeTvShowSeason(season);
            }
        }
    }

    private void updateDummyEpisodesForTvShow(TvShow tvShow) {
        List<TvShowEpisode> dummyEpisodes = tvShow.getDummyEpisodes();
        List<TvShowEpisode> episodesForDisplay = tvShow.getEpisodesForDisplay();
        for (TvShowEpisode episode : dummyEpisodes) {
            if (episodesForDisplay.contains(episode) && this.getNodeFromCache(episode) == null) {
                this.addTvShowEpisode(episode);
                continue;
            }
            if (episodesForDisplay.contains(episode) || this.getNodeFromCache(episode) == null) continue;
            this.removeTvShowEpisode(episode);
        }
    }

    private void addDummySpecials() {
        for (TvShow tvShow : this.tvShowList.getTvShows()) {
            for (TvShowEpisode episode : tvShow.getEpisodesForDisplay()) {
                if (!episode.isDummy() || episode.getSeason() != 0) continue;
                this.addTvShowEpisode(episode);
            }
        }
    }

    private void removeDummySpecials() {
        for (TvShow tvShow : this.tvShowList.getTvShows()) {
            for (TvShowEpisode episode : tvShow.getDummyEpisodes()) {
                if (!episode.isDummy() || episode.getSeason() != 0) continue;
                this.removeTvShowEpisode(episode);
            }
            for (TvShowSeason season : tvShow.getSeasons()) {
                if (season.getSeason() != 0 || !season.isDummy()) continue;
                this.removeTvShowSeason(season);
            }
        }
    }

    private void nodeChanged(Object source) {
        TmmTreeNode node = this.getNodeFromCache(source);
        if (node != null) {
            this.firePropertyChange("nodeChanged", null, node);
        }
    }

    @Override
    public TmmTreeNode getRoot() {
        return this.root;
    }

    @Override
    public TmmTreeNode getParent(TmmTreeNode child) {
        if (child.getUserObject() instanceof TvShow) {
            return this.root;
        }
        if (child.getUserObject() instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)child.getUserObject();
            TmmTreeNode node = this.getNodeFromCache(season.getTvShow());
            if (node == null) {
                node = this.addTvShow(season.getTvShow());
            }
            return node;
        }
        if (child.getUserObject() instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)child.getUserObject();
            TmmTreeNode node = this.getNodeFromCache(episode.getTvShowSeason());
            if (node == null) {
                node = this.addTvShowSeason(episode.getTvShowSeason());
            }
            if (this.getNodeFromCache(episode.getTvShow()) == null) {
                this.addTvShow(episode.getTvShow());
            }
            return node;
        }
        return null;
    }

    @Override
    public List<TmmTreeNode> getChildren(TmmTreeNode parent) {
        if (parent == this.root) {
            ArrayList<TmmTreeNode> nodes = new ArrayList<TmmTreeNode>();
            for (TvShow tvShow : new ArrayList<TvShow>(this.tvShowList.getTvShows())) {
                TvShowTreeNode node = new TvShowTreeNode((Object)tvShow, this);
                this.putNodeToCache(tvShow, node);
                nodes.add(node);
                tvShow.addPropertyChangeListener(this.tvShowPropertyChangeListener);
            }
            return nodes;
        }
        if (parent.getUserObject() instanceof TvShow) {
            TvShow tvShow = (TvShow)parent.getUserObject();
            ArrayList<TmmTreeNode> nodes = new ArrayList<TmmTreeNode>();
            for (TvShowSeason season : tvShow.getSeasons()) {
                TvShowSeasonTreeNode node = new TvShowSeasonTreeNode((Object)season, this);
                this.putNodeToCache(season, node);
                nodes.add(node);
            }
            return nodes;
        }
        if (parent.getUserObject() instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)parent.getUserObject();
            ArrayList<TmmTreeNode> nodes = new ArrayList<TmmTreeNode>();
            for (TvShowEpisode episode : season.getEpisodesForDisplay()) {
                TmmTreeNode node = this.getNodeFromCache(episode);
                if (node == null) {
                    node = new TvShowEpisodeTreeNode((Object)episode, this);
                    this.putNodeToCache(episode, node);
                }
                nodes.add(node);
                episode.addPropertyChangeListener(this.episodePropertyChangeListener);
            }
            return nodes;
        }
        return null;
    }

    @Override
    public boolean isLeaf(TmmTreeNode node) {
        return node.getUserObject() instanceof TvShowEpisode;
    }

    @Override
    public Comparator<TmmTreeNode> getTreeComparator() {
        return super.getTreeComparator();
    }

    private TmmTreeNode addTvShow(TvShow tvShow) {
        TmmTreeNode cachedNode = this.getNodeFromCache(tvShow);
        if (cachedNode != null) {
            return cachedNode;
        }
        TvShowTreeNode node = new TvShowTreeNode((Object)tvShow, this);
        this.putNodeToCache(tvShow, node);
        this.firePropertyChange("nodeInserted", null, node);
        tvShow.addPropertyChangeListener(this.tvShowPropertyChangeListener);
        return node;
    }

    private void removeTvShow(TvShow tvShow) {
        tvShow.removePropertyChangeListener(this.tvShowPropertyChangeListener);
        TmmTreeNode cachedNode = this.removeNodeFromCache(tvShow);
        if (cachedNode == null) {
            return;
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            this.removeNodeFromCache(season);
        }
        for (TvShowEpisode episode : tvShow.getEpisodesForDisplay()) {
            this.removeNodeFromCache(episode);
        }
        this.firePropertyChange("nodeRemoved", null, cachedNode);
    }

    private TmmTreeNode addTvShowSeason(TvShowSeason season) {
        TmmTreeNode cachedNode = this.getNodeFromCache(season);
        if (cachedNode != null) {
            return cachedNode;
        }
        TvShowSeasonTreeNode node = new TvShowSeasonTreeNode((Object)season, this);
        this.putNodeToCache(season, node);
        this.firePropertyChange("nodeInserted", null, node);
        return node;
    }

    private TmmTreeNode addTvShowEpisode(TvShowEpisode episode) {
        TmmTreeNode cachedNode = this.getNodeFromCache(episode);
        if (cachedNode != null) {
            return cachedNode;
        }
        TvShowEpisodeTreeNode node = new TvShowEpisodeTreeNode((Object)episode, this);
        this.putNodeToCache(episode, node);
        this.firePropertyChange("nodeInserted", null, node);
        episode.addPropertyChangeListener(this.episodePropertyChangeListener);
        return node;
    }

    private void removeTvShowEpisode(TvShowEpisode episode) {
        episode.removePropertyChangeListener(this.episodePropertyChangeListener);
        TmmTreeNode cachedNode = this.removeNodeFromCache(episode);
        if (cachedNode == null) {
            return;
        }
        this.firePropertyChange("nodeRemoved", null, cachedNode);
        for (TvShowSeason season : episode.getTvShow().getSeasons()) {
            if (!season.getEpisodesForDisplay().isEmpty()) continue;
            this.removeTvShowSeason(season);
        }
    }

    private void removeTvShowSeason(TvShowSeason season) {
        season.removePropertyChangeListener(this.episodePropertyChangeListener);
        TmmTreeNode cachedNode = this.removeNodeFromCache(season);
        if (cachedNode == null) {
            return;
        }
        this.firePropertyChange("nodeRemoved", null, cachedNode);
    }

    public static class TvShowEpisodeTreeNode
    extends AbstractTvShowTreeNode {
        private static final long serialVersionUID = -7108614568808831980L;

        public TvShowEpisodeTreeNode(Object userObject, TmmTreeDataProvider<TmmTreeNode> dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)this.getUserObject();
                if (episode.getEpisode() >= 0) {
                    return episode.getEpisode() + ". " + episode.getTitle();
                }
                return episode.getTitleSortable();
            }
            return super.toString();
        }

        @Override
        public String getTitle() {
            if (this.getUserObject() instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)this.getUserObject();
                return episode.getTitle();
            }
            return this.toString();
        }

        @Override
        public String getOriginalTitle() {
            if (this.getUserObject() instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)this.getUserObject();
                return episode.getOriginalTitle();
            }
            return this.toString();
        }

        @Override
        String getNote() {
            if (this.getUserObject() instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)this.getUserObject();
                return episode.getNote();
            }
            return this.toString();
        }
    }

    public static class TvShowSeasonTreeNode
    extends AbstractTvShowTreeNode {
        private static final long serialVersionUID = -5734830011018805194L;

        public TvShowSeasonTreeNode(Object userObject, TmmTreeDataProvider<TmmTreeNode> dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)this.getUserObject();
                if (StringUtils.isNotBlank((CharSequence)season.getTitle())) {
                    return season.getTitle();
                }
                if (season.getSeason() == -1) {
                    return TmmResourceBundle.getString("tvshow.uncategorized");
                }
                if (season.getSeason() == 0) {
                    return TmmResourceBundle.getString("metatag.specials");
                }
                return TmmResourceBundle.getString("metatag.season") + " " + season.getSeason();
            }
            return super.toString();
        }

        @Override
        public String getTitle() {
            return this.toString();
        }

        @Override
        public String getOriginalTitle() {
            return this.toString();
        }

        @Override
        String getNote() {
            return this.toString();
        }
    }

    public static class TvShowTreeNode
    extends AbstractTvShowTreeNode {
        private static final long serialVersionUID = -1316609340104597133L;

        TvShowTreeNode(Object userObject, TmmTreeDataProvider<TmmTreeNode> dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof TvShow) {
                TvShow tvShow = (TvShow)this.getUserObject();
                return tvShow.getTitleSortable();
            }
            return super.toString();
        }

        @Override
        public String getTitle() {
            if (this.getUserObject() instanceof TvShow) {
                TvShow tvShow = (TvShow)this.getUserObject();
                return tvShow.getTitle();
            }
            return this.toString();
        }

        @Override
        public String getOriginalTitle() {
            if (this.getUserObject() instanceof TvShow) {
                TvShow tvShow = (TvShow)this.getUserObject();
                return tvShow.getOriginalTitle();
            }
            return this.toString();
        }

        @Override
        String getNote() {
            return this.toString();
        }
    }

    static abstract class AbstractTvShowTreeNode
    extends TmmTreeNode {
        AbstractTvShowTreeNode(Object userObject, TmmTreeDataProvider<TmmTreeNode> dataProvider) {
            super(userObject, dataProvider);
        }

        abstract String getTitle();

        abstract String getOriginalTitle();

        abstract String getNote();
    }

    class TvShowTreeNodeComparator
    implements Comparator<TmmTreeNode>,
    ITmmTreeTableSortingStrategy {
        private final Comparator stringComparator = new TmmTableFormat.StringComparator();
        private ITmmTreeTableSortingStrategy.SortDirection sortDirection = ITmmTreeTableSortingStrategy.SortDirection.ASCENDING;
        private int sortColumn = 0;
        private Comparator sortComparator = this.getSortComparator();

        private TvShowTreeNodeComparator() {
        }

        @Override
        public int compare(TmmTreeNode o1, TmmTreeNode o2) {
            Object userObject1 = o1.getUserObject();
            Object userObject2 = o2.getUserObject();
            if (userObject1 instanceof TvShow && userObject2 instanceof TvShow) {
                int compairingResult = this.sortComparator.compare(this.getColumnValue(o1, this.sortColumn), this.getColumnValue(o2, this.sortColumn));
                if (compairingResult == 0 && this.sortColumn != 0) {
                    compairingResult = this.stringComparator.compare(this.getColumnValue(o1, 0), this.getColumnValue(o2, 0));
                } else if (this.sortDirection == ITmmTreeTableSortingStrategy.SortDirection.DESCENDING) {
                    compairingResult *= -1;
                }
                return compairingResult;
            }
            if (userObject1 instanceof TvShowSeason && userObject2 instanceof TvShowSeason) {
                TvShowSeason tvShowSeason1 = (TvShowSeason)userObject1;
                TvShowSeason tvShowSeason2 = (TvShowSeason)userObject2;
                return tvShowSeason1.getSeason() - tvShowSeason2.getSeason();
            }
            if (userObject1 instanceof TvShowEpisode && userObject2 instanceof TvShowEpisode) {
                TvShowEpisode tvShowEpisode1 = (TvShowEpisode)userObject1;
                TvShowEpisode tvShowEpisode2 = (TvShowEpisode)userObject2;
                return tvShowEpisode1.getEpisode() - tvShowEpisode2.getEpisode();
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }

        @Override
        public void columnClicked(int column, boolean shift, boolean control) {
            this.sortDirection = this.sortColumn == column ? (this.sortDirection == ITmmTreeTableSortingStrategy.SortDirection.ASCENDING ? ITmmTreeTableSortingStrategy.SortDirection.DESCENDING : ITmmTreeTableSortingStrategy.SortDirection.ASCENDING) : ITmmTreeTableSortingStrategy.SortDirection.ASCENDING;
            this.sortColumn = column;
            this.sortComparator = this.getSortComparator();
        }

        private Comparator getSortComparator() {
            if (this.sortColumn == 0) {
                return this.stringComparator;
            }
            return TvShowTreeDataProvider.this.tableFormat.getColumnComparator(this.sortColumn - 1);
        }

        private Object getColumnValue(TmmTreeNode treeNode, int i) {
            if (i == 0) {
                return ((TvShow)treeNode.getUserObject()).getTitleSortable();
            }
            return TvShowTreeDataProvider.this.tableFormat.getColumnValue(treeNode, i - 1);
        }

        @Override
        public ITmmTreeTableSortingStrategy.SortDirection getSortDirection(int sortColumn) {
            if (sortColumn == this.sortColumn) {
                return this.sortDirection;
            }
            return null;
        }
    }
}

