/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowBulkEditorDialog;

public class TvShowBulkEditAction
extends TmmAction {
    private static final long serialVersionUID = -1193886444149690516L;

    public TvShowBulkEditAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.bulkedit"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.bulkedit.desc"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        ArrayList<TvShow> selectedTvShows = new ArrayList<TvShow>();
        HashSet<TvShowEpisode> selectedEpisodes = new HashSet<TvShowEpisode>();
        for (Object obj : selectedObjects) {
            if (obj instanceof TvShow) {
                TvShow tvShow = (TvShow)obj;
                selectedTvShows.add(tvShow);
                selectedEpisodes.addAll(tvShow.getEpisodes());
            }
            if (obj instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj;
                selectedEpisodes.addAll(season.getEpisodes());
            }
            if (!(obj instanceof TvShowEpisode)) continue;
            TvShowEpisode tvShowEpisode = (TvShowEpisode)obj;
            selectedEpisodes.add(tvShowEpisode);
        }
        if (selectedTvShows.isEmpty() && selectedEpisodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TvShowBulkEditorDialog dialog = new TvShowBulkEditorDialog(selectedTvShows, new ArrayList<TvShowEpisode>(selectedEpisodes));
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.setVisible(true);
    }
}

