/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.dialogs.CleanUpUnwantedFilesDialog;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowCleanUpFilesAction
extends TmmAction {
    public TvShowCleanUpFilesAction() {
        this.putValue("Name", TmmResourceBundle.getString("cleanupfiles"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("cleanupfiles.desc"));
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("SwingLargeIconKey", IconManager.DELETE);
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<MediaEntity> selectedTvShows = new ArrayList<MediaEntity>(TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShowsRecursive());
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        CleanUpUnwantedFilesDialog dialog = new CleanUpUnwantedFilesDialog(selectedTvShows);
        dialog.setVisible(true);
    }
}

