/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowClearImageCacheAction
extends TmmAction {
    private static final long serialVersionUID = 3452373237085274937L;

    public TvShowClearImageCacheAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.clearimagecache"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        ArrayList<TvShowEpisode> selectedEpisodes = new ArrayList<TvShowEpisode>();
        for (Object obj : TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects()) {
            TvShowEpisode episode;
            if (!(obj instanceof TvShowEpisode) || selectedTvShows.contains((episode = (TvShowEpisode)obj).getTvShow())) continue;
            selectedEpisodes.add(episode);
        }
        if (selectedEpisodes.isEmpty() && selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        for (TvShow tvShow : selectedTvShows) {
            ImageCache.clearImageCacheForMediaEntity(tvShow);
        }
        for (TvShowEpisode episode : selectedEpisodes) {
            ImageCache.clearImageCacheForMediaEntity(episode);
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

