/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowDeleteAction
extends TmmAction {
    private static final long serialVersionUID = -2355545751433709417L;

    public TvShowDeleteAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.delete"));
        this.putValue("SmallIcon", IconManager.DELETE_FOREVER);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.delete.hint"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
        int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tvshow.delete.desc"), TmmResourceBundle.getString("tvshow.delete"), 0, 3, null, options, null);
        if (answer != 0) {
            return;
        }
        if (selectedObjects.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(() -> {
            for (Object obj : selectedObjects) {
                if (obj instanceof TvShow) {
                    TvShow tvShow = (TvShow)obj;
                    TvShowModuleManager.getInstance().getTvShowList().deleteTvShow(tvShow);
                }
                if (obj instanceof TvShowSeason) {
                    TvShowSeason season = (TvShowSeason)obj;
                    ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(season.getEpisodes());
                    for (TvShowEpisode episode : episodes) {
                        season.getTvShow().deleteEpisode(episode);
                    }
                }
                if (!(obj instanceof TvShowEpisode)) continue;
                TvShowEpisode tvShowEpisode = (TvShowEpisode)obj;
                tvShowEpisode.getTvShow().deleteEpisode(tvShowEpisode);
            }
        });
    }
}

