/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowDeleteMediainfoXmlAction
extends TmmAction {
    private static final long serialVersionUID = -2029243504238273761L;

    public TvShowDeleteMediainfoXmlAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.deletemediainfoxml"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.deletemediainfoxml"));
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("SwingLargeIconKey", IconManager.DELETE);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        ArrayList<TvShow> selectedTvShows = new ArrayList<TvShow>();
        HashSet<TvShowEpisode> selectedEpisodes = new HashSet<TvShowEpisode>();
        for (Object obj : selectedObjects) {
            if (obj instanceof TvShow) {
                TvShow tvShow = (TvShow)obj;
                selectedTvShows.add(tvShow);
                selectedEpisodes.addAll(tvShow.getEpisodes());
            }
            if (obj instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)obj;
                selectedEpisodes.addAll(season.getEpisodes());
            }
            if (!(obj instanceof TvShowEpisode)) continue;
            TvShowEpisode tvShowEpisode = (TvShowEpisode)obj;
            selectedEpisodes.add(tvShowEpisode);
        }
        if (selectedTvShows.isEmpty() && selectedEpisodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        if (!TmmProperties.getInstance().getPropertyAsBoolean("tvshow.hidedeletemediainfoxmlhint").booleanValue()) {
            JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)checkBox, TmmFontHelper.L1);
            checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            Object[] params = new Object[]{TmmResourceBundle.getString("tvshow.deletemediainfoxml.desc"), checkBox};
            int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("tvshow.deletemediainfoxml"), 0, 3, null, options, null);
            if (checkBox.isSelected()) {
                TmmProperties.getInstance().putProperty("tvshow.hidedeletemediainfoxmlhint", String.valueOf(checkBox.isSelected()));
            }
            if (answer != 0) {
                return;
            }
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        for (TvShow tvShow : selectedTvShows) {
            tvShow.getMediaFiles(MediaFileType.MEDIAINFO).forEach(mediaFile -> {
                Utils.deleteFileSafely(mediaFile.getFileAsPath());
                tvShow.removeFromMediaFiles((MediaFile)mediaFile);
            });
        }
        for (TvShowEpisode episode : selectedEpisodes) {
            episode.getMediaFiles(MediaFileType.MEDIAINFO).forEach(mediaFile -> {
                Utils.deleteFileSafely(mediaFile.getFileAsPath());
                episode.removeFromMediaFiles((MediaFile)mediaFile);
            });
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

