/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowDownloadActorImagesAction
extends TmmAction {
    public TvShowDownloadActorImagesAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.downloadactorimages"));
        this.putValue("SmallIcon", IconManager.IMAGE);
        this.putValue("SwingLargeIconKey", IconManager.IMAGE);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 640));
    }

    @Override
    protected void processAction(ActionEvent e) {
        if (!TvShowModuleManager.getInstance().getSettings().isWriteActorImages()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.downloadactorimages.activate"));
            return;
        }
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        ArrayList<TvShowEpisode> selectedEpisodes = new ArrayList<TvShowEpisode>();
        for (Object obj : TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects()) {
            TvShowEpisode episode;
            if (!(obj instanceof TvShowEpisode) || selectedTvShows.contains((episode = (TvShowEpisode)obj).getTvShow())) continue;
            selectedEpisodes.add(episode);
        }
        if (selectedEpisodes.isEmpty() && selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        for (TvShow tvShow : selectedTvShows) {
            tvShow.writeActorImages();
        }
        for (TvShowEpisode episode : selectedEpisodes) {
            episode.writeActorImages();
        }
    }
}

