/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.tasks.TvShowMissingArtworkDownloadTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowScrapeMetadataDialog;

public class TvShowDownloadMissingArtworkAction
extends TmmAction {
    private static final long serialVersionUID = 6102632119900792735L;

    public TvShowDownloadMissingArtworkAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.downloadmissingartwork"));
        this.putValue("SmallIcon", IconManager.IMAGE);
        this.putValue("SwingLargeIconKey", IconManager.IMAGE);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, 640));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        HashSet<TvShowEpisode> selectedEpisodes = new HashSet<TvShowEpisode>();
        if (selectedObjects.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TvShowScrapeMetadataDialog dialog = TvShowScrapeMetadataDialog.createArtworkScrapeDialog(TmmResourceBundle.getString("tvshow.downloadmissingartwork"));
        dialog.setVisible(true);
        if (!dialog.shouldStartScrape()) {
            return;
        }
        TvShowSearchAndScrapeOptions options = dialog.getTvShowSearchAndScrapeOptions();
        List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig = dialog.getTvShowScraperMetadataConfig();
        List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = dialog.getTvShowEpisodeScraperMetadataConfig();
        for (Object obj : selectedObjects) {
            if (obj instanceof TvShow) {
                TvShow show = (TvShow)obj;
                selectedEpisodes.addAll(show.getEpisodes());
            }
            if (obj instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)obj;
                selectedEpisodes.add(episode);
            }
            if (!(obj instanceof TvShowSeason)) continue;
            TvShowSeason season = (TvShowSeason)obj;
            selectedEpisodes.addAll(season.getEpisodes());
        }
        if (!selectedTvShows.isEmpty() || !selectedEpisodes.isEmpty()) {
            TvShowMissingArtworkDownloadTask task = new TvShowMissingArtworkDownloadTask(selectedTvShows, new ArrayList<TvShowEpisode>(selectedEpisodes), options, tvShowScraperMetadataConfig, episodeScraperMetadataConfig);
            TmmTaskManager.getInstance().addDownloadTask(task);
        }
    }
}

