/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.RatingUtil;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowFetchImdbRatingAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowFetchImdbRatingAction.class);

    public TvShowFetchImdbRatingAction() {
        this.putValue("SwingLargeIconKey", IconManager.RATING_BLUE);
        this.putValue("SmallIcon", IconManager.RATING_BLUE);
        this.putValue("Name", TmmResourceBundle.getString("tvshow.refetchimdbrating"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        final HashSet<TvShowEpisode> selectedEpisodes = new HashSet<TvShowEpisode>();
        for (Object obj : TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects()) {
            TvShowEpisode episode;
            if (!(obj instanceof TvShowEpisode) || selectedTvShows.contains((episode = (TvShowEpisode)obj).getTvShow())) continue;
            selectedEpisodes.add(episode);
        }
        selectedTvShows.forEach(tvShow -> selectedEpisodes.addAll(tvShow.getEpisodes()));
        if (selectedEpisodes.isEmpty() && selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("tvshow.refetchimdbrating"), selectedTvShows.size() + selectedEpisodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                MediaRating rating;
                int i = 0;
                for (TvShow tvShow : selectedTvShows) {
                    rating = RatingUtil.getImdbRating(tvShow.getImdbId());
                    if (rating != null) {
                        tvShow.setRating(rating);
                        tvShow.saveToDb();
                        tvShow.writeNFO();
                    }
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    return;
                }
                for (TvShowEpisode episode : selectedEpisodes) {
                    rating = RatingUtil.getImdbRating(episode.getIdAsString("imdb"));
                    if (rating != null) {
                        episode.setRating(rating);
                        episode.saveToDb();
                        episode.writeNFO();
                    }
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

