/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowKodiRefreshNfoAction
extends TmmAction {
    private static final long serialVersionUID = -3911290901017607679L;

    public TvShowKodiRefreshNfoAction() {
        this.putValue("SwingLargeIconKey", IconManager.MEDIAINFO);
        this.putValue("SmallIcon", IconManager.MEDIAINFO);
        this.putValue("Name", TmmResourceBundle.getString("kodi.rpc.refreshnfo"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        final ArrayList<TvShowEpisode> eps = new ArrayList<TvShowEpisode>();
        final HashSet<TvShow> shows = new HashSet<TvShow>();
        for (Object obj : selectedObjects) {
            if (obj instanceof TvShow) {
                TvShow show = (TvShow)obj;
                shows.add(show);
            }
            if (obj instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)obj;
                eps.add(episode);
            }
            if (!(obj instanceof TvShowSeason)) continue;
            TvShowSeason season = (TvShowSeason)obj;
            eps.addAll(season.getEpisodes());
        }
        for (int i = eps.size() - 1; i >= 0; --i) {
            TvShowEpisode ep = (TvShowEpisode)eps.get(i);
            if (!shows.contains(ep.getTvShow())) continue;
            eps.remove(i);
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("kodi.rpc.refreshnfo"), shows.size() + eps.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                KodiRPC kodiRPC = KodiRPC.getInstance();
                int i = 0;
                for (TvShow tvShow : shows) {
                    kodiRPC.refreshFromNfo(tvShow);
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    return;
                }
                for (TvShowEpisode episode : eps) {
                    kodiRPC.refreshFromNfo(episode);
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    return;
                }
                if (this.progressDone > 0) {
                    kodiRPC.updateTvShowMappings();
                }
            }
        });
    }
}

