/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowReloadMediaInformationTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowMediaInformationAction
extends TmmAction {
    private static final long serialVersionUID = -1274423130095036944L;

    public TvShowMediaInformationAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.updatemediainfo"));
        this.putValue("SmallIcon", IconManager.MEDIAINFO);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.updatemediainfo"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        ArrayList<TvShowEpisode> selectedEpisodes = new ArrayList<TvShowEpisode>();
        for (Object obj : TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects()) {
            TvShowEpisode episode;
            if (!(obj instanceof TvShowEpisode) || selectedTvShows.contains((episode = (TvShowEpisode)obj).getTvShow())) continue;
            selectedEpisodes.add(episode);
        }
        if (selectedEpisodes.isEmpty() && selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TvShowReloadMediaInformationTask task = new TvShowReloadMediaInformationTask(selectedTvShows, selectedEpisodes);
        TmmTaskManager.getInstance().addMainTask(task);
    }
}

