/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowMissingEpisodeListDialog;

public class TvShowMissingEpisodeListAction
extends TmmAction {
    public TvShowMissingEpisodeListAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.missingepisodelist"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.missingepisodelist.desc"));
        this.putValue("SwingLargeIconKey", IconManager.LIST);
        this.putValue("SmallIcon", IconManager.LIST);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        ArrayList<TvShow> selectedTvShows = new ArrayList<TvShow>();
        for (Object obj : selectedObjects) {
            TvShowSeason tvShowSeason;
            if (obj instanceof TvShow) {
                TvShow tvShow = (TvShow)obj;
                selectedTvShows.add(tvShow);
            }
            if (!(obj instanceof TvShowSeason) || selectedTvShows.contains((tvShowSeason = (TvShowSeason)obj).getTvShow())) continue;
            selectedTvShows.add(tvShowSeason.getTvShow());
        }
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TvShowMissingEpisodeListDialog dialog = new TvShowMissingEpisodeListDialog(selectedTvShows);
        dialog.setVisible(true);
    }
}

