/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowReadEpisodeNfoAction
extends TmmAction {
    private static final long serialVersionUID = 5762347331284295996L;

    public TvShowReadEpisodeNfoAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshowepisode.readnfo"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshowepisode.readnfo.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<TvShowEpisode> selectedEpisodes = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        if (selectedEpisodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("tvshowepisode.readnfo"), selectedEpisodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (TvShowEpisode episode : selectedEpisodes) {
                    TvShowEpisode tempEpisode = null;
                    for (MediaFile mf : episode.getMediaFiles(MediaFileType.NFO)) {
                        List<TvShowEpisode> episodesFromNfo2;
                        if (tempEpisode == null) {
                            try {
                                episodesFromNfo2 = TvShowEpisodeNfoParser.parseNfo(mf.getFileAsPath()).toTvShowEpisodes();
                                for (TvShowEpisode ep : episodesFromNfo2) {
                                    if (episode.getSeason() != ep.getSeason() || episode.getEpisode() != ep.getEpisode()) continue;
                                    tempEpisode = ep;
                                }
                            }
                            catch (Exception episodesFromNfo2) {}
                            continue;
                        }
                        if (tempEpisode == null) continue;
                        try {
                            episodesFromNfo2 = TvShowEpisodeNfoParser.parseNfo(mf.getFileAsPath()).toTvShowEpisodes();
                            for (TvShowEpisode ep : episodesFromNfo2) {
                                if (episode.getSeason() != ep.getSeason() || episode.getEpisode() != ep.getEpisode()) continue;
                                tempEpisode.merge(ep);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (tempEpisode != null) {
                        episode.forceMerge(tempEpisode);
                        episode.saveToDb();
                    }
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

