/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.connector.TvShowNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowReadNfoAction
extends TmmAction {
    private static final long serialVersionUID = -6575156436788397648L;

    public TvShowReadNfoAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.readnfo"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.readnfo.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShowsRecursive();
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("tvshow.rewritenfo"), selectedTvShows.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (TvShow tvShow : selectedTvShows) {
                    TvShow tempTvShow = null;
                    for (MediaFile mf : tvShow.getMediaFiles(MediaFileType.NFO)) {
                        if (tempTvShow == null) {
                            try {
                                tempTvShow = TvShowNfoParser.parseNfo(mf.getFileAsPath()).toTvShow();
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (tempTvShow == null) continue;
                        try {
                            tempTvShow.merge(TvShowNfoParser.parseNfo(mf.getFileAsPath()).toTvShow());
                        }
                        catch (Exception exception) {}
                    }
                    if (tempTvShow != null) {
                        tvShow.forceMerge(tempTvShow);
                        tvShow.saveToDb();
                    }
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

