/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRemoveAction
extends TmmAction {
    private static final long serialVersionUID = -2355545751433709417L;

    public TvShowRemoveAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.remove"));
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.remove"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        if (Boolean.FALSE.equals(TmmProperties.getInstance().getPropertyAsBoolean("tvshow.hideremovehint"))) {
            JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)checkBox, TmmFontHelper.L1);
            checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            Object[] params = new Object[]{TmmResourceBundle.getString("tvshow.remove.desc"), checkBox};
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("tvshow.remove"), 0, 3, null, options, null);
            if (checkBox.isSelected()) {
                TmmProperties.getInstance().putProperty("tvshow.hideremovehint", String.valueOf(checkBox.isSelected()));
            }
            if (answer != 0) {
                return;
            }
        }
        TmmTaskManager.getInstance().addUnnamedTask(() -> {
            for (Object obj : selectedObjects) {
                if (obj instanceof TvShow) {
                    TvShow tvShow = (TvShow)obj;
                    TvShowModuleManager.getInstance().getTvShowList().removeTvShow(tvShow);
                }
                if (obj instanceof TvShowSeason) {
                    TvShowSeason season = (TvShowSeason)obj;
                    ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(season.getEpisodes());
                    for (TvShowEpisode episode : episodes) {
                        season.getTvShow().removeEpisode(episode);
                    }
                }
                if (!(obj instanceof TvShowEpisode)) continue;
                TvShowEpisode tvShowEpisode = (TvShowEpisode)obj;
                tvShowEpisode.getTvShow().removeEpisode(tvShowEpisode);
            }
        });
    }
}

