/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowSubtitleSearchAndDownloadTask;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowDownloadSubtitleDialog;

public class TvShowSubtitleDownloadAction
extends TmmAction {
    private static final long serialVersionUID = -6002932119900795735L;

    public TvShowSubtitleDownloadAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.download.subtitle"));
        this.putValue("SmallIcon", IconManager.SUBTITLE);
        this.putValue("SwingLargeIconKey", IconManager.SUBTITLE);
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.download.subtitle"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, 640));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShowEpisode> episodes = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        if (episodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TvShowDownloadSubtitleDialog dialog = new TvShowDownloadSubtitleDialog(TmmResourceBundle.getString("tvshow.download.subtitle"));
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.setVisible(true);
        if (dialog.shouldStartDownload()) {
            for (MediaLanguages language : dialog.getLanguages()) {
                TvShowSubtitleSearchAndDownloadTask task = new TvShowSubtitleSearchAndDownloadTask(episodes, dialog.getSubtitleScrapers(), language);
                task.setForceBestMatch(dialog.isForceBestMatch());
                TmmTaskManager.getInstance().addMainTask(task);
            }
        }
    }
}

