/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowSyncSelectedTraktTvAction
extends TmmAction {
    private static final long serialVersionUID = 6640292090443882545L;

    public TvShowSyncSelectedTraktTvAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.synctrakt.selected"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.synctrakt.selected.desc"));
        this.putValue("SmallIcon", IconManager.SYNC);
        this.putValue("SwingLargeIconKey", IconManager.SYNC);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShowsRecursive();
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TvShowSyncTraktTvTask task = new TvShowSyncTraktTvTask(selectedTvShows);
        task.setSyncCollection(true);
        task.setSyncWatched(true);
        task.setSyncRating(true);
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

