/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowToggleWatchedFlagAction
extends TmmAction {
    private static final long serialVersionUID = 5762347331284295996L;

    public TvShowToggleWatchedFlagAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshowepisode.togglewatchedflag"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShowEpisode> selectedEpisodes = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        if (selectedEpisodes.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        for (TvShowEpisode episode : selectedEpisodes) {
            episode.setWatched(!episode.isWatched());
            episode.writeNFO();
            episode.saveToDb();
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

