/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.tasks.TvShowChangeDatasourceTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowChangeDatasourceDialog
extends TmmDialog {
    private static final long serialVersionUID = -1515243604267310274L;
    private List<TvShow> tvShowsToEdit = new ArrayList<TvShow>();
    private JComboBox<String> cbDatasource;

    public TvShowChangeDatasourceDialog(List<TvShow> tvShows) {
        super(TmmResourceBundle.getString("tvshow.changedatasource"), "tvShowDatasourceEditor");
        this.tvShowsToEdit.addAll(tvShows);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][300lp,grow]", "[][20lp][][20lp]"));
        ReadOnlyTextArea textArea = new ReadOnlyTextArea(TmmResourceBundle.getString("changedatasource.hint.tvshow"));
        panelContent.add((Component)textArea, "cell 0 0 2 1,grow");
        TmmLabel lblDatasourceT = new TmmLabel(TmmResourceBundle.getString("changedatasource.newdatasource"));
        panelContent.add((Component)lblDatasourceT, "cell 0 2");
        this.cbDatasource = new JComboBox<Object>(TvShowModuleManager.getInstance().getSettings().getTvShowDataSource().toArray());
        panelContent.add(this.cbDatasource, "cell 1 2,growx,wmin 0");
        JButton cancelButton = new JButton(new DiscardAction());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new ChangeDatasourceAction());
        this.addDefaultButton(okButton);
    }

    private class DiscardAction
    extends AbstractAction {
        private static final long serialVersionUID = -5581329896797961536L;

        private DiscardAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowChangeDatasourceDialog.this.setVisible(false);
        }
    }

    private class ChangeDatasourceAction
    extends AbstractAction {
        private static final long serialVersionUID = -3767744690599233490L;

        private ChangeDatasourceAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.ok"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.changedatasource"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newDatasource = (String)TvShowChangeDatasourceDialog.this.cbDatasource.getSelectedItem();
            if (StringUtils.isNotBlank((CharSequence)newDatasource)) {
                TvShowChangeDatasourceTask task = new TvShowChangeDatasourceTask(TvShowChangeDatasourceDialog.this.tvShowsToEdit, newDatasource);
                TmmTaskManager.getInstance().addMainTask(task);
            }
            TvShowChangeDatasourceDialog.this.setVisible(false);
        }
    }
}

