/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperComboBox;
import org.tinymediamanager.ui.components.combobox.ScraperMetadataConfigCheckComboBox;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.renderer.BorderTableCellRenderer;
import org.tinymediamanager.ui.tvshows.TvShowChooserModel;

public class TvShowChooserDialog
extends TmmDialog
implements ActionListener {
    private static final long serialVersionUID = 2371518113606870230L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowChooserDialog.class);
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final List<MediaScraper> artworkScrapers;
    private final List<MediaScraper> trailerScrapers;
    private TvShow tvShowToScrape;
    private SortedList<TvShowChooserModel> searchResultEventList = null;
    private TvShowChooserModel selectedResult = null;
    private MediaScraper mediaScraper = this.tvShowList.getDefaultMediaScraper();
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private SearchTask activeSearchTask;
    private final MediaScraperComboBox cbScraper;
    private final JComboBox<MediaLanguages> cbLanguage;
    private final TmmTable tableSearchResults;
    private final JLabel lblTtitle;
    private final JTextArea taOverview;
    private final ImageLabel lblTvShowPoster;
    private final JLabel lblProgressAction;
    private final JLabel lblError;
    private final JProgressBar progressBar;
    private final JButton okButton;
    private final JLabel lblPath;
    private final JLabel lblOriginalTitle;
    private final ScraperMetadataConfigCheckComboBox<TvShowScraperMetadataConfig> cbTvShowScraperConfig;
    private final ScraperMetadataConfigCheckComboBox<TvShowEpisodeScraperMetadataConfig> cbEpisodeScraperConfig;
    private final JHintCheckBox chckbxDoNotOverwrite;
    private JTextField textFieldSearchString;

    public TvShowChooserDialog(TvShow tvShow, int queueIndex, int queueSize) {
        super(TmmResourceBundle.getString("tvshowchooser.search") + (String)(queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : ""), "tvShowChooser");
        this.artworkScrapers = this.tvShowList.getDefaultArtworkScrapers();
        this.trailerScrapers = this.tvShowList.getDefaultTrailerScrapers();
        this.searchResultEventList = new SortedList((EventList)new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(TvShowChooserModel.class)), (Comparator)new SearchResultScoreComparator());
        TmmTableModel<TvShowChooserModel> searchResultTableModel = new TmmTableModel<TvShowChooserModel>((EventList<TvShowChooserModel>)this.searchResultEventList, new SearchResultTableFormat());
        JPanel panelPath = new JPanel();
        panelPath.setLayout((LayoutManager)new MigLayout("", "[grow][]", "[]"));
        this.lblPath = new JLabel("");
        TmmFontHelper.changeFont(this.lblPath, 1.16667, 1);
        panelPath.add((Component)this.lblPath, "cell 0 0, growx, wmin 0");
        SquareIconButton btnPlay = new SquareIconButton(IconManager.FILE_OPEN_INV);
        btnPlay.setFocusable(false);
        btnPlay.addActionListener(e -> {
            try {
                TmmUIHelper.openFile(this.tvShowToScrape.getPathNIO());
            }
            catch (Exception ex) {
                LOGGER.error("open file", (Throwable)ex);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShowToScrape.getPathNIO(), "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        panelPath.add((Component)btnPlay, "cell 1 0");
        this.setTopIformationPanel(panelPath);
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[600lp:900lp,grow]", "[][shrink 0][250lp:300lp,grow][shrink 0][]"));
        JPanel panelSearchField = new JPanel();
        contentPanel.add((Component)panelSearchField, "cell 0 0,grow");
        panelSearchField.setLayout((LayoutManager)new MigLayout("", "[][][grow][]", "[23px][]"));
        TmmLabel lblScraper = new TmmLabel(TmmResourceBundle.getString("scraper"));
        panelSearchField.add((Component)lblScraper, "cell 0 0,alignx right");
        this.cbScraper = new MediaScraperComboBox(this.tvShowList.getAvailableMediaScrapers());
        MediaScraper defaultScraper = this.tvShowList.getDefaultMediaScraper();
        if (defaultScraper != null && defaultScraper.isEnabled()) {
            this.cbScraper.setSelectedItem(defaultScraper);
        }
        this.cbScraper.setAction(new ChangeScraperAction());
        panelSearchField.add((Component)this.cbScraper, "cell 1 0,growx");
        ActionListener searchAction = arg0 -> this.searchTvShow(this.textFieldSearchString.getText(), false);
        this.textFieldSearchString = new EnhancedTextField(TmmResourceBundle.getString("tvshowchooser.search.hint"));
        this.textFieldSearchString.setToolTipText(TmmResourceBundle.getString("tvshowchooser.search.hint"));
        this.textFieldSearchString.addActionListener(searchAction);
        panelSearchField.add((Component)this.textFieldSearchString, "cell 2 0,growx");
        this.textFieldSearchString.setColumns(10);
        JButton btnSearch = new JButton(TmmResourceBundle.getString("Button.search"));
        btnSearch.setIcon(IconManager.SEARCH_INV);
        panelSearchField.add((Component)btnSearch, "cell 3 0");
        btnSearch.addActionListener(searchAction);
        this.getRootPane().setDefaultButton(btnSearch);
        TmmLabel lblLanguage = new TmmLabel("Language");
        panelSearchField.add((Component)lblLanguage, "cell 0 1,alignx right");
        this.cbLanguage = new JComboBox();
        this.cbLanguage.setModel(new DefaultComboBoxModel<MediaLanguages>(MediaLanguages.valuesSorted()));
        this.cbLanguage.setSelectedItem((Object)TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
        this.cbLanguage.addActionListener(e -> this.searchTvShow(this.textFieldSearchString.getText(), false));
        panelSearchField.add(this.cbLanguage, "cell 1 1,growx");
        JSeparator separator = new JSeparator();
        contentPanel.add((Component)separator, "cell 0 1,growx");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setName(this.getName() + ".splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        contentPanel.add((Component)splitPane, "cell 0 2,grow");
        JPanel panelSearchResults = new JPanel();
        splitPane.setLeftComponent(panelSearchResults);
        panelSearchResults.setLayout((LayoutManager)new MigLayout("", "[200lp:300lp,grow]", "[150lp:300lp,grow]"));
        JScrollPane scrollPane = new JScrollPane();
        panelSearchResults.add((Component)scrollPane, "cell 0 0,grow");
        this.tableSearchResults = new TmmTable((TableModel)((Object)searchResultTableModel));
        this.tableSearchResults.configureScrollPane(scrollPane);
        JPanel panelSearchDetail = new JPanel();
        splitPane.setRightComponent(panelSearchDetail);
        panelSearchDetail.setLayout((LayoutManager)new MigLayout("", "[150lp:15%:25%,grow][300lp:500lp,grow 3]", "[][][150lp:200lp,grow]"));
        this.lblTtitle = new JLabel("");
        TmmFontHelper.changeFont(this.lblTtitle, 1.166, 1);
        panelSearchDetail.add((Component)this.lblTtitle, "cell 1 0,wmin 0");
        this.lblTvShowPoster = new ImageLabel(false);
        this.lblTvShowPoster.setDesiredAspectRatio(0.6666667f);
        panelSearchDetail.add((Component)this.lblTvShowPoster, "cell 0 0 1 3,grow");
        this.lblOriginalTitle = new JLabel("");
        panelSearchDetail.add((Component)this.lblOriginalTitle, "cell 1 1,wmin 0");
        scrollPane = new NoBorderScrollPane();
        panelSearchDetail.add((Component)scrollPane, "cell 1 2,grow");
        this.taOverview = new ReadOnlyTextArea();
        scrollPane.setViewportView(this.taOverview);
        separator = new JSeparator();
        contentPanel.add((Component)separator, "cell 0 3,growx");
        JPanel panelScraperConfig = new JPanel();
        contentPanel.add((Component)panelScraperConfig, "cell 0 4,grow");
        panelScraperConfig.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][]"));
        TmmLabel lblScrapeFollowingItems = new TmmLabel(TmmResourceBundle.getString("chooser.scrape"));
        panelScraperConfig.add((Component)lblScrapeFollowingItems, "cell 0 0 2 1");
        TmmLabel lblTvShowsT = new TmmLabel(TmmResourceBundle.getString("metatag.tvshows"));
        panelScraperConfig.add((Component)lblTvShowsT, "cell 0 1,alignx trailing");
        this.cbTvShowScraperConfig = new ScraperMetadataConfigCheckComboBox<TvShowScraperMetadataConfig>(TvShowScraperMetadataConfig.getValuesWithout(TvShowScraperMetadataConfig.ID));
        this.cbTvShowScraperConfig.enableFilter((movieScraperMetadataConfig, s) -> movieScraperMetadataConfig.getDescription().toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT)));
        panelScraperConfig.add(this.cbTvShowScraperConfig, "cell 1 1,grow, wmin 0");
        TmmLabel lblEpisodesT = new TmmLabel(TmmResourceBundle.getString("metatag.episodes"));
        panelScraperConfig.add((Component)lblEpisodesT, "cell 0 2,alignx trailing");
        this.cbEpisodeScraperConfig = new ScraperMetadataConfigCheckComboBox<TvShowEpisodeScraperMetadataConfig>(TvShowEpisodeScraperMetadataConfig.getValues());
        this.cbEpisodeScraperConfig.enableFilter((movieScraperMetadataConfig, s) -> movieScraperMetadataConfig.getDescription().toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT)));
        panelScraperConfig.add(this.cbEpisodeScraperConfig, "cell 1 2,grow, wmin 0");
        this.chckbxDoNotOverwrite = new JHintCheckBox(TmmResourceBundle.getString("message.scrape.donotoverwrite"));
        this.chckbxDoNotOverwrite.setToolTipText(TmmResourceBundle.getString("message.scrape.donotoverwrite.desc"));
        this.chckbxDoNotOverwrite.setHintIcon(IconManager.HINT);
        panelScraperConfig.add((Component)this.chckbxDoNotOverwrite, "cell 0 3 2 1");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0");
        this.lblError = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblError, 1);
        this.lblError.setForeground(Color.RED);
        infoPanel.add((Component)this.lblError, "cell 1 0");
        this.setBottomInformationPanel(infoPanel);
        if (queueSize > 1) {
            JButton abortButton = new JButton(TmmResourceBundle.getString("Button.abortqueue"));
            abortButton.setActionCommand("Abort");
            abortButton.addActionListener(this);
            abortButton.setIcon(IconManager.STOP_INV);
            this.addButton(abortButton);
            if (queueIndex > 0) {
                JButton backButton = new JButton(TmmResourceBundle.getString("Button.back"));
                backButton.setIcon(IconManager.BACK_INV);
                backButton.setActionCommand("Back");
                backButton.addActionListener(this);
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(TmmResourceBundle.getString("Button.cancel"));
        cancelButton.setActionCommand("Cancel");
        cancelButton.setIcon(IconManager.CANCEL_INV);
        cancelButton.addActionListener(this);
        this.addButton(cancelButton);
        this.okButton = new JButton(TmmResourceBundle.getString("Button.ok"));
        this.okButton.setActionCommand("OK");
        this.okButton.setIcon(IconManager.APPLY_INV);
        this.okButton.addActionListener(this);
        this.addDefaultButton(this.okButton);
        TableComparatorChooser.install((JTable)this.tableSearchResults, this.searchResultEventList, (Object)TableComparatorChooser.SINGLE_COLUMN);
        this.tableSearchResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && !e.isConsumed() && e.getButton() == 1 && TvShowChooserDialog.this.okButton.isEnabled()) {
                    TvShowChooserDialog.this.actionPerformed(new ActionEvent(TvShowChooserDialog.this.okButton, 1001, "OK"));
                }
            }
        });
        PropertyChangeListener listener = evt -> {
            int row;
            String property = evt.getPropertyName();
            if ("scraped".equals(property) && (row = this.tableSearchResults.convertRowIndexToModel(this.tableSearchResults.getSelectedRow())) > -1) {
                TvShowChooserModel model = (TvShowChooserModel)this.searchResultEventList.get(row);
                this.lblOriginalTitle.setText(model.getOriginalTitle());
                if (!model.getPosterUrl().equals(this.lblTvShowPoster.getImageUrl())) {
                    this.lblTvShowPoster.setImageUrl(model.getPosterUrl());
                }
                this.taOverview.setText(model.getOverview());
            }
        };
        this.tableSearchResults.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int index = this.tableSearchResults.convertRowIndexToModel(this.tableSearchResults.getSelectedRow());
            if (this.selectedResult != null) {
                this.selectedResult.removePropertyChangeListener(listener);
            }
            if (index > -1 && index < this.searchResultEventList.size()) {
                TvShowChooserModel model = (TvShowChooserModel)this.searchResultEventList.get(index);
                this.lblTvShowPoster.setImageUrl(model.getPosterUrl());
                this.lblTtitle.setText(model.getCombinedName());
                this.lblOriginalTitle.setText(model.getOriginalTitle());
                this.taOverview.setText(model.getOverview());
                this.selectedResult = model;
                this.selectedResult.addPropertyChangeListener(listener);
            } else {
                this.selectedResult = null;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                selectedRow = this.tableSearchResults.convertRowIndexToModel(selectedRow);
                try {
                    TvShowChooserModel model = (TvShowChooserModel)this.searchResultEventList.get(selectedRow);
                    if (model != TvShowChooserModel.emptyResult && !model.isScraped()) {
                        ScrapeTask task = new ScrapeTask(model);
                        task.execute();
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn(ex.getMessage());
                }
            }
        });
        this.tvShowToScrape = tvShow;
        this.progressBar.setVisible(false);
        this.cbTvShowScraperConfig.setSelectedItems(TvShowModuleManager.getInstance().getSettings().getTvShowScraperMetadataConfig());
        this.cbEpisodeScraperConfig.setSelectedItems(TvShowModuleManager.getInstance().getSettings().getEpisodeScraperMetadataConfig());
        this.chckbxDoNotOverwrite.setSelected(TvShowModuleManager.getInstance().getSettings().isDoNotOverwriteExistingData());
        this.lblPath.setText(this.tvShowToScrape.getPathNIO().toString());
        this.textFieldSearchString.setText(this.tvShowToScrape.getTitle());
        this.searchTvShow(this.textFieldSearchString.getText(), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TvShowChooserModel model;
        int row;
        if ("OK".equals(e.getActionCommand()) && (row = this.tableSearchResults.getSelectedRow()) >= 0 && (model = (TvShowChooserModel)this.searchResultEventList.get(row)) != TvShowChooserModel.emptyResult) {
            List<TvShowEpisode> episodesToScrape;
            if (!model.isScraped()) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "TvShowChooser", "message.scrape.threadcrashed"));
                return;
            }
            List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig = this.cbTvShowScraperConfig.getSelectedItems();
            List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = this.cbEpisodeScraperConfig.getSelectedItems();
            boolean overwrite = !this.chckbxDoNotOverwrite.isSelected();
            MediaMetadata md = model.getMetadata();
            if (StringUtils.isBlank((CharSequence)md.getTitle())) {
                md.setTitle(model.getTitle());
            }
            if (!TvShowModuleManager.getInstance().getSettings().isScrapeBestImage()) {
                md.clearMediaArt();
            }
            this.tvShowToScrape.setMetadata(md, tvShowScraperMetadataConfig, overwrite);
            this.tvShowToScrape.setLastScraperId(model.getMediaScraper().getId());
            this.tvShowToScrape.setLastScrapeLanguage(model.getLanguage().name());
            if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) {
                this.tvShowToScrape.setDummyEpisodes(model.getEpisodesForDisplay());
                this.tvShowToScrape.saveToDb();
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (ScraperMetadataConfig.containsAnyArtwork(tvShowScraperMetadataConfig)) {
                if (!TvShowModuleManager.getInstance().getSettings().isScrapeBestImage()) {
                    if (tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.POSTER) && (overwrite || StringUtils.isBlank((CharSequence)this.tvShowToScrape.getArtworkFilename(MediaFileType.POSTER)))) {
                        this.chooseArtwork(MediaFileType.POSTER);
                    }
                    if (tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.FANART) && (overwrite || StringUtils.isBlank((CharSequence)this.tvShowToScrape.getArtworkFilename(MediaFileType.FANART)))) {
                        this.chooseArtwork(MediaFileType.FANART);
                    }
                    if (tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.BANNER) && (overwrite || StringUtils.isBlank((CharSequence)this.tvShowToScrape.getArtworkFilename(MediaFileType.BANNER)))) {
                        this.chooseArtwork(MediaFileType.BANNER);
                    }
                    if (tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.LOGO) && (overwrite || StringUtils.isBlank((CharSequence)this.tvShowToScrape.getArtworkFilename(MediaFileType.LOGO)))) {
                        this.chooseArtwork(MediaFileType.LOGO);
                    }
                    if (tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.CLEARLOGO) && (overwrite || StringUtils.isBlank((CharSequence)this.tvShowToScrape.getArtworkFilename(MediaFileType.CLEARLOGO)))) {
                        this.chooseArtwork(MediaFileType.CLEARLOGO);
                    }
                    if (tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.CLEARART) && (overwrite || StringUtils.isBlank((CharSequence)this.tvShowToScrape.getArtworkFilename(MediaFileType.CLEARART)))) {
                        this.chooseArtwork(MediaFileType.CLEARART);
                    }
                    if (tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.THUMB) && (overwrite || StringUtils.isBlank((CharSequence)this.tvShowToScrape.getArtworkFilename(MediaFileType.THUMB)))) {
                        this.chooseArtwork(MediaFileType.THUMB);
                    }
                    if (tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.CHARACTERART) && (overwrite || StringUtils.isBlank((CharSequence)this.tvShowToScrape.getArtworkFilename(MediaFileType.CHARACTERART)))) {
                        this.chooseArtwork(MediaFileType.CHARACTERART);
                    }
                    if (tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.KEYART) && (overwrite || StringUtils.isBlank((CharSequence)this.tvShowToScrape.getArtworkFilename(MediaFileType.KEYART)))) {
                        this.chooseArtwork(MediaFileType.KEYART);
                    }
                } else {
                    model.startArtworkScrapeTask(this.tvShowToScrape, tvShowScraperMetadataConfig, overwrite);
                }
            }
            if (!episodeScraperMetadataConfig.isEmpty() && !(episodesToScrape = this.tvShowToScrape.getEpisodesToScrape()).isEmpty()) {
                TvShowEpisodeSearchAndScrapeOptions scrapeOptions = new TvShowEpisodeSearchAndScrapeOptions(md.getIds());
                scrapeOptions.setMetadataScraper(model.getMediaScraper());
                scrapeOptions.setArtworkScraper(model.getArtworkScrapers());
                scrapeOptions.setLanguage(model.getLanguage());
                TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask(episodesToScrape, scrapeOptions, episodeScraperMetadataConfig, overwrite);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            if (tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.TRAILER)) {
                model.startTrailerScrapeTask(this.tvShowToScrape, overwrite);
            }
            if (tvShowScraperMetadataConfig.contains(TvShowScraperMetadataConfig.THEME)) {
                model.startThemeDownloadTask(this.tvShowToScrape, overwrite);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (TvShowModuleManager.getInstance().getSettings().getSyncTrakt()) {
                TvShowSyncTraktTvTask task = new TvShowSyncTraktTvTask(Collections.singletonList(this.tvShowToScrape));
                task.setSyncCollection(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
                task.setSyncWatched(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
                task.setSyncRating(TvShowModuleManager.getInstance().getSettings().getSyncTraktRating());
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            this.setVisible(false);
        }
        if ("Cancel".equals(e.getActionCommand())) {
            this.setVisible(false);
        }
        if ("Abort".equals(e.getActionCommand())) {
            this.continueQueue = false;
            this.setVisible(false);
        }
        if ("Back".equals(e.getActionCommand())) {
            this.navigateBack = true;
            this.setVisible(false);
        }
    }

    private void chooseArtwork(MediaFileType mediaFileType) {
        MediaArtwork.MediaArtworkType imageType;
        ArrayList<String> extrafanarts = null;
        switch (mediaFileType) {
            case POSTER: {
                if (TvShowModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.POSTER;
                break;
            }
            case FANART: {
                if (TvShowModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.BACKGROUND;
                extrafanarts = new ArrayList<String>();
                break;
            }
            case BANNER: {
                if (TvShowModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.BANNER;
                break;
            }
            case LOGO: {
                if (TvShowModuleManager.getInstance().getSettings().getLogoFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.LOGO;
                break;
            }
            case CLEARLOGO: {
                if (TvShowModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.CLEARLOGO;
                break;
            }
            case CLEARART: {
                if (TvShowModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.CLEARART;
                break;
            }
            case CHARACTERART: {
                if (TvShowModuleManager.getInstance().getSettings().getCharacterartFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.CHARACTERART;
                break;
            }
            case THUMB: {
                if (TvShowModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.THUMB;
                break;
            }
            case KEYART: {
                if (TvShowModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty()) {
                    return;
                }
                imageType = MediaArtwork.MediaArtworkType.KEYART;
                break;
            }
            default: {
                return;
            }
        }
        String imageUrl = ImageChooserDialog.chooseImage(this, this.tvShowToScrape.getIds(), imageType, this.artworkScrapers, null, extrafanarts, MediaType.TV_SHOW, this.tvShowToScrape.getPathNIO().toAbsolutePath().toString());
        this.tvShowToScrape.setArtworkUrl(imageUrl, mediaFileType);
        if (StringUtils.isNotBlank((CharSequence)imageUrl)) {
            this.tvShowToScrape.downloadArtwork(mediaFileType);
        }
        if (mediaFileType == MediaFileType.FANART && extrafanarts != null) {
            this.tvShowToScrape.setExtraFanartUrls(extrafanarts);
            if (!extrafanarts.isEmpty()) {
                this.tvShowToScrape.downloadArtwork(MediaFileType.EXTRAFANART);
            }
        }
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    private void searchTvShow(String searchTerm, boolean withIds) {
        if (this.activeSearchTask != null && !this.activeSearchTask.isDone()) {
            this.activeSearchTask.cancel();
        }
        this.activeSearchTask = new SearchTask(searchTerm, this.tvShowToScrape, withIds);
        SwingUtilities.invokeLater(this.activeSearchTask::execute);
    }

    private void startProgressBar(String description) {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText(description);
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
            this.lblError.setText("");
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText("");
            this.progressBar.setVisible(false);
            this.progressBar.setIndeterminate(false);
        });
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    public static class SearchResultRenderer
    extends BorderTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof TvShowChooserModel) {
                TvShowChooserModel result = (TvShowChooserModel)value;
                return super.getTableCellRendererComponent(table, result.getTitle(), isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class SearchResultTitleComparator
    implements Comparator<TvShowChooserModel> {
        private Collator stringCollator;

        private SearchResultTitleComparator() {
            RuleBasedCollator defaultCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();
            try {
                this.stringCollator = new RuleBasedCollator(defaultCollator.getRules().replace("<'_'", "<' '<'_'"));
            }
            catch (Exception e) {
                this.stringCollator = defaultCollator;
            }
        }

        @Override
        public int compare(TvShowChooserModel o1, TvShowChooserModel o2) {
            if (this.stringCollator != null) {
                String titleTvShow1 = StrgUtils.normalizeString(o1.getTitle().toLowerCase(Locale.ROOT));
                String titleTvShow2 = StrgUtils.normalizeString(o2.getTitle().toLowerCase(Locale.ROOT));
                return this.stringCollator.compare(titleTvShow1, titleTvShow2);
            }
            return o1.getTitle().toLowerCase(Locale.ROOT).compareTo(o2.getTitle().toLowerCase(Locale.ROOT));
        }
    }

    private static class SearchResultScoreComparator
    implements Comparator<TvShowChooserModel> {
        private SearchResultScoreComparator() {
        }

        @Override
        public int compare(TvShowChooserModel o1, TvShowChooserModel o2) {
            return Float.compare(o2.getScore(), o1.getScore());
        }
    }

    private static class SearchResultTableFormat
    extends TmmTableFormat<TvShowChooserModel> {
        private SearchResultTableFormat() {
            SearchResultTitleComparator searchResultComparator = new SearchResultTitleComparator();
            TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
            FontMetrics fontMetrics = this.getFontMetrics();
            TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("chooser.searchresult"), "title", result -> result, TvShowChooserModel.class);
            col.setColumnComparator(searchResultComparator);
            col.setCellRenderer(new SearchResultRenderer());
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.year"), "year", TvShowChooserModel::getYear, String.class);
            col.setColumnComparator(stringComparator);
            col.setColumnResizeable(false);
            col.setMinWidth((int)((float)fontMetrics.stringWidth("2000") * 1.2f));
            col.setMaxWidth((int)((float)fontMetrics.stringWidth("2000") * 1.4f));
            this.addColumn(col);
        }
    }

    private class ChangeScraperAction
    extends AbstractAction {
        private static final long serialVersionUID = -3537728352474538431L;

        ChangeScraperAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowChooserDialog.this.mediaScraper = (MediaScraper)TvShowChooserDialog.this.cbScraper.getSelectedItem();
            TvShowChooserDialog.this.searchTvShow(TvShowChooserDialog.this.textFieldSearchString.getText(), false);
        }
    }

    private class ScrapeTask
    extends SwingWorker<Void, Void> {
        private final TvShowChooserModel model;

        private ScrapeTask(TvShowChooserModel model) {
            this.model = model;
        }

        @Override
        public Void doInBackground() {
            TvShowChooserDialog.this.startProgressBar(TmmResourceBundle.getString("chooser.scrapeing") + " " + this.model.getTitle());
            TvShowChooserDialog.this.okButton.setEnabled(false);
            this.model.scrapeMetaData();
            TvShowChooserDialog.this.okButton.setEnabled(true);
            return null;
        }

        @Override
        public void done() {
            TvShowChooserDialog.this.stopProgressBar();
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private final String searchTerm;
        private final TvShow show;
        private final boolean withIds;
        private final MediaLanguages language;
        private List<MediaSearchResult> searchResult;
        private Throwable error = null;
        boolean cancel = false;

        private SearchTask(String searchTerm, TvShow show, boolean withIds) {
            this.searchTerm = searchTerm;
            this.show = show;
            this.withIds = withIds;
            this.language = (MediaLanguages)((Object)TvShowChooserDialog.this.cbLanguage.getSelectedItem());
        }

        @Override
        public Void doInBackground() {
            TvShowChooserDialog.this.startProgressBar(TmmResourceBundle.getString("chooser.searchingfor") + " " + this.searchTerm);
            try {
                this.searchResult = TvShowChooserDialog.this.tvShowList.searchTvShow(this.searchTerm, this.show.getYear(), this.withIds ? this.show.getIds() : null, TvShowChooserDialog.this.mediaScraper, this.language);
            }
            catch (Exception e) {
                this.error = e;
            }
            return null;
        }

        public void cancel() {
            this.cancel = true;
            super.cancel(true);
        }

        @Override
        public void done() {
            TvShowChooserDialog.this.stopProgressBar();
            TvShowChooserDialog.this.searchResultEventList.clear();
            if (this.error != null) {
                TvShowChooserDialog.this.searchResultEventList.add((Object)TvShowChooserModel.emptyResult);
                SwingUtilities.invokeLater(() -> TvShowChooserDialog.this.lblError.setText(this.error.getMessage()));
            } else if (!this.cancel) {
                if (ListUtils.isEmpty(this.searchResult)) {
                    TvShowChooserDialog.this.searchResultEventList.add((Object)TvShowChooserModel.emptyResult);
                } else {
                    MediaScraper mpFromResult = null;
                    for (MediaSearchResult result : this.searchResult) {
                        if (mpFromResult == null) {
                            mpFromResult = TvShowChooserDialog.this.tvShowList.getMediaScraperById(result.getProviderId());
                        }
                        TvShowChooserDialog.this.searchResultEventList.add((Object)new TvShowChooserModel(mpFromResult, TvShowChooserDialog.this.artworkScrapers, TvShowChooserDialog.this.trailerScrapers, result, this.language));
                    }
                }
            }
            if (!TvShowChooserDialog.this.searchResultEventList.isEmpty()) {
                TvShowChooserDialog.this.tableSearchResults.setRowSelectionInterval(0, 0);
            }
        }
    }
}

