/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiTvShowMetadataProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.MediaIdTable;
import org.tinymediamanager.ui.components.MediaRatingTable;
import org.tinymediamanager.ui.components.PersonTable;
import org.tinymediamanager.ui.components.SquareIconButton;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.TmmTabbedPane;
import org.tinymediamanager.ui.components.combobox.AutoCompleteSupport;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.combobox.MediaScraperComboBox;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.IdEditorDialog;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.PersonEditorDialog;
import org.tinymediamanager.ui.dialogs.RatingEditorDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.panels.MediaFileEditorPanel;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowEpisodeChooserDialog;

public class TvShowEpisodeEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 7702248909791283043L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeEditorDialog.class);
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private static final String DIALOG_ID = "tvShowEpisodeEditor";
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
    private final TvShowEpisode episodeToEdit;
    private final List<String> tags = ObservableCollections.observableList(new ArrayList());
    private final List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    private final int queueIndex;
    private final int queueSize;
    private final EventList<MediaIdTable.MediaId> ids;
    private final EventList<MediaRatingTable.Rating> ratings;
    private final EventList<Person> guests = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
    private final EventList<Person> directors = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
    private final EventList<Person> writers = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private JTextField tfTitle;
    private JSpinner spEpisode;
    private JSpinner spSeason;
    private JSpinner spRating;
    private JSpinner spDvdSeason;
    private JSpinner spDvdEpisode;
    private JCheckBox cbDvdOrder;
    private JSpinner spDisplaySeason;
    private JSpinner spDisplayEpisode;
    private DatePicker dpFirstAired;
    private JSpinner spDateAdded;
    private JCheckBox chckbxWatched;
    private ImageLabel lblThumb;
    private JTextArea taPlot;
    private AutocompleteComboBox<String> cbTags;
    private AutoCompleteSupport<String> cbTagsAutoCompleteSupport;
    private JList<String> listTags;
    private AutocompleteComboBox<MediaSource> cbMediaSource;
    private MediaFileEditorPanel mediaFilesPanel;
    private MediaScraperComboBox cbScraper;
    private TmmTable tableIds;
    private TmmTable tableRatings;
    private TmmTable tableGuests;
    private TmmTable tableDirectors;
    private TmmTable tableWriters;
    private JTextField tfOriginalTitle;
    private JTextField tfThumb;
    private JTextArea taNote;

    public TvShowEpisodeEditorDialog(TvShowEpisode episode, int queueIndex, int queueSize) {
        super(TmmResourceBundle.getString("tvshowepisode.edit") + "  < " + episode.getMainVideoFile().getFilename() + " >", DIALOG_ID);
        for (MediaFile mf : episode.getMediaFiles()) {
            this.mediaFiles.add(new MediaFile(mf));
        }
        this.episodeToEdit = episode;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.ids = MediaIdTable.convertIdMapToEventList(episode.getIds());
        this.ratings = GlazedLists.threadSafeList(MediaRatingTable.convertRatingMapToEventList(episode.getRatings(), false));
        MediaRating userMediaRating = this.episodeToEdit.getRating("user");
        this.initComponents();
        this.bindingGroup = this.initDataBindings();
        this.tfTitle.setText(this.episodeToEdit.getTitle());
        this.tfOriginalTitle.setText(this.episodeToEdit.getOriginalTitle());
        this.cbDvdOrder.setSelected(this.episodeToEdit.isDvdOrder());
        this.spSeason.setModel(new SpinnerNumberModel(this.episodeToEdit.getAiredSeason(), -1, 999999, 1));
        this.spEpisode.setModel(new SpinnerNumberModel(this.episodeToEdit.getAiredEpisode(), -1, 999999, 1));
        this.spDvdSeason.setModel(new SpinnerNumberModel(this.episodeToEdit.getDvdSeason(), -1, 999999, 1));
        this.spDvdEpisode.setModel(new SpinnerNumberModel(this.episodeToEdit.getDvdEpisode(), -1, 999999, 1));
        this.spDisplaySeason.setModel(new SpinnerNumberModel(this.episodeToEdit.getDisplaySeason(), -1, 999999, 1));
        this.spDisplayEpisode.setModel(new SpinnerNumberModel(this.episodeToEdit.getDisplayEpisode(), -1, 999999, 1));
        this.spDateAdded.setValue(this.episodeToEdit.getDateAdded());
        this.spRating.setModel(new SpinnerNumberModel(userMediaRating.getRating(), 0.0, 10.0, 0.1));
        this.lblThumb.setImagePath(this.episodeToEdit.getArtworkFilename(MediaFileType.THUMB));
        this.tfThumb.setText(this.episodeToEdit.getArtworkUrl(MediaFileType.THUMB));
        this.chckbxWatched.setSelected(this.episodeToEdit.isWatched());
        this.taPlot.setText(this.episodeToEdit.getPlot());
        this.taPlot.setCaretPosition(0);
        this.cbMediaSource.setSelectedItem(this.episodeToEdit.getMediaSource());
        this.taNote.setText(this.episodeToEdit.getNote());
        for (Person origCast : this.episodeToEdit.getActors()) {
            this.guests.add((Object)new Person(origCast));
        }
        for (Person director : this.episodeToEdit.getDirectors()) {
            this.directors.add((Object)new Person(director));
        }
        for (Person writer : this.episodeToEdit.getWriters()) {
            this.writers.add((Object)new Person(writer));
        }
        this.tags.addAll(this.episodeToEdit.getTags());
    }

    private void initComponents() {
        TmmTabbedPane tabbedPane = new TmmTabbedPane();
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel detailsPanel = new JPanel();
        tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), detailsPanel);
        detailsPanel.setLayout((LayoutManager)new MigLayout("", "[][20lp:75lp,grow][50lp:75lp][][60lp:75lp][50lp:75lp][20lp:n][][25lp:n][200lp:250lp,grow]", "[][][][][][][100lp:125lp:30%,grow][][][][100lp:15%:20%,grow][50lp:50lp:100lp,grow 50][]"));
        TmmLabel lblTitle = new TmmLabel(TmmResourceBundle.getString("metatag.title"));
        detailsPanel.add((Component)lblTitle, "cell 0 0,alignx right");
        this.tfTitle = new JTextField();
        detailsPanel.add((Component)this.tfTitle, "flowx,cell 1 0 7 1,growx");
        JButton btnPlay = new JButton(IconManager.PLAY_INV);
        btnPlay.setFocusable(false);
        btnPlay.addActionListener(e -> {
            MediaFile mf = this.episodeToEdit.getMainVideoFile();
            try {
                TmmUIHelper.openFile(MediaFileHelper.getMainVideoFile(mf));
            }
            catch (Exception ex) {
                LOGGER.error("open file - {}", (Object)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        detailsPanel.add((Component)btnPlay, "cell 1 0 7 1");
        TmmLabel lblOriginalTitleT = new TmmLabel(TmmResourceBundle.getString("metatag.originaltitle"));
        detailsPanel.add((Component)lblOriginalTitleT, "cell 0 1,alignx trailing");
        this.tfOriginalTitle = new JTextField();
        detailsPanel.add((Component)this.tfOriginalTitle, "cell 1 1 7 1,growx");
        TmmLabel lblSeason = new TmmLabel(TmmResourceBundle.getString("metatag.season"));
        detailsPanel.add((Component)lblSeason, "cell 0 2,alignx right");
        this.spSeason = new JSpinner();
        detailsPanel.add((Component)this.spSeason, "cell 1 2,growx");
        TmmLabel lblEpisode = new TmmLabel(TmmResourceBundle.getString("metatag.episode"));
        detailsPanel.add((Component)lblEpisode, "cell 3 2,alignx right");
        this.spEpisode = new JSpinner();
        detailsPanel.add((Component)this.spEpisode, "cell 4 2,growx");
        TmmLabel lblFirstAired = new TmmLabel(TmmResourceBundle.getString("metatag.aired"));
        detailsPanel.add((Component)lblFirstAired, "cell 0 3,alignx right");
        this.dpFirstAired = new DatePicker(this.episodeToEdit.getFirstAired());
        detailsPanel.add((Component)this.dpFirstAired, "cell 1 3 2 1,growx");
        TmmLabel lblDvdSeason = new TmmLabel(TmmResourceBundle.getString("metatag.dvdseason"));
        detailsPanel.add((Component)lblDvdSeason, "cell 0 4,alignx right,aligny center");
        this.spDvdSeason = new JSpinner();
        detailsPanel.add((Component)this.spDvdSeason, "cell 1 4,growx");
        TmmLabel lblDvdEpisode = new TmmLabel(TmmResourceBundle.getString("metatag.dvdepisode"));
        detailsPanel.add((Component)lblDvdEpisode, "cell 3 4,alignx right");
        this.spDvdEpisode = new JSpinner();
        detailsPanel.add((Component)this.spDvdEpisode, "cell 4 4,growx");
        TmmLabel lblDvdOrder = new TmmLabel(TmmResourceBundle.getString("metatag.dvdorder"));
        detailsPanel.add((Component)lblDvdOrder, "flowx,cell 6 4 2 1");
        this.cbDvdOrder = new JCheckBox("");
        detailsPanel.add((Component)this.cbDvdOrder, "cell 6 4 2 1");
        TmmLabel lblDisplaySeason = new TmmLabel(TmmResourceBundle.getString("metatag.displayseason"));
        detailsPanel.add((Component)lblDisplaySeason, "cell 0 5,alignx right");
        this.spDisplaySeason = new JSpinner();
        detailsPanel.add((Component)this.spDisplaySeason, "cell 1 5,growx");
        TmmLabel lblDisplayEpisode = new TmmLabel(TmmResourceBundle.getString("metatag.displayepisode"));
        detailsPanel.add((Component)lblDisplayEpisode, "cell 3 5,alignx right");
        this.spDisplayEpisode = new JSpinner();
        detailsPanel.add((Component)this.spDisplayEpisode, "cell 4 5,growx");
        TmmLabel lblPlot = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        detailsPanel.add((Component)lblPlot, "cell 0 6,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        detailsPanel.add((Component)scrollPane, "cell 1 6 7 1,grow");
        this.taPlot = new JTextArea();
        this.taPlot.setLineWrap(true);
        this.taPlot.setWrapStyleWord(true);
        scrollPane.setViewportView(this.taPlot);
        detailsPanel.add((Component)new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb")), "cell 9 0");
        LinkLabel lblThumbSize = new LinkLabel();
        detailsPanel.add((Component)lblThumbSize, "cell 9 0");
        FlatButton btnDeleteThumb = new FlatButton(IconManager.DELETE_GRAY);
        btnDeleteThumb.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteThumb.addActionListener(e -> {
            this.lblThumb.clearImage();
            this.tfThumb.setText("");
        });
        detailsPanel.add((Component)btnDeleteThumb, "cell 9 0");
        this.lblThumb = new ImageLabel();
        this.lblThumb.setDesiredAspectRatio(1.7777778f);
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HashMap<String, Object> newIds = new HashMap<String, Object>(TvShowEpisodeEditorDialog.this.episodeToEdit.getIds());
                newIds.put("seasonNr", TvShowEpisodeEditorDialog.this.spSeason.getValue());
                newIds.put("episodeNr", TvShowEpisodeEditorDialog.this.spEpisode.getValue());
                newIds.put("mediaFile", TvShowEpisodeEditorDialog.this.episodeToEdit.getMainFile());
                newIds.put("tvShowIds", TvShowEpisodeEditorDialog.this.episodeToEdit.getTvShow().getIds());
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowEpisodeEditorDialog.this, newIds, MediaArtwork.MediaArtworkType.THUMB, TvShowEpisodeEditorDialog.this.tvShowList.getDefaultArtworkScrapers(), TvShowEpisodeEditorDialog.this.lblThumb, MediaType.TV_EPISODE);
                if (Settings.getInstance().isImageChooserUseEntityFolder()) {
                    dialog.setOpenFolderPath(TvShowEpisodeEditorDialog.this.episodeToEdit.getPathNIO().toAbsolutePath().toString());
                }
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                TvShowEpisodeEditorDialog.this.updateArtworkUrl(TvShowEpisodeEditorDialog.this.lblThumb, TvShowEpisodeEditorDialog.this.tfThumb);
            }
        });
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        detailsPanel.add((Component)this.lblThumb, "cell 9 1 1 6,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblThumbSize, this.lblThumb, btnDeleteThumb, MediaFileType.THUMB));
        TmmLabel lblRating = new TmmLabel(TmmResourceBundle.getString("metatag.userrating"));
        detailsPanel.add((Component)lblRating, "cell 0 9,alignx right");
        this.spRating = new JSpinner();
        detailsPanel.add((Component)this.spRating, "cell 1 9,growx");
        TmmLabel lblRatingsT = new TmmLabel(TmmResourceBundle.getString("metatag.ratings"));
        detailsPanel.add((Component)lblRatingsT, "flowy,cell 0 10,alignx right,aligny top");
        JScrollPane scrollPaneRatings = new JScrollPane();
        detailsPanel.add((Component)scrollPaneRatings, "cell 1 10 5 2,grow");
        this.tableRatings = new MediaRatingTable(this.ratings);
        this.tableRatings.configureScrollPane(scrollPaneRatings);
        SquareIconButton btnAddRating = new SquareIconButton(new AddRatingAction());
        detailsPanel.add((Component)btnAddRating, "cell 0 10,alignx right,aligny top");
        SquareIconButton btnRemoveRating = new SquareIconButton(new RemoveRatingAction());
        detailsPanel.add((Component)btnRemoveRating, "cell 0 10,alignx right,aligny top");
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        detailsPanel.add((Component)lblNoteT, "cell 0 12,alignx right,aligny top");
        scrollPane = new JScrollPane();
        detailsPanel.add((Component)scrollPane, "cell 1 12 7 1,grow,wmin 0");
        this.taNote = new JTextArea();
        this.taNote.setLineWrap(true);
        this.taNote.setWrapStyleWord(true);
        this.taNote.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPane.setViewportView(this.taNote);
        JPanel details2Panel = new JPanel();
        tabbedPane.addTab(TmmResourceBundle.getString("metatag.details2"), details2Panel);
        details2Panel.setLayout((LayoutManager)new MigLayout("", "[][][20lp:50lp][][20lp:n][][300lp:300lp]", "[][][20lp:n][100lp:150lp,grow][][][][grow 200]"));
        TmmLabel lblDateAdded = new TmmLabel(TmmResourceBundle.getString("metatag.dateadded"));
        details2Panel.add((Component)lblDateAdded, "cell 0 0,alignx right");
        this.spDateAdded = new JSpinner(new SpinnerDateModel());
        details2Panel.add((Component)this.spDateAdded, "cell 1 0,growx");
        TmmLabel lblWatched = new TmmLabel(TmmResourceBundle.getString("metatag.watched"));
        details2Panel.add((Component)lblWatched, "flowx,cell 3 0,alignx right");
        this.chckbxWatched = new JCheckBox("");
        details2Panel.add((Component)this.chckbxWatched, "cell 3 0");
        TmmLabel lblMediasource = new TmmLabel(TmmResourceBundle.getString("metatag.source"));
        details2Panel.add((Component)lblMediasource, "cell 0 1,alignx right");
        this.cbMediaSource = new AutocompleteComboBox<MediaSource>(MediaSource.values());
        details2Panel.add(this.cbMediaSource, "cell 1 1,growx");
        TmmLabel lblTags = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        details2Panel.add((Component)lblTags, "flowy,cell 0 3,alignx right,aligny top");
        JScrollPane scrollPaneTags = new JScrollPane();
        details2Panel.add((Component)scrollPaneTags, "cell 1 3 3 1,grow");
        this.listTags = new JList();
        scrollPaneTags.setViewportView(this.listTags);
        SquareIconButton btnAddTag = new SquareIconButton(new AddTagAction());
        details2Panel.add((Component)btnAddTag, "cell 0 3,alignx right,aligny top");
        SquareIconButton btnRemoveTag = new SquareIconButton(new RemoveTagAction());
        details2Panel.add((Component)btnRemoveTag, "cell 0 3,alignx right,aligny top");
        SquareIconButton btnMoveTagUp = new SquareIconButton(new MoveTagUpAction());
        details2Panel.add((Component)btnMoveTagUp, "cell 0 3,alignx right,aligny top");
        SquareIconButton btnMoveTagDown = new SquareIconButton(new MoveTagDownAction());
        details2Panel.add((Component)btnMoveTagDown, "cell 0 3,alignx right,aligny top");
        this.cbTags = new AutocompleteComboBox<String>(this.tvShowList.getTagsInEpisodes());
        this.cbTags.setEditable(true);
        this.cbTagsAutoCompleteSupport = this.cbTags.getAutoCompleteSupport();
        details2Panel.add(this.cbTags, "cell 1 4 3 1,growx");
        InputMap im = this.cbTags.getInputMap(1);
        Object enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbTags.getActionMap().put(enterAction, new AddTagAction());
        TmmLabel label = new TmmLabel(TmmResourceBundle.getString("metatag.ids"));
        details2Panel.add((Component)label, "flowy,cell 5 3,alignx right,aligny top");
        JScrollPane scrollPaneIds = new JScrollPane();
        details2Panel.add((Component)scrollPaneIds, "cell 6 3,grow");
        this.tableIds = new MediaIdTable(this.ids);
        this.tableIds.configureScrollPane(scrollPaneIds);
        JButton btnAddId = new JButton(new AddIdAction());
        details2Panel.add((Component)btnAddId, "cell 5 3,alignx right,aligny top");
        JButton btnRemoveId = new JButton(new RemoveIdAction());
        details2Panel.add((Component)btnRemoveId, "cell 5 3,alignx right,aligny top");
        TmmLabel lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        details2Panel.add((Component)lblThumbT, "cell 0 6,alignx right");
        this.tfThumb = new JTextField();
        details2Panel.add((Component)this.tfThumb, "cell 1 6 6 1,growx");
        this.tfThumb.setColumns(10);
        JPanel crewPanel = new JPanel();
        tabbedPane.addTab(TmmResourceBundle.getString("movie.edit.castandcrew"), null, crewPanel, null);
        crewPanel.setLayout((LayoutManager)new MigLayout("", "[][150lp:300lp,grow][20lp:n][][150lp:300lp,grow]", "[100lp:250lp][20lp:n][100lp:200lp]"));
        TmmLabel lblGuests = new TmmLabel(TmmResourceBundle.getString("metatag.guests"));
        crewPanel.add((Component)lblGuests, "flowy,cell 0 0,alignx right,aligny top");
        this.tableGuests = new PersonTable(this.guests, true);
        scrollPane = new JScrollPane();
        this.tableGuests.configureScrollPane(scrollPane);
        crewPanel.add((Component)scrollPane, "cell 1 0,grow");
        TmmLabel lblDirectorsT = new TmmLabel(TmmResourceBundle.getString("metatag.directors"));
        crewPanel.add((Component)lblDirectorsT, "flowy,cell 0 2,alignx right,aligny top");
        this.tableDirectors = new PersonTable(this.directors, true);
        scrollPane = new JScrollPane();
        this.tableDirectors.configureScrollPane(scrollPane);
        crewPanel.add((Component)scrollPane, "cell 1 2,grow");
        TmmLabel lblWritersT = new TmmLabel(TmmResourceBundle.getString("metatag.writers"));
        crewPanel.add((Component)lblWritersT, "flowy,cell 3 2,alignx right,aligny top");
        this.tableWriters = new PersonTable(this.writers, true);
        scrollPane = new JScrollPane();
        this.tableWriters.configureScrollPane(scrollPane);
        crewPanel.add((Component)scrollPane, "cell 4 2,grow");
        SquareIconButton btnAddGuest = new SquareIconButton(new AddGuestAction());
        crewPanel.add((Component)btnAddGuest, "cell 0 0,alignx right");
        SquareIconButton btnRemoveGuest = new SquareIconButton(new RemoveGuestAction());
        crewPanel.add((Component)btnRemoveGuest, "cell 0 0,alignx right");
        SquareIconButton btnMoveGuestUp = new SquareIconButton(new MoveGuestUpAction());
        crewPanel.add((Component)btnMoveGuestUp, "cell 0 0,alignx right");
        SquareIconButton btnMoveGuestDown = new SquareIconButton(new MoveGuestDownAction());
        crewPanel.add((Component)btnMoveGuestDown, "cell 0 0,alignx right,aligny top");
        SquareIconButton btnAddDirector = new SquareIconButton(new AddDirectorAction());
        crewPanel.add((Component)btnAddDirector, "cell 0 2,alignx right");
        SquareIconButton btnRemoveDirector = new SquareIconButton(new RemoveDirectorAction());
        crewPanel.add((Component)btnRemoveDirector, "cell 0 2,alignx right");
        SquareIconButton btnMoveDirectorUp = new SquareIconButton(new MoveDirectorUpAction());
        crewPanel.add((Component)btnMoveDirectorUp, "cell 0 2,alignx right");
        SquareIconButton btnMoveDirectorDown = new SquareIconButton(new MoveDirectorDownAction());
        crewPanel.add((Component)btnMoveDirectorDown, "cell 0 2,alignx right,aligny top");
        SquareIconButton btnAddWriter = new SquareIconButton(new AddWriterAction());
        crewPanel.add((Component)btnAddWriter, "cell 3 2,alignx right");
        SquareIconButton btnRemoveWriter = new SquareIconButton(new RemoveWriterAction());
        crewPanel.add((Component)btnRemoveWriter, "cell 3 2,alignx right");
        SquareIconButton btnMoveWriterUp = new SquareIconButton(new MoveWriterUpAction());
        crewPanel.add((Component)btnMoveWriterUp, "cell 3 2,alignx right");
        SquareIconButton btnMoveWriterDown = new SquareIconButton(new MoveWriterDownAction());
        crewPanel.add((Component)btnMoveWriterDown, "cell 3 2,alignx right,aligny top");
        this.mediaFilesPanel = new MediaFileEditorPanel(this.mediaFiles);
        tabbedPane.addTab(TmmResourceBundle.getString("metatag.mediafiles"), null, this.mediaFilesPanel, null);
        JPanel scrapePanel = new JPanel();
        scrapePanel.setOpaque(false);
        this.cbScraper = new MediaScraperComboBox(this.tvShowList.getAvailableMediaScrapers().stream().filter(scraper -> !(scraper.getMediaProvider() instanceof KodiTvShowMetadataProvider)).collect(Collectors.toList()));
        MediaScraper defaultScraper = this.tvShowList.getDefaultMediaScraper();
        scrapePanel.setLayout((LayoutManager)new MigLayout("", "[100lp:200lp][][][grow]", "[]"));
        this.cbScraper.setSelectedItem(defaultScraper);
        scrapePanel.add((Component)this.cbScraper, "cell 0 0, growx, wmin 0");
        JButton btnScrape = new JButton(new ScrapeAction());
        scrapePanel.add((Component)btnScrape, "cell 1 0");
        JButton btnSearch = new JButton(new SearchAction());
        scrapePanel.add((Component)btnSearch, "cell 2 0");
        this.setBottomInformationPanel(scrapePanel);
        if (this.queueSize > 1) {
            JButton abortButton = new JButton(new AbortQueueAction());
            this.addButton(abortButton);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new NavigateBackAction());
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new DiscardAction());
        cancelButton.addActionListener(e -> this.mediaFilesPanel.cancelTask());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new ChangeEpisodeAction());
        okButton.addActionListener(e -> this.mediaFilesPanel.cancelTask());
        this.addDefaultButton(okButton);
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    private void processArtwork(MediaFileType type, ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{imageLabel.getImagePath(), imageLabel.getImageUrl()}) && StringUtils.isNotBlank((CharSequence)this.episodeToEdit.getArtworkFilename(type))) {
            this.episodeToEdit.deleteMediaFiles(type);
        }
        if (StringUtils.isNotEmpty((CharSequence)textField.getText()) && !textField.getText().equals(this.episodeToEdit.getArtworkUrl(type))) {
            this.episodeToEdit.setArtworkUrl(textField.getText(), type);
            this.episodeToEdit.downloadArtwork(type);
        } else if (StringUtils.isEmpty((CharSequence)textField.getText())) {
            this.episodeToEdit.removeArtworkUrl(type);
        } else if (StringUtils.isBlank((CharSequence)this.episodeToEdit.getArtworkFilename(type))) {
            this.episodeToEdit.downloadArtwork(type);
        }
    }

    protected BindingGroup initDataBindings() {
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tags, this.listTags);
        jListBinding.bind();
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)jListBinding);
        return bindingGroup;
    }

    @Override
    public void dispose() {
        if (this.mediaFilesPanel != null) {
            this.mediaFilesPanel.unbindBindings();
        }
        if (this.dpFirstAired != null) {
            this.dpFirstAired.cleanup();
        }
        super.dispose();
    }

    private void setImageSizeAndCreateLink(LinkLabel lblSize, ImageLabel imageLabel, JButton buttonDelete, MediaFileType type) {
        TmmUIHelper.createLinkForImage(lblSize, imageLabel);
        if (imageLabel.getOriginalImageSize().width == 0 && imageLabel.getOriginalImageSize().height == 0) {
            lblSize.setText("");
            lblSize.setVisible(false);
            buttonDelete.setVisible(false);
            return;
        }
        Dimension dimension = this.episodeToEdit.getArtworkDimension(type);
        if (dimension.width == 0 && dimension.height == 0) {
            lblSize.setText(imageLabel.getOriginalImageSize().width + "x" + imageLabel.getOriginalImageSize().height);
        } else {
            lblSize.setText(dimension.width + "x" + dimension.height);
        }
        lblSize.setVisible(true);
        buttonDelete.setVisible(true);
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    private class NavigateBackAction
    extends AbstractAction {
        private static final long serialVersionUID = -1652218154720642310L;

        public NavigateBackAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.back"));
            this.putValue("SmallIcon", IconManager.BACK_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.navigateBack = true;
            TvShowEpisodeEditorDialog.this.setVisible(false);
        }
    }

    private class MoveWriterDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        MoveWriterDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movewriterdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableWriters.getSelectedRow();
            if (row < TvShowEpisodeEditorDialog.this.writers.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.writers.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.tableWriters.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveWriterUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        MoveWriterUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movewriterup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableWriters.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.writers.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.tableWriters.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveWriterAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826920821356196L;

        RemoveWriterAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.writer.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableWriters.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableWriters.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.writers.remove(row);
            }
        }
    }

    private class AddWriterAction
    extends AbstractAction {
        private static final long serialVersionUID = -8929331442958057771L;

        AddWriterAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.writer.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person person = new Person(Person.Type.DIRECTOR, TmmResourceBundle.getString("writer.name.unknown"), "Writer");
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(TvShowEpisodeEditorDialog.this.tableWriters), TmmResourceBundle.getString("cast.writer.add"), person);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)person.getName()) && !person.getName().equals(TmmResourceBundle.getString("writer.name.unknown"))) {
                TvShowEpisodeEditorDialog.this.writers.add(0, (Object)person);
            }
        }
    }

    private class MoveDirectorDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        MoveDirectorDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movedirectordown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableDirectors.getSelectedRow();
            if (row < TvShowEpisodeEditorDialog.this.directors.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.directors.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.tableDirectors.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveDirectorUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        MoveDirectorUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movedirectorup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableDirectors.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.directors.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.tableDirectors.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveDirectorAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826920821356196L;

        RemoveDirectorAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.director.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableDirectors.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableDirectors.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.directors.remove(row);
            }
        }
    }

    private class AddDirectorAction
    extends AbstractAction {
        private static final long serialVersionUID = -8929331442958057771L;

        AddDirectorAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.director.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person person = new Person(Person.Type.DIRECTOR, TmmResourceBundle.getString("director.name.unknown"), "Director");
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(TvShowEpisodeEditorDialog.this.tableDirectors), TmmResourceBundle.getString("cast.director.add"), person);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)person.getName()) && !person.getName().equals(TmmResourceBundle.getString("director.name.unknown"))) {
                TvShowEpisodeEditorDialog.this.directors.add(0, (Object)person);
            }
        }
    }

    private class MoveGuestDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        MoveGuestDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.guest.movedown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableGuests.getSelectedRow();
            if (row < TvShowEpisodeEditorDialog.this.guests.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.guests.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.tableGuests.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveGuestUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        MoveGuestUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.guest.moveup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableGuests.getSelectedRow();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.guests.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.tableGuests.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveGuestAction
    extends AbstractAction {
        private static final long serialVersionUID = 6970920169867315771L;

        RemoveGuestAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.guest.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableGuests.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableGuests.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.guests.remove(row);
            }
        }
    }

    private class AddGuestAction
    extends AbstractAction {
        private static final long serialVersionUID = -5879601617842300526L;

        AddGuestAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("cast.guest.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person actor = new Person(Person.Type.ACTOR, TmmResourceBundle.getString("cast.actor.unknown"), TmmResourceBundle.getString("cast.role.unknown"));
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(TvShowEpisodeEditorDialog.this.tableGuests), TmmResourceBundle.getString("cast.guest.add"), actor);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)actor.getName()) && !actor.getName().equals(TmmResourceBundle.getString("cast.actor.unknown"))) {
                TvShowEpisodeEditorDialog.this.guests.add(0, (Object)actor);
            }
        }
    }

    private class RemoveIdAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826950827356996L;

        public RemoveIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableIds.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableIds.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.ids.remove(row);
            }
        }
    }

    private class AddIdAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414553349267L;

        public AddIdAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("id.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaIdTable.MediaId mediaId = new MediaIdTable.MediaId();
            IdEditorDialog dialog = new IdEditorDialog(SwingUtilities.getWindowAncestor(TvShowEpisodeEditorDialog.this.tableIds), TmmResourceBundle.getString("id.add"), mediaId, ScraperType.TV_SHOW);
            dialog.setVisible(true);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mediaId.key, mediaId.value})) {
                TvShowEpisodeEditorDialog.this.ids.add((Object)mediaId);
            }
        }
    }

    private class MoveTagDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        MoveTagDownAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movetagdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.listTags.getSelectedIndex();
            if (row < TvShowEpisodeEditorDialog.this.tags.size() - 1) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.tags.subList(row, row + 2), -1);
                TvShowEpisodeEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveTagUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        MoveTagUpAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("movie.edit.movetagup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.listTags.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(TvShowEpisodeEditorDialog.this.tags.subList(row - 1, row + 1), 1);
                TvShowEpisodeEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveTagAction
    extends AbstractAction {
        private static final long serialVersionUID = -4799506776650330500L;

        RemoveTagAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tag.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<String> selectedTags = TvShowEpisodeEditorDialog.this.listTags.getSelectedValuesList();
            for (String tag : selectedTags) {
                TvShowEpisodeEditorDialog.this.tags.remove(tag);
            }
        }
    }

    private class AddTagAction
    extends AbstractAction {
        private static final long serialVersionUID = 5968029647764173330L;

        AddTagAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("tag.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            String newTag = (String)TvShowEpisodeEditorDialog.this.cbTags.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)newTag)) {
                return;
            }
            Component editorComponent = TvShowEpisodeEditorDialog.this.cbTags.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            boolean tagFound = false;
            for (String tag : TvShowEpisodeEditorDialog.this.tags) {
                if (!tag.equals(newTag)) continue;
                tagFound = true;
                break;
            }
            if (!tagFound) {
                TvShowEpisodeEditorDialog.this.tags.add(newTag);
                if (editorComponent instanceof JTextField) {
                    TvShowEpisodeEditorDialog.this.cbTagsAutoCompleteSupport.setFirstItem("");
                    TvShowEpisodeEditorDialog.this.cbTags.setSelectedIndex(0);
                    TvShowEpisodeEditorDialog.this.cbTagsAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveRatingAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079821950827356996L;

        RemoveRatingAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("rating.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TvShowEpisodeEditorDialog.this.tableRatings.getSelectedRow();
            if (row > -1) {
                row = TvShowEpisodeEditorDialog.this.tableRatings.convertRowIndexToModel(row);
                TvShowEpisodeEditorDialog.this.ratings.remove(row);
            }
        }
    }

    private class AddRatingAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414533349267L;

        AddRatingAction() {
            this.putValue("ShortDescription", TmmResourceBundle.getString("rating.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaRatingTable.Rating rating = new MediaRatingTable.Rating("");
            rating.maxValue = 10;
            rating.votes = 1;
            RatingEditorDialog dialog = new RatingEditorDialog(SwingUtilities.getWindowAncestor(TvShowEpisodeEditorDialog.this.tableRatings), TmmResourceBundle.getString("rating.add"), rating);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)rating.key) && rating.value > 0.0f && rating.maxValue > 0 && rating.votes > 0) {
                TvShowEpisodeEditorDialog.this.ratings.add((Object)rating);
            }
        }
    }

    private class ScrapeTask
    extends SwingWorker<Void, Void> {
        private final MediaScraper mediaScraper;
        private MediaMetadata metadata = null;

        ScrapeTask(MediaScraper mediaScraper) {
            this.mediaScraper = mediaScraper;
        }

        @Override
        protected Void doInBackground() {
            TvShowEpisodeEditorDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            TvShowEpisodeSearchAndScrapeOptions options = new TvShowEpisodeSearchAndScrapeOptions(TvShowEpisodeEditorDialog.this.episodeToEdit.getTvShow().getIds());
            options.setLanguage(TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
            for (MediaIdTable.MediaId mediaId : TvShowEpisodeEditorDialog.this.ids) {
                options.setId(mediaId.key, mediaId.value);
            }
            options.setId("seasonNr", TvShowEpisodeEditorDialog.this.spSeason.getValue().toString());
            options.setId("episodeNr", TvShowEpisodeEditorDialog.this.spEpisode.getValue().toString());
            options.setId("dvdSeasonNr", TvShowEpisodeEditorDialog.this.spDvdSeason.getValue().toString());
            options.setId("dvdEpisodeNr", TvShowEpisodeEditorDialog.this.spDvdEpisode.getValue().toString());
            try {
                LOGGER.info("=====================================================");
                LOGGER.info("Scraper metadata with scraper: {}", (Object)this.mediaScraper.getMediaProvider().getProviderInfo().getId());
                LOGGER.info(options.toString());
                LOGGER.info("=====================================================");
                this.metadata = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getMetadata(options);
            }
            catch (MissingIdException e) {
                LOGGER.warn("missing id for scrape");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, TvShowEpisodeEditorDialog.this.episodeToEdit, "scraper.error.missingid"));
            }
            catch (NothingFoundException ignored) {
                LOGGER.debug("nothing found");
            }
            catch (ScrapeException e) {
                LOGGER.error("getMetadata", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)TvShowEpisodeEditorDialog.this.episodeToEdit, "message.scrape.metadataepisodefailed", new String[]{":", e.getLocalizedMessage()}));
            }
            TvShowEpisodeEditorDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }

        @Override
        protected void done() {
            super.done();
            if (this.metadata == null || StringUtils.isBlank((CharSequence)this.metadata.getTitle())) {
                JOptionPane.showMessageDialog(TvShowEpisodeEditorDialog.this, TmmResourceBundle.getString("message.scrape.tvshowepisodefailed"));
            } else {
                TvShowEpisodeEditorDialog.this.tfTitle.setText(this.metadata.getTitle());
                TvShowEpisodeEditorDialog.this.tfOriginalTitle.setText(this.metadata.getOriginalTitle());
                TvShowEpisodeEditorDialog.this.taPlot.setText(this.metadata.getPlot());
                TvShowEpisodeEditorDialog.this.dpFirstAired.setDate(this.metadata.getReleaseDate());
                TvShowEpisodeEditorDialog.this.spSeason.setValue(this.metadata.getSeasonNumber());
                TvShowEpisodeEditorDialog.this.spEpisode.setValue(this.metadata.getEpisodeNumber());
                TvShowEpisodeEditorDialog.this.spDvdSeason.setValue(this.metadata.getDvdSeasonNumber());
                TvShowEpisodeEditorDialog.this.spDvdEpisode.setValue(this.metadata.getDvdEpisodeNumber());
                TvShowEpisodeEditorDialog.this.spDisplayEpisode.setValue(this.metadata.getDisplayEpisodeNumber());
                TvShowEpisodeEditorDialog.this.spDisplaySeason.setValue(this.metadata.getDisplaySeasonNumber());
                TvShowEpisodeEditorDialog.this.ratings.clear();
                TvShowEpisodeEditorDialog.this.ratings.addAll(MediaRatingTable.convertRatingMapToEventList(this.metadata.getRatings()));
                TvShowEpisodeEditorDialog.this.tags.clear();
                TvShowEpisodeEditorDialog.this.tags.addAll(this.metadata.getTags());
                TvShowEpisodeEditorDialog.this.guests.clear();
                TvShowEpisodeEditorDialog.this.directors.clear();
                TvShowEpisodeEditorDialog.this.writers.clear();
                for (Person member : this.metadata.getCastMembers()) {
                    switch (member.getType()) {
                        case ACTOR: {
                            TvShowEpisodeEditorDialog.this.guests.add((Object)new Person(member));
                            break;
                        }
                        case DIRECTOR: {
                            TvShowEpisodeEditorDialog.this.directors.add((Object)new Person(member));
                            break;
                        }
                        case WRITER: {
                            TvShowEpisodeEditorDialog.this.writers.add((Object)new Person(member));
                            break;
                        }
                    }
                }
                MediaArtwork ma = this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).stream().findFirst().orElse(null);
                if (ma != null) {
                    TvShowEpisodeEditorDialog.this.lblThumb.setImageUrl(ma.getDefaultUrl());
                    TvShowEpisodeEditorDialog.this.tfThumb.setText(ma.getDefaultUrl());
                }
            }
        }
    }

    private class AbortQueueAction
    extends AbstractAction {
        private static final long serialVersionUID = -7652218354710642510L;

        AbortQueueAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.abortqueue"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.edit.abortqueue.desc"));
            this.putValue("SmallIcon", IconManager.STOP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.continueQueue = false;
            TvShowEpisodeEditorDialog.this.setVisible(false);
        }
    }

    private class DiscardAction
    extends AbstractAction {
        private static final long serialVersionUID = -5581329896797961536L;

        DiscardAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.setVisible(false);
        }
    }

    private class ChangeEpisodeAction
    extends AbstractAction {
        private static final long serialVersionUID = -4799506776650330500L;

        ChangeEpisodeAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.ok"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowEpisodeEditorDialog.this.episodeToEdit.setTitle(TvShowEpisodeEditorDialog.this.tfTitle.getText());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setOriginalTitle(TvShowEpisodeEditorDialog.this.tfOriginalTitle.getText());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDvdOrder(TvShowEpisodeEditorDialog.this.cbDvdOrder.isSelected());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setAiredSeason((Integer)TvShowEpisodeEditorDialog.this.spSeason.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setAiredEpisode((Integer)TvShowEpisodeEditorDialog.this.spEpisode.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDvdSeason((Integer)TvShowEpisodeEditorDialog.this.spDvdSeason.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDvdEpisode((Integer)TvShowEpisodeEditorDialog.this.spDvdEpisode.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDisplaySeason((Integer)TvShowEpisodeEditorDialog.this.spDisplaySeason.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDisplayEpisode((Integer)TvShowEpisodeEditorDialog.this.spDisplayEpisode.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setPlot(TvShowEpisodeEditorDialog.this.taPlot.getText());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setNote(TvShowEpisodeEditorDialog.this.taNote.getText());
            Object mediaSource = TvShowEpisodeEditorDialog.this.cbMediaSource.getSelectedItem();
            if (mediaSource instanceof MediaSource) {
                TvShowEpisodeEditorDialog.this.episodeToEdit.setMediaSource((MediaSource)mediaSource);
            } else if (mediaSource instanceof String) {
                TvShowEpisodeEditorDialog.this.episodeToEdit.setMediaSource(MediaSource.getMediaSource((String)mediaSource));
            } else {
                TvShowEpisodeEditorDialog.this.episodeToEdit.setMediaSource(MediaSource.UNKNOWN);
            }
            for (Iterator id : TvShowEpisodeEditorDialog.this.ids) {
                try {
                    Integer value = Integer.parseInt(((MediaIdTable.MediaId)((Object)id)).value);
                    TvShowEpisodeEditorDialog.this.episodeToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, value);
                }
                catch (NumberFormatException ex) {
                    TvShowEpisodeEditorDialog.this.episodeToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, ((MediaIdTable.MediaId)((Object)id)).value);
                }
            }
            ArrayList<String> removeIds = new ArrayList<String>();
            for (Map.Entry entry : TvShowEpisodeEditorDialog.this.episodeToEdit.getIds().entrySet()) {
                MediaIdTable.MediaId id = new MediaIdTable.MediaId((String)entry.getKey());
                if (TvShowEpisodeEditorDialog.this.ids.contains((Object)id)) continue;
                removeIds.add((String)entry.getKey());
            }
            for (String id : removeIds) {
                TvShowEpisodeEditorDialog.this.episodeToEdit.setId(id, null);
            }
            MediaFileEditorPanel.syncMediaFiles(TvShowEpisodeEditorDialog.this.mediaFiles, TvShowEpisodeEditorDialog.this.episodeToEdit.getMediaFiles());
            TvShowEpisodeEditorDialog.this.episodeToEdit.fireEventForChangedMediaInformation();
            HashMap<String, MediaRating> ratings = new HashMap<String, MediaRating>();
            if ((Double)TvShowEpisodeEditorDialog.this.spRating.getValue() > 0.0) {
                ratings.put("user", new MediaRating("user", (Double)TvShowEpisodeEditorDialog.this.spRating.getValue(), 1, 10));
            }
            for (MediaRatingTable.Rating mediaRating : TvShowEpisodeEditorDialog.this.ratings) {
                if (!StringUtils.isNotBlank((CharSequence)mediaRating.key) || !(mediaRating.value > 0.0f) || mediaRating.votes <= 0) continue;
                MediaRating rating = new MediaRating(mediaRating.key, mediaRating.value, mediaRating.votes, mediaRating.maxValue);
                ratings.put(mediaRating.key, rating);
            }
            TvShowEpisodeEditorDialog.this.episodeToEdit.setRatings(ratings);
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDateAdded((Date)TvShowEpisodeEditorDialog.this.spDateAdded.getValue());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setFirstAired(TvShowEpisodeEditorDialog.this.dpFirstAired.getDate());
            TvShowEpisodeEditorDialog.this.episodeToEdit.setWatched(TvShowEpisodeEditorDialog.this.chckbxWatched.isSelected());
            TvShowEpisodeEditorDialog.this.episodeToEdit.removeActors();
            TvShowEpisodeEditorDialog.this.episodeToEdit.setActors((List<Person>)TvShowEpisodeEditorDialog.this.guests);
            TvShowEpisodeEditorDialog.this.episodeToEdit.removeDirectors();
            TvShowEpisodeEditorDialog.this.episodeToEdit.setDirectors((List<Person>)TvShowEpisodeEditorDialog.this.directors);
            TvShowEpisodeEditorDialog.this.episodeToEdit.removeWriters();
            TvShowEpisodeEditorDialog.this.episodeToEdit.setWriters((List<Person>)TvShowEpisodeEditorDialog.this.writers);
            TvShowEpisodeEditorDialog.this.processArtwork(MediaFileType.THUMB, TvShowEpisodeEditorDialog.this.lblThumb, TvShowEpisodeEditorDialog.this.tfThumb);
            TvShowEpisodeEditorDialog.this.episodeToEdit.setTags(TvShowEpisodeEditorDialog.this.tags);
            TvShowEpisodeEditorDialog.this.episodeToEdit.writeNFO();
            TvShowEpisodeEditorDialog.this.episodeToEdit.saveToDb();
            TvShowEpisodeEditorDialog.this.setVisible(false);
        }
    }

    private class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = -4799506776650330500L;

        SearchAction() {
            this.putValue("Name", TmmResourceBundle.getString("tvshowepisodechooser.search"));
            this.putValue("SmallIcon", IconManager.SEARCH_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaScraper scraper = (MediaScraper)TvShowEpisodeEditorDialog.this.cbScraper.getSelectedItem();
            TvShowEpisodeChooserDialog dialog = new TvShowEpisodeChooserDialog((JDialog)TvShowEpisodeEditorDialog.this, TvShowEpisodeEditorDialog.this.episodeToEdit, scraper);
            dialog.setLocationRelativeTo(TvShowEpisodeEditorDialog.this);
            dialog.setVisible(true);
            MediaMetadata metadata = dialog.getMetadata();
            if (metadata != null && metadata.getSeasonNumber() > -1 && metadata.getEpisodeNumber() > -1) {
                TvShowEpisodeEditorDialog.this.tfTitle.setText(metadata.getTitle());
                TvShowEpisodeEditorDialog.this.tfOriginalTitle.setText(metadata.getOriginalTitle());
                TvShowEpisodeEditorDialog.this.taPlot.setText(metadata.getPlot());
                TvShowEpisodeEditorDialog.this.spEpisode.setValue(metadata.getEpisodeNumber());
                TvShowEpisodeEditorDialog.this.spSeason.setValue(metadata.getSeasonNumber());
                TvShowEpisodeEditorDialog.this.spDvdEpisode.setValue(metadata.getDvdEpisodeNumber());
                TvShowEpisodeEditorDialog.this.spDvdSeason.setValue(metadata.getDvdSeasonNumber());
                TvShowEpisodeEditorDialog.this.ids.clear();
                TvShowEpisodeEditorDialog.this.ids.addAll(MediaIdTable.convertIdMapToEventList(metadata.getIds()));
                TvShowEpisodeEditorDialog.this.guests.clear();
                TvShowEpisodeEditorDialog.this.writers.clear();
                TvShowEpisodeEditorDialog.this.directors.clear();
                for (Person member : metadata.getCastMembers()) {
                    switch (member.getType()) {
                        case ACTOR: {
                            TvShowEpisodeEditorDialog.this.guests.add((Object)new Person(member));
                            break;
                        }
                        case DIRECTOR: {
                            TvShowEpisodeEditorDialog.this.directors.add((Object)new Person(member));
                            break;
                        }
                        case WRITER: {
                            TvShowEpisodeEditorDialog.this.writers.add((Object)new Person(member));
                            break;
                        }
                    }
                }
                MediaArtwork ma = metadata.getMediaArt(MediaArtwork.MediaArtworkType.THUMB).stream().findFirst().orElse(null);
                if (ma != null) {
                    TvShowEpisodeEditorDialog.this.tfThumb.setText(ma.getDefaultUrl());
                    TvShowEpisodeEditorDialog.this.lblThumb.setImageUrl(ma.getDefaultUrl());
                }
            }
        }
    }

    private class ScrapeAction
    extends AbstractAction {
        private static final long serialVersionUID = -4799506776650330500L;

        ScrapeAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.scrape"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaScraper scraper = (MediaScraper)TvShowEpisodeEditorDialog.this.cbScraper.getSelectedItem();
            ScrapeTask task = new ScrapeTask(scraper);
            task.execute();
        }
    }
}

